﻿using VT.FW.DB;
using Mall.Common.Enum.User;
using System;
using System.Collections.Generic;
using System.Text;

namespace Mall.Model.Entity.Miai
{
    /// <summary>
    /// 活动表实体
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_Miai_Activity
    {

        /// <summary>
        /// Id
        /// </summary>        
        public int Id
        {
            get;
            set;
        }

        /// <summary>
        /// 版块id
        /// </summary>
        public int ForumId { get; set; }

        /// <summary>
        /// 活动名称
        /// </summary>        
        public string ActivityTitle
        {
            get;
            set;
        }

        /// <summary>
        /// 活动内容
        /// </summary>
        public string Content { get; set; }

        /// <summary>
        /// 图片列表
        /// </summary>
        public string Images { get; set; }

        /// <summary>
        /// 用户id
        /// </summary>
        public int UserId { get; set; }

        /// <summary>
        /// 是否开启报名   1是  2否
        /// </summary>
        public int IsOpenEnroll { get; set; }

        /// <summary>
        /// 报名截止日期
        /// </summary>
        public DateTime? Deadline { get; set; }

        /// <summary>
        /// 删除状态
        /// </summary>
        public int Status { get; set; }

        /// <summary>
        /// 商户号id
        /// </summary>        
        public int TenantId
        {
            get;
            set;
        }

        /// <summary>
        /// 小程序id
        /// </summary>
        public int MallBaseId { get; set; }

        /// <summary>
        /// 创建时间
        /// </summary>        
        public DateTime CreateDate
        {
            get;
            set;
        }

        /// <summary>
        /// 修改时间
        /// </summary>        
        public DateTime UpdateDate
        {
            get;
            set;
        }

        /// <summary>
        /// 标签
        /// </summary>
        public string Label { get; set; }

        /// <summary>
        /// 活动开始时间
        /// </summary>
        public DateTime StartTime { get; set; }

        /// <summary>
        /// 活动结束时间
        /// </summary>
        public DateTime EndTime { get; set; }

        /// <summary>
        /// 男数量
        /// </summary>
        public int ManNum { get; set; }

        /// <summary>
        /// 女数量
        /// </summary>
        public int WoManNum { get; set; }

        /// <summary>
        /// 经纬度（逗号分隔）
        /// </summary>
        public string LonLat { get; set; }

        /// <summary>
        /// 位置名称
        /// </summary>
        public string LocationName { get; set; }
    }
}
