﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Mall.CacheManager.User;
using Mall.Common.API;
using Mall.Common.Enum.Goods;
using Mall.Common.Enum.User;
using Mall.Common.Plugin;
using Mall.Model.Extend.TradePavilion;
using Mall.Module.TradePavilion;
using Mall.WebApi.Filter;
using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Cors;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Newtonsoft.Json;
using Newtonsoft.Json.Linq;

namespace Mall.WebApi.Controllers.TradePavilion
{
    [Route("api/[controller]/[action]")]
    [ApiExceptionFilter]
    [ApiController]
    [EnableCors("AllowCors")]
    public class AppletTradeController : BaseController
    {
        /// <summary>
        /// 联系人处理类对象
        /// </summary>
        private readonly ContractModule module = new ContractModule();

        /// <summary>
        /// 投资采购处理类对象
        /// </summary>
        private readonly InvestmentProcurementModule procurementModule = new InvestmentProcurementModule();

        /// <summary>
        /// 公司信息处理类对象
        /// </summary>
        private readonly CompanyModule companyModule = new CompanyModule();


        /// <summary>
        /// 商会活动处理类对象
        /// </summary>
        private readonly CommerceActivityModule activityModule = new CommerceActivityModule();

        /// <summary>
        /// 商会活动报名处理类对象
        /// </summary>
        private readonly CommerceConsultModule consultModule = new CommerceConsultModule();

        /// <summary>
        /// 新闻处理类对象
        /// </summary>
        private readonly CommerceNewsModule commerceNewsModule = new CommerceNewsModule();

        /// <summary>
        /// Fat资料处理类对象
        /// </summary>
        private readonly CommerceAskModule askModule = new CommerceAskModule();

        /// <summary>
        /// 活动评论处理类对象
        /// </summary>
        private readonly CommerceCommentModule commerceCommentModule = new CommerceCommentModule();

        #region 公司信息管理

        /// <summary>
        /// 新增修改公司信息
        /// </summary>
        /// <returns></returns>
        public ApiResult SetCompany()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var extModel = new RB_Company_Extend()
            {
                CompanyId = parms.GetInt("CompanyId"),
                CompanyName = parms.GetStringValue("CompanyName"),
                CompanyEnName = parms.GetStringValue("CompanyEnName"),
                Principal = parms.GetStringValue("Principal"),
                Mobile = parms.GetStringValue("Mobile"),
                EMail = parms.GetStringValue("EMail"),
                LegalPerson = parms.GetStringValue("LegalPerson"),
                WechatNo = parms.GetStringValue("WechatNo"),
                CompanyIntro = parms.GetStringValue("CompanyIntro"),
                DomainUrl = parms.GetStringValue("DomainUrl"),
                FoundingTime = parms.GetDateTime("FoundingTime"),
                EmployeeNum = parms.GetInt("EmployeeNum"),
                AnnualSales = parms.GetDecimal("AnnualSales"),
                AnnualImport = parms.GetDecimal("AnnualImport"),
                Address = parms.GetStringValue("Address"),
                EnAddress = parms.GetStringValue("EnAddress"),
                Industry = parms.GetStringValue("Industry"),
                ExportCountry = parms.GetStringValue("ExportCountry"),
                ImportCountry = parms.GetStringValue("ImportCountry"),
                ImportCategory = parms.GetStringValue("ImportCategory"),
                OtherInfo = parms.GetStringValue("OtherInfo"),
            };
            var userInfo = AppletUserInfo;
            extModel.Status = Common.Enum.DateStateEnum.Normal;
            extModel.MallBaseId = userInfo.MallBaseId;
            extModel.TenantId = userInfo.TenantId;
            Int32.TryParse(userInfo.UserId.ToString(), out int Uid);
            extModel.CreateBy = Uid;
            extModel.CreateDate = DateTime.Now;
            extModel.UpdateBy = Uid;
            extModel.UpdateDate = DateTime.Now;
            var flag = companyModule.SetCompanyModule(extModel);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }

        /// <summary>
        /// 获取当前用户的公司信息实体
        /// </summary>
        /// <returns></returns>
        public ApiResult GetUserCompany()
        {
            var userInfo = AppletUserInfo;
            var model = companyModule.GetCompanyByUserIdModule(userInfo.UserId);
            return ApiResult.Success(data: model);
        }

        #endregion

        #region 新闻管理

        /// <summary>
        /// 获取新闻前几条
        /// </summary>
        /// <returns></returns>
        public ApiResult GetNewsPage()
        {
            ResultPageModel pageModel = JsonConvert.DeserializeObject<ResultPageModel>(RequestParm.msg.ToString());
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var query = new RB_Commerce_News_Extend()
            {
                Title = parms.GetStringValue("Title"),
                Type=parms.GetInt("Type")
            };
            var userInfo = AppletUserInfo;
            query.MallBaseId = RequestParm.MallBaseId;
            query.TenantId = userInfo?.TenantId ?? 0;
            var list = commerceNewsModule.GetCommerceNewsPageListModule(pageModel.pageIndex, pageModel.pageSize, out long rowsCount, query);
            pageModel.count = Convert.ToInt32(rowsCount);
            pageModel.pageData = list;
            return ApiResult.Success(data: pageModel);
        }

        /// <summary>
        /// 获取新闻信息详情
        /// </summary>
        /// <returns></returns>
        public ApiResult GetCommerceNews()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var Id = parms.GetInt("Id", 0);
            var extModel = commerceNewsModule.GetCommerceNewsModule(Id);
            return ApiResult.Success(data: extModel);
        }
        #endregion

        #region 投资采购管理

        /// <summary>
        /// 获取投资采购分页列表
        /// </summary>
        /// <returns></returns>
        public ApiResult GetInvestmentProcurementPage()
        {
            ResultPageModel pageModel = JsonConvert.DeserializeObject<ResultPageModel>(RequestParm.msg.ToString());
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var query = new RB_InvestmentProcurement_Extend()
            {
                CompanyName = parms.GetStringValue("CompanyName"),
                Type = parms.GetInt("Type"),
            };
            var userInfo = AppletUserInfo;
            query.MallBaseId = RequestParm.MallBaseId;
            query.TenantId = userInfo?.TenantId ?? 0;
            query.CreateBy = userInfo.UserId;
            var list = procurementModule.GetInvestmentProcurementPageListModule(pageModel.pageIndex, pageModel.pageSize, out long rowsCount, query);
            pageModel.count = Convert.ToInt32(rowsCount);
            pageModel.pageData = list;
            return ApiResult.Success(data: pageModel);
        }

        /// <summary>
        /// 新增修改投资采购
        /// </summary>
        /// <returns></returns>
        public ApiResult SetInvestmentProcurement()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var extModel = new RB_InvestmentProcurement_Extend()
            {
                Id = parms.GetInt("Id"),
                Type = parms.GetInt("Type"),
                GoodsCategory = parms.GetStringValue("GoodsCategory"),
                Investment = parms.GetStringValue("Investment"),
                ImportNum = parms.GetInt("ImportNum"),
                Describe = parms.GetStringValue("Describe"),
                CompanyName = parms.GetStringValue("CompanyName"),
                CompanyEnName = parms.GetStringValue("CompanyEnName"),
                Mobile = parms.GetStringValue("Mobile"),
                EMail = parms.GetStringValue("EMail"),
                LegalPerson = parms.GetStringValue("LegalPerson"),
                Principal = parms.GetStringValue("Principal"),
                WechatNo = parms.GetStringValue("WechatNo"),
                DomainUrl = parms.GetStringValue("DomainUrl"),
                Industry = parms.GetStringValue("Industry"),
                FoundingTime = parms.GetDateTime("FoundingTime"),
                EmployeeNum = parms.GetInt("EmployeeNum"),
                AnnualSales = parms.GetDecimal("AnnualSales"),
                Address = parms.GetStringValue("Address"),
                EnAddress = parms.GetStringValue("EnAddress"),
                AnnualImport = parms.GetDecimal("AnnualImport"),
                ImportCategory = parms.GetStringValue("ImportCategory"),
                ImportCountry = parms.GetStringValue("ImportCountry"),
                ExportCountry = parms.GetStringValue("ExportCountry"),
                CompanyIntro = parms.GetStringValue("CompanyIntro"),
                OtherInfo = parms.GetStringValue("OtherInfo"),
            };
            extModel.Status = Common.Enum.DateStateEnum.Normal;
            var userInfo = AppletUserInfo;
            extModel.MallBaseId = RequestParm.MallBaseId;
            extModel.TenantId = userInfo?.TenantId ?? 0;
            extModel.CreateBy = userInfo?.UserId ?? 0;
            extModel.CreateDate = DateTime.Now;
            extModel.UpdateBy = userInfo?.UserId ?? 0; ;
            extModel.UpdateDate = DateTime.Now;
            var flag = procurementModule.SetInvestmentProcurementModule(extModel);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }

        /// <summary>
        /// 获取投资采购详情
        /// </summary>
        /// <returns></returns>
        public ApiResult GetInvestmentProcurement()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var Id = parms.GetInt("Id", 0);
            var extModel = procurementModule.GetInvestmentProcurementModule(Id);
            return ApiResult.Success(data: extModel);
        }

        #endregion

        #region Fat咨询管理

        /// <summary>
        /// 新增修改Fat咨询
        /// </summary>
        /// <returns></returns>
        public ApiResult SetCommerceAsk()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var extModel = new RB_Commerce_Ask_Extend()
            {
                Id = parms.GetInt("Id"),
                CompanyName = parms.GetStringValue("CompanyName"),
                Principal = parms.GetStringValue("Principal"),
                Mobile = parms.GetStringValue("Mobile"),
                EMail = parms.GetStringValue("EMail"),
                FatCode = parms.GetStringValue("FatCode"),
                FatTitle = parms.GetStringValue("FatTitle"),
                FatQuestion = parms.GetStringValue("FatQuestion"),
                FatContent = parms.GetStringValue("FatContent")
            };
            var userInfo = AppletUserInfo;
            extModel.Status = Common.Enum.DateStateEnum.Normal;
            extModel.MallBaseId = userInfo.MallBaseId;
            extModel.TenantId = userInfo.TenantId;
            Int32.TryParse(userInfo.UserId.ToString(), out int Uid);
            extModel.CreateBy = Uid;
            extModel.CreateDate = DateTime.Now;
            extModel.UpdateBy = Uid;
            extModel.UpdateDate = DateTime.Now;
            var flag = askModule.SetCommerceAskModule(extModel);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }

        /// <summary>
        /// 获取投资采购分页列表
        /// </summary>
        /// <returns></returns>
        public ApiResult GetCommerceAskPage()
        {
            ResultPageModel pageModel = JsonConvert.DeserializeObject<ResultPageModel>(RequestParm.msg.ToString());
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var query = new RB_Commerce_Ask_Extend()
            {
                CompanyName = parms.GetStringValue("CompanyName"),
            };
            var userInfo = AppletUserInfo;
            query.MallBaseId = RequestParm.MallBaseId;
            query.TenantId = userInfo?.TenantId ?? 0;
            query.CreateBy = userInfo.UserId;
            var list = askModule.GetCommerceAskPageListModule(pageModel.pageIndex, pageModel.pageSize, out long rowsCount, query);
            pageModel.count = Convert.ToInt32(rowsCount);
            pageModel.pageData = list;
            return ApiResult.Success(data: pageModel);
        }


        /// <summary>
        /// 获取咨询详情
        /// </summary>
        /// <returns></returns>
        public ApiResult GetCommerceAsk()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var Id = parms.GetInt("Id", 0);
            var extModel = askModule.GetCommerceAskModule(Id);
            return ApiResult.Success(data: extModel);
        }
        #endregion

        #region 活动管理

        /// <summary>
        /// 获取商会活动类型列表
        /// </summary>
        /// <returns></returns>
        [AllowAnonymous]
        public ApiResult GetCommerceActivityTypeList()
        {
            var query = new RB_Commerce_ActivityType_Extend();
            var userInfo = AppletUserInfo;
            query.MallBaseId = RequestParm.MallBaseId;
            query.TenantId = userInfo?.TenantId ?? 0;
            var list = activityModule.GetCommerceActivityTypeListModule(query);
            return ApiResult.Success(data: list.Select(qitem => new { qitem.Id, qitem.CoverImage, qitem.TypeName }));
        }

        /// <summary>
        /// 获取商会活动分页列表
        /// </summary>
        /// <returns></returns>
            [AllowAnonymous]
        public ApiResult GetCommerceActivityPage()
        {
            ResultPageModel pageModel = JsonConvert.DeserializeObject<ResultPageModel>(RequestParm.msg.ToString());
            JObject jObj = JObject.Parse(RequestParm.msg.ToString());
            var query = new RB_Commerce_Activity_Extend()
            {
                ActivityType = jObj.GetInt("ActivityType")
            };
            var userInfo = AppletUserInfo;
            query.MallBaseId = RequestParm.MallBaseId;
            //query.TenantId = userInfo?.TenantId ?? 0;
            var list = activityModule.GetCommerceActivityPageListModule(pageModel.pageIndex, pageModel.pageSize, out long rowsCount, query);
            pageModel.count = Convert.ToInt32(rowsCount);
            pageModel.pageData = list;
            return ApiResult.Success(data: pageModel);
        }


        /// <summary>
        /// 获取商会活动详情
        /// </summary>
        /// <returns></returns>
        [AllowAnonymous]
        public ApiResult GetCommerceActivity()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var Id = parms.GetInt("Id", 0);
            var extModel = activityModule.GetCommerceActivityModule(Id);
            var userInfo = AppletUserInfo;
            if (extModel != null && extModel.CreateBy > 0)
            {
                extModel.CreateByName = UserReidsCache.GetUserLoginInfo(extModel.CreateBy)?.Name ?? "";
                if (userInfo != null && userInfo.UserId > 0)
                {
                    var list = consultModule.GetCommerceConsultListModule(new RB_Commerce_Consult_Extend() { ActivityId = Id, UserId = userInfo.UserId });
                    if (list != null && list.Count > 0)
                    {
                        extModel.IsJoinActivity = 1;
                    }
                    else
                    {
                        extModel.IsJoinActivity = 0;
                    }
                }
            }
            return ApiResult.Success(data: extModel);
        }

        /// <summary>
        /// 获取当前用户参加的活动
        /// </summary>
        /// <returns></returns>
        public ApiResult GetUserActivityPage()
        {
            ResultPageModel pageModel = JsonConvert.DeserializeObject<ResultPageModel>(RequestParm.msg.ToString());
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var query = new RB_Commerce_Activity_Extend()
            {
            };
            var userInfo = AppletUserInfo;
            query.MallBaseId = RequestParm.MallBaseId;
            query.TenantId = userInfo?.TenantId ?? 0;
            query.CreateBy = userInfo.UserId;
            var list = activityModule.GetUserCommerceActivityPageModule(pageModel.pageIndex, pageModel.pageSize, out long rowsCount, query);
            pageModel.count = Convert.ToInt32(rowsCount);
            pageModel.pageData = list;
            return ApiResult.Success(data: pageModel);
        }

        /// <summary>
        /// 新增修改商会活动报名
        /// </summary>
        /// <returns></returns>
        public ApiResult SetCommerceConsult()
        {
            JObject jObj = JObject.Parse(RequestParm.msg.ToString());
            var extModel = new RB_Commerce_Consult_Extend()
            {
                Id = jObj.GetInt("Id"),
                ActivityId = jObj.GetInt("ActivityId"),
                UserId = jObj.GetInt("UserId"),
                LinkMan = jObj.GetStringValue("LinkMan"),
                LinkTel = jObj.GetStringValue("LinkTel"),
                PeopleNum = jObj.GetInt("PeopleNum", 0),
                UnitPrice = jObj.GetInt("UnitPrice", 0),
                Money = jObj.GetInt("Money", 0),
                Remark = jObj.GetStringValue("Remark"),
            };
            var userInfo = AppletUserInfo;
            extModel.Status = Common.Enum.DateStateEnum.Normal;
            extModel.MallBaseId = RequestParm.MallBaseId;
            extModel.TenantId = userInfo?.TenantId ?? 0;
            extModel.UserId = userInfo?.UserId ?? 0;
            extModel.CreateTime = DateTime.Now;
            string msg = consultModule.SetCommerceConsultModule(extModel);
            return msg == "" ? ApiResult.Success() : ApiResult.Failed(msg);
        }

        /// <summary>
        /// 取消报名
        /// </summary>
        /// <returns></returns>
        public ApiResult CancelCommerceConsult()
        {
            JObject jObj = JObject.Parse(RequestParm.msg.ToString());
            var ActivityId = jObj.GetInt("ActivityId");
            string CancelRemark = jObj.GetStringValue("CancelRemark");
            var userInfo = AppletUserInfo;
            var flag = consultModule.CancelCommerceConsultModule(ActivityId, CancelRemark, userInfo.UserId);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }

        /// <summary>
        /// 新增活动评论
        /// </summary>
        /// <returns></returns>
        public ApiResult AddCommerceComment()
        {
            JObject jObj = JObject.Parse(RequestParm.msg.ToString());
            var extModel = new RB_Commerce_Comment_Extend()
            {
                Id = jObj.GetInt("Id"),
                ActivityId = jObj.GetInt("ActivityId"),
                CommentScore=jObj.GetInt("CommentScore"),
                CommentGrade=(GoodsCommentTypeEnum)jObj.GetInt("CommentGrade"),
                CommentImage=jObj.GetStringValue("CommentImage"),
                PlatformSource=(UserSourceEnum)jObj.GetInt("PlatformSource"),
                Content=jObj.GetStringValue("Content")
            };
            var userInfo = AppletUserInfo;
            extModel.UserName = userInfo.Name;
            extModel.UserPhoto = userInfo.Photo;
            extModel.Status = Common.Enum.DateStateEnum.Normal;
            extModel.MallBaseId = RequestParm.MallBaseId;
            extModel.TenantId = userInfo?.TenantId ?? 0;
            extModel.UserId = userInfo?.UserId ?? 0;
            extModel.CreateDate = DateTime.Now;
            extModel.UpdateDate = DateTime.Now;
            var flag = commerceCommentModule.SetCommerceCommentModule(extModel);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }

        /// <summary>
        /// 删除评论
        /// </summary>
        /// <returns></returns>
        public ApiResult RemoveCommerceComment()
        {
            JObject jObj = JObject.Parse(RequestParm.msg.ToString());
            var Id = jObj.GetInt("Id");
            var flag = commerceCommentModule.RemoveCommerceCommentModule(Id);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }
        #endregion
    }
}
