﻿using Mall.Common.Plugin;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Mall.Common.Enum.Goods
{
    /// <summary>
    /// 订单状态枚举
    /// </summary>
    public enum OrderStatusesRerveEnum
    {
        /// <summary>
        /// 未付款
        /// </summary>
        [EnumField("未付款")]
        NonPayment = 1,

        /// <summary>
        /// 待使用
        /// </summary>
        [EnumField("待使用")]
        WaitReceiving = 3,
        /// <summary>
        /// 已使用
        /// </summary>
        [EnumField("已使用")]
        Received = 4,
        /// <summary>
        /// 已完成
        /// </summary>
        [EnumField("已完成")]
        Completed = 5,
        /// <summary>
        /// 待处理
        /// </summary>
        [EnumField("待处理")]
        WaitDeal = 6,
        /// <summary>
        /// 已取消
        /// </summary>
        [EnumField("已取消")]
        Cancel = 7
    }
}
