﻿using Mall.Common.Enum;
using System;
using System.Collections.Generic;
using System.Text;
using VT.FW.DB;

namespace Mall.Model.Entity.TradePavilion
{
    /// <summary>
    /// FAT咨询实体类
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_Commerce_Ask
    {
		/// <summary>
		/// 主键编号
		/// </summary>
		public int Id { get; set; }

		/// <summary>
		/// 公司名称
		/// </summary>
		public string CompanyName { get; set; }

		/// <summary>
		/// 联系人(责任人)
		/// </summary>
		public string Principal { get; set; }

		/// <summary>
		/// 联系电话
		/// </summary>
		public string Mobile { get; set; }

		/// <summary>
		/// 邮箱
		/// </summary>
		public string EMail { get; set; }

		/// <summary>
		/// Fat海关编码
		/// </summary>
		public string FatCode { get; set; }

		/// <summary>
		/// 咨询标题
		/// </summary>
		public string FatTitle { get; set; }

		/// <summary>
		/// 咨询问题
		/// </summary>
		public string FatQuestion { get; set; }

		/// <summary>
		/// 咨询回复
		/// </summary>
		public string FatContent { get; set; }

		/// <summary>
		/// 商户号id
		/// </summary>
		public int TenantId { get; set; }

		/// <summary>
		/// 小程序id
		/// </summary>
		public int MallBaseId { get; set; }

		/// <summary>
		/// 创建人
		/// </summary>
		public int CreateBy { get; set; }

		/// <summary>
		/// 创建时间
		/// </summary>
		public DateTime CreateDate { get; set; }

		/// <summary>
		/// 修改人
		/// </summary>
		public int UpdateBy { get; set; }

		/// <summary>
		/// 修改时间
		/// </summary>
		public DateTime UpdateDate { get; set; }

		/// <summary>
		/// 删除状态
		/// </summary>
		public DateStateEnum Status { get; set; }

		/// <summary>
		/// 咨询状态(0-未回复，1-已回复）
		/// </summary>
		public int AskStatus { get; set; }

		/// <summary>
		/// 回复时间
		/// </summary>
		public DateTime? ReplyTime { get; set; }

		/// <summary>
		/// 回复人
		/// </summary>
		public int ReplyId { get; set; }
	}
}
