﻿using VT.FW.DB;
using Mall.Common.Enum.User;
using System;
using System.Collections.Generic;
using System.Text;

namespace Mall.Model.Entity.User
{
    /// <summary>
    /// 专题表实体
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_Topic
    {
        /// <summary>
        /// 专题Id
        /// </summary>        
        public int Id
        {
            get;
            set;
        }

        /// <summary>
        /// 标题
        /// </summary>        
        public string Title
        {
            get;
            set;
        }

        /// <summary>
        /// 专题列表布局方式
        /// </summary>        
        public int? FlexType
        {
            get;
            set;
        }

        /// <summary>
        /// 封面图
        /// </summary>        
        public string CoverImg
        {
            get;
            set;
        }

        /// <summary>
        /// 摘要
        /// </summary>        
        public string Abstract
        {
            get;
            set;
        }

        /// <summary>
        /// 自定义分享标题
        /// </summary>        
        public string CustomTitle
        {
            get;
            set;
        }

        /// <summary>
        /// 自定义分享图片
        /// </summary>        
        public string CustomImg
        {
            get;
            set;
        }

        /// <summary>
        /// 是否精选(1-是)
        /// </summary>        
        public int? IsChoice
        {
            get;
            set;
        }

        /// <summary>
        /// 分类编号
        /// </summary>        
        public int? TopicTypeId
        {
            get;
            set;
        }

        /// <summary>
        /// 阅读数量
        /// </summary>        
        public int? ReadNum
        {
            get;
            set;
        }

        /// <summary>
        /// 排序
        /// </summary>        
        public int? SortNum
        {
            get;
            set;
        }

        /// <summary>
        /// 商户号Id
        /// </summary>        
        public int? TenantId
        {
            get;
            set;
        }

        /// <summary>
        /// 小程序Id
        /// </summary>        
        public int? MallBaseId
        {
            get;
            set;
        }

        /// <summary>
        /// 创建时间
        /// </summary>        
        public DateTime? CreateDate
        {
            get;
            set;
        }

        /// <summary>
        /// 删除状态
        /// </summary>        
        public int? Status
        {
            get;
            set;
        }

        /// <summary>
        /// 模板数据[JSON]格式
        /// </summary>
        public string TemplateData { get; set; }
    }
}
