﻿using Mall.Model.Extend.TradePavilion;
using Mall.Repository.TradePavilion;
using System;
using System.Collections.Generic;
using System.Text;
using VT.FW.DB;

namespace Mall.Module.TradePavilion
{
    /// <summary>
    /// 投资采购处理类
    /// </summary>
    public class InvestmentProcurementModule
    {
        /// <summary>
        /// 投资采购仓储层对象
        /// </summary>
        private readonly RB_InvestmentProcurementRepository repository = new RB_InvestmentProcurementRepository();

        /// <summary>
        /// 获取投资采购分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="rowsCount"></param>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_InvestmentProcurement_Extend> GetInvestmentProcurementPageListModule(int pageIndex, int pageSize, out long rowsCount, RB_InvestmentProcurement_Extend query)
        {
            return repository.GetInvestmentProcurementPageListRepository(pageIndex, pageSize, out rowsCount, query);
        }

        /// <summary>
        /// 获取投资采购实体
        /// </summary>
        /// <param name="Id"></param>
        /// <returns></returns>
        public RB_InvestmentProcurement_Extend GetInvestmentProcurementModule(object Id)
        {
            return repository.GetEntity<RB_InvestmentProcurement_Extend>(Id);
        }

        /// <summary>
        /// 新增修改投资采购
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public bool SetInvestmentProcurementModule(RB_InvestmentProcurement_Extend model)
        {
            bool flag;
            if (model.Id > 0)
            {
                Dictionary<string, object> fileds = new Dictionary<string, object>()
                {
                    {nameof(RB_InvestmentProcurement_Extend.Type),model.Type },
                    {nameof(RB_InvestmentProcurement_Extend.GoodsCategory),model.GoodsCategory },
                    {nameof(RB_InvestmentProcurement_Extend.Investment),model.Investment },
                    {nameof(RB_InvestmentProcurement_Extend.ImportNum),model.ImportNum },
                    {nameof(RB_InvestmentProcurement_Extend.Describe),model.Describe },
                    {nameof(RB_InvestmentProcurement_Extend.CompanyName),model.CompanyName },
                    {nameof(RB_InvestmentProcurement_Extend.CompanyEnName),model.CompanyEnName },
                    {nameof(RB_InvestmentProcurement_Extend.Mobile),model.Mobile },
                    {nameof(RB_InvestmentProcurement_Extend.EMail),model.EMail },
                    {nameof(RB_InvestmentProcurement_Extend.LegalPerson),model.LegalPerson },
                    {nameof(RB_InvestmentProcurement_Extend.Principal),model.Principal },
                    {nameof(RB_InvestmentProcurement_Extend.WechatNo),model.WechatNo },
                    {nameof(RB_InvestmentProcurement_Extend.DomainUrl),model.DomainUrl },
                    {nameof(RB_InvestmentProcurement_Extend.Industry),model.Industry },
                    {nameof(RB_InvestmentProcurement_Extend.FoundingTime),model.FoundingTime },
                    {nameof(RB_InvestmentProcurement_Extend.EmployeeNum),model.EmployeeNum },
                    {nameof(RB_InvestmentProcurement_Extend.AnnualSales),model.AnnualSales },
                    {nameof(RB_InvestmentProcurement_Extend.Address),model.Address },
                    {nameof(RB_InvestmentProcurement_Extend.EnAddress),model.EnAddress },
                    {nameof(RB_InvestmentProcurement_Extend.AnnualImport),model.AnnualImport },
                    {nameof(RB_InvestmentProcurement_Extend.ImportCategory),model.ImportCategory },
                    {nameof(RB_InvestmentProcurement_Extend.ImportCountry),model.ImportCountry },
                    {nameof(RB_InvestmentProcurement_Extend.ExportCountry),model.ExportCountry },
                    {nameof(RB_InvestmentProcurement_Extend.CompanyIntro),model.CompanyIntro },
                    {nameof(RB_InvestmentProcurement_Extend.OtherInfo),model.OtherInfo },
                    {nameof(RB_InvestmentProcurement_Extend.UpdateBy),model.UpdateBy },
                    {nameof(RB_InvestmentProcurement_Extend.UpdateDate),model.UpdateDate },
                };
                flag = repository.Update(fileds, new WhereHelper(nameof(RB_InvestmentProcurement_Extend.Id), model.Id));
            }
            else
            {
                var newId = repository.Insert(model);
                model.Id = newId;
                flag = newId > 0;
            }
            return flag;
        }

        /// <summary>
        /// 更新投资采购状态
        /// </summary>
        /// <param name="Id"></param>
        /// <param name="Status"></param>
        /// <returns></returns>
        public bool RemoveInvestmentProcurementModule(int Id, int Status)
        {
            Dictionary<string, object> fileds = new Dictionary<string, object>()
            {
                {nameof(RB_InvestmentProcurement_Extend.Status),Status },
            };
            bool flag = repository.Update(fileds, new WhereHelper(nameof(RB_InvestmentProcurement_Extend.Id), Id));
            return flag;
        }

        /// <summary>
        /// 采购/投资审核
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public bool AuditInvestmentProcurementModule(RB_InvestmentProcurement_Extend model)
        {
            Dictionary<string, object> fileds = new Dictionary<string, object>()
            {
                {nameof(RB_InvestmentProcurement_Extend.AuditStatus),model.AuditStatus },
                {nameof(RB_InvestmentProcurement_Extend.AuditBy),model.AuditBy },
                {nameof(RB_InvestmentProcurement_Extend.AuditTime),model.AuditTime },
                {nameof(RB_InvestmentProcurement_Extend.AuditContent),model.AuditContent },
            };
            bool flag = repository.Update(fileds, new WhereHelper(nameof(RB_InvestmentProcurement_Extend.Id), model.Id));
            return flag;
        }

    }
}
