﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Mall.Model.Entity.MarketingCenter;

namespace Mall.Repository.MarketingCenter
{
   public class Rb_GuestSurveyDetailsRepository:BaseRepository<Rb_GuestSurveyDetails>
    {
        /// <summary>
        /// 表名称
        /// </summary>
        public string TableName { get { return nameof(Rb_GuestSurveyDetails); } }


        /// <summary>
        /// 获取列表
        /// </summary>
        /// <param name="where"></param>
        /// <returns></returns>
        public List<Rb_GuestSurveyDetails> GetList(Rb_GuestSurveyDetails where)
        {
            StringBuilder sb = new StringBuilder();
            sb.Append($@"SELECT * from Rb_GuestSurveyDetails  where 1=1");
            if (where != null)
            {
                if (where.SurveyId > 0)
                {
                    sb.AppendFormat(" and SurveyId={0}", where.SurveyId);
                }

                if (where.GuestSurveyId > 0)
                {
                    sb.AppendFormat(" and GuestSurveyId={0}", where.GuestSurveyId);
                }
            }
            return Get<Rb_GuestSurveyDetails>(sb.ToString()).ToList();
        }


        /// <summary>
        /// 获取列表
        /// </summary>
        /// <param name="GuestSurveyIds"></param>
        /// <returns></returns>
        public List<Rb_GuestSurveyDetails> GetList(string GuestSurveyIds)
        {
            StringBuilder sb = new StringBuilder();
            sb.Append($@"SELECT * from Rb_GuestSurveyDetails where 1=1");

            if (!string.IsNullOrWhiteSpace(GuestSurveyIds))
            {
                sb.AppendFormat(" and GuestSurveyId in({0})", GuestSurveyIds);
            }
            return Get<Rb_GuestSurveyDetails>(sb.ToString()).ToList();
        }
    }
}
