﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Mall.Model.Entity.Product;
using Mall.Model.Extend.Product;

namespace Mall.Repository.Product
{
    public class RB_Invoice_Online_TradeRepository : BaseRepository<RB_Invoice_Online_Trade>
    {
        /// <summary>
        /// 表名称
        /// </summary>
        public string TableName { get { return nameof(RB_Invoice_Online_Trade); } }
        /// <summary>
        /// 
        /// 获取列表
        /// </summary>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public List<RB_Invoice_Online_Trade_Extend> GetList(RB_Invoice_Online_Trade_Extend dmodel)
        {
            string where = $" where 1=1  ";
            if (dmodel.TenantId > 0)
            {
                where += $@" and {nameof(RB_Invoice_Online_Trade_Extend.TenantId)}={dmodel.TenantId}";
            }
            if (dmodel.MallBaseId > 0)
            {
                where += $@" and {nameof(RB_Invoice_Online_Trade_Extend.MallBaseId)}={dmodel.MallBaseId}";
            }

            string sql = $@"SELECT * FROM {TableName}  {where} order by Id asc";
            return Get<RB_Invoice_Online_Trade_Extend>(sql).ToList();
        }


        /// <summary>
        /// 获取不开发票商品提现记录
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Invoice_Online_Trade_Extend> GetInvoiceOnlineTradePageList(int pageIndex, int pageSize, out long rowCount, RB_Invoice_Online_Trade_Extend query)
        {
            StringBuilder builder = new StringBuilder();
            builder.Append($@" SELECT a.*,b.`Name` as UserName,c.EmpName as CreateByName FROM {TableName} as a 
LEFT JOIN rb_member_user as b on a.User_Id=b.Id
LEFT JOIN rb_employee as c on a.CreateBy=c.EmpId where 1=1 and a.Pay_Result=0 ");
            if (query != null)
            {
                if (query.TenantId > 0)
                {
                    builder.Append($" AND a.{nameof(RB_Invoice_Online_Trade_Extend.TenantId)}={query.TenantId}");
                }
                if (query.TenantId > 0)
                {
                    builder.Append($" AND a.{nameof(RB_Invoice_Online_Trade_Extend.MallBaseId)}={query.MallBaseId}");
                }
                if (query.CreateBy > 0)
                {
                    builder.Append($" AND a.{nameof(RB_Invoice_Online_Trade_Extend.CreateBy)}={query.CreateBy}");
                }
                if (query.User_Id > 0)
                {
                    builder.Append($" AND a.{nameof(RB_Invoice_Online_Trade_Extend.User_Id)}={query.User_Id}");
                }
                if (!string.IsNullOrWhiteSpace(query.Transaction_Id))
                {
                    builder.Append($" AND a.{nameof(RB_Invoice_Online_Trade_Extend.Transaction_Id)} like '%{query.Transaction_Id}%'");
                }
                if (!string.IsNullOrEmpty(query.StartTime))
                {
                    builder.Append($"  and a.{nameof(RB_Invoice_Online_Trade_Extend.Pay_Date)} >='{query.StartTime}'");
                }
                if (!string.IsNullOrEmpty(query.EndTime))
                {
                    builder.Append($"  and a.{nameof(RB_Invoice_Online_Trade_Extend.Pay_Date)} <='{query.EndTime} 23:59:59'");
                }

                if (query.StartMoney.HasValue && query.StartMoney.Value > 0)
                {
                    builder.Append($"  and a.{nameof(RB_Invoice_Online_Trade_Extend.Money)} >={query.StartMoney}");
                }
                if (query.EndMoney.HasValue && query.EndMoney.Value > 0)
                {
                    builder.Append($"  and a.{nameof(RB_Invoice_Online_Trade_Extend.Money)} <={query.EndMoney}");
                }
            }
            return GetPage<RB_Invoice_Online_Trade_Extend>(pageIndex, pageSize, out rowCount, builder.ToString()).ToList();
        }

        /// <summary>
        /// 获取不开发票商品提现记录
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Invoice_Online_Trade_Extend> GetToDayInvoiceOnlineTradeList(RB_Invoice_Online_Trade_Extend query)
        {
            StringBuilder builder = new StringBuilder();
            builder.Append($@" SELECT a.* from {TableName} as a where 1=1 ");
            if (query != null)
            {
                if (query.TenantId > 0)
                {
                    builder.Append($" AND a.{nameof(RB_Invoice_Online_Trade_Extend.TenantId)}={query.TenantId}");
                }
                if (query.TenantId > 0)
                {
                    builder.Append($" AND a.{nameof(RB_Invoice_Online_Trade_Extend.MallBaseId)}={query.MallBaseId}");
                }
                if (query.CreateBy > 0)
                {
                    builder.Append($" AND a.{nameof(RB_Invoice_Online_Trade_Extend.CreateBy)}={query.CreateBy}");
                }
                if (query.User_Id > 0)
                {
                    builder.Append($" AND a.{nameof(RB_Invoice_Online_Trade_Extend.User_Id)}={query.User_Id}");
                }
                if (!string.IsNullOrWhiteSpace(query.Transaction_Id))
                {
                    builder.Append($" AND a.{nameof(RB_Invoice_Online_Trade_Extend.Transaction_Id)} like '%{query.Transaction_Id}%'");
                }

                if (query.Pay_Date.HasValue)
                {
                    builder.Append($"  and  DATE_FORMAT(a.{nameof(RB_Invoice_Online_Trade_Extend.Pay_Date)},'%Y-%m-%d' )=DATE_FORMAT('{query.Pay_Date}','%Y-%m-%d' )");
                }
                if (!string.IsNullOrEmpty(query.StartTime))
                {
                    builder.Append($"  and a.{nameof(RB_Invoice_Online_Trade_Extend.Pay_Date)} >='{query.StartTime}'");
                }
                if (!string.IsNullOrEmpty(query.EndTime))
                {
                    builder.Append($"  and a.{nameof(RB_Invoice_Online_Trade_Extend.Pay_Date)} <='{query.EndTime} 23:59:59'");
                }

                if (query.StartMoney.HasValue && query.StartMoney.Value > 0)
                {
                    builder.Append($"  and a.{nameof(RB_Invoice_Online_Trade_Extend.Money)} >={query.StartMoney}");
                }
                if (query.EndMoney.HasValue && query.EndMoney.Value > 0)
                {
                    builder.Append($"  and a.{nameof(RB_Invoice_Online_Trade_Extend.Money)} <={query.EndMoney}");
                }
            }
            return Get<RB_Invoice_Online_Trade_Extend>( builder.ToString()).ToList();
        }

    }
}
