﻿using System;
using System.Collections.Generic;
using System.Text;
using Mall.Model.Entity.User;
using Mall.Model.Extend.User;
using System.Linq;

namespace Mall.Repository.User
{
    /// <summary>
    /// vip购买返佣仓储层
    /// </summary>
    public class RB_VipBuy_CommissionRepository : BaseRepository<RB_VipBuy_Commission>
    {
        /// <summary>
        /// 分页列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="dmodel">查询条件</param>
        /// <returns></returns>
        public List<RB_VipBuy_Commission_Extend> GetPageList(int pageIndex, int pageSize, out long rowCount, RB_VipBuy_Commission_Extend dmodel)
        {
            string where = " 1=1";
            if (dmodel.TenantId > 0)
            {
                where += $@" and v.{nameof(RB_VipBuy_Commission.TenantId)}={dmodel.TenantId}";
            }
            if (dmodel.MallBaseId > 0)
            {
                where += $@" and v.{nameof(RB_VipBuy_Commission.MallBaseId)}={dmodel.MallBaseId}";
            }
            if (dmodel.Id > 0)
            {
                where += $@" and v.{nameof(RB_VipBuy_Commission.Id)}={dmodel.Id}";
            }
            if (dmodel.UserId > 0)
            {
                where += $@" and v.{nameof(RB_VipBuy_Commission.UserId)}={dmodel.UserId}";
            }
            if (dmodel.Type > 0) 
            {
                where += $@" and v.{nameof(RB_VipBuy_Commission.Type)}={dmodel.Type}";
            }
            if (!string.IsNullOrEmpty(dmodel.UserName))
            {
                where += $@" and u.{nameof(RB_Member_User.Name)} like '%{dmodel.UserName}%'";
            }

            string sql = $@"select v.*,vb.OrderNo,vb.GradeName,u.Name as UserName,u.Photo from RB_VipBuy_Commission v
inner join rb_vip_buy vb on v.OrderId = vb.Id
inner join rb_member_user u on vb.UserId= u.Id
where {where} order by v.Id desc";
            return GetPage<RB_VipBuy_Commission_Extend>(pageIndex, pageSize, out rowCount, sql).ToList();
        }

        /// <summary>
        /// 获取列表
        /// </summary>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public List<RB_VipBuy_Commission_Extend> GetList(RB_VipBuy_Commission_Extend dmodel) {
            string where = " 1=1 ";
            if (dmodel.TenantId > 0)
            {
                where += $@" and v.{nameof(RB_VipBuy_Commission.TenantId)}={dmodel.TenantId}";
            }
            if (dmodel.MallBaseId > 0)
            {
                where += $@" and v.{nameof(RB_VipBuy_Commission.MallBaseId)}={dmodel.MallBaseId}";
            }
            if (dmodel.Id > 0)
            {
                where += $@" and v.{nameof(RB_VipBuy_Commission.Id)}={dmodel.Id}";
            }
            if (!string.IsNullOrEmpty(dmodel.VipIds))
            {
                where += $@" and v.{nameof(RB_VipBuy_Commission.Id)} in({dmodel.VipIds})";
            }
            if (dmodel.OrderId > 0)
            {
                where += $@" and v.{nameof(RB_VipBuy_Commission.OrderId)}={dmodel.OrderId}";
            }
            if (!string.IsNullOrEmpty(dmodel.OrderIds)) 
            {
                where += $@" and v.{nameof(RB_VipBuy_Commission.OrderId)} in({dmodel.OrderIds})";
            }
            if (dmodel.UserId > 0)
            {
                where += $@" and v.{nameof(RB_VipBuy_Commission.UserId)}={dmodel.UserId}";
            }
            if (dmodel.Type > 0)
            {
                where += $@" and v.{nameof(RB_VipBuy_Commission.Type)}={dmodel.Type}";
            }
            if (dmodel.IsRemit == 2) {
                where += $@" and v.{nameof(RB_VipBuy_Commission.IsRemit)} <> 1";
            }

            string sql = $@"select v.*,vb.OrderNo,vb.ReOrderId from RB_VipBuy_Commission v 
inner join rb_vip_buy vb on v.OrderId = vb.Id
where {where} order by v.Id asc";
            return Get<RB_VipBuy_Commission_Extend>(sql).ToList();
        }

        /// <summary>
        /// 获取vip返佣总额
        /// </summary>
        /// <param name="userId"></param>
        /// <returns></returns>
        public decimal getVipBuyCommissionMoney(int userId)
        {
            string sql = $@"select SUM(v.Commission) as Commission from RB_VipBuy_Commission v where v.UserId=" + userId;
            var obj = ExecuteScalar(sql);
            if (obj != null)
            {
                return Convert.ToDecimal(obj);
            }
            else {
                return 0;
            }
        }

        /// <summary>
        /// 获取时间范围新增订单数量
        /// </summary>
        /// <param name="mallBaseId"></param>
        /// <param name="startTime"></param>
        /// <param name="endTime"></param>
        /// <param name="userId"></param>
        /// <returns></returns>
        public int GetUserNewOrderNum(int mallBaseId, string startTime, string endTime, int userId)
        {
            string sql = $@"SELECT COUNT(0) FROM (
SELECT v.Id,SUM(vc.Commission) FROM rb_vip_buy v
INNER JOIN rb_vipbuy_commission vc on v.Id = vc.OrderId
WHERE v.MallBaseId ={mallBaseId} and v.`Status` =0 and v.PayState =1 and vc.UserId ={userId} and v.CreateDate >= '{startTime}' AND v.CreateDate <= '{endTime} 23:59:59'
GROUP BY v.Id ) t";
            var obj = ExecuteScalar(sql);
            return obj != null ? Convert.ToInt32(obj) : 0;
        }

        /// <summary>
        /// 获取时间范围新佣金金额
        /// </summary>
        /// <param name="mallBaseId"></param>
        /// <param name="startTime"></param>
        /// <param name="endTime"></param>
        /// <param name="userId"></param>
        /// <returns></returns>
        public decimal GetUserNewOrderCommission(int mallBaseId, string startTime, string endTime, int userId)
        {
            string sql = $@"SELECT SUM(vc.Commission) FROM rb_vip_buy v
INNER JOIN rb_vipbuy_commission vc on v.Id = vc.OrderId
WHERE v.MallBaseId ={mallBaseId} and v.`Status` =0 and v.PayState =1 and vc.UserId ={userId} and  v.CreateDate >= '{startTime}' AND v.CreateDate <= '{endTime} 23:59:59'";
            var obj = ExecuteScalar(sql);
            return obj != null ? Convert.ToDecimal(obj) : 0;
        }
    }
}
