﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Mall.Common.API;
using Mall.Model.Extend.User;
using Mall.Module.User;
using Mall.WebApi.Filter;
using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Cors;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Newtonsoft.Json;

namespace Mall.WebApi.Controllers.User
{
    [Route("api/[controller]/[action]")]
    [ApiExceptionFilter]
    [ApiController]
    [EnableCors("AllowCors")]
    public class MemberUserController : BaseController
    {
        private MemberUserModule MemberUserModule = new MemberUserModule();
        [AllowAnonymous]
        /// <summary>
        /// 用户登录
        /// </summary>
        /// <returns></returns>
        public ApiResult SetMemberPhoto()
        {
            var extModel = JsonConvert.DeserializeObject<RB_Member_User_Extend>(RequestParm.msg.ToString());
            var flag = MemberUserModule.SetMemberUserNameAndPhoto(extModel);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }

        /// <summary>
        /// 更改用户的手机号码 add by:W 2020-10-28
        /// </summary>
        /// <returns></returns>
        public ApiResult SetMemberUserPhoneNum()
        {
            var extModel = JsonConvert.DeserializeObject<RB_Member_User_Extend>(RequestParm.msg.ToString());
            var flag = MemberUserModule.SetMemberUserPhoneNum(extModel);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }

    }
}