﻿using Mall.Model.Entity.User;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Mall.Repository.User
{
    /// <summary>
    /// 余额充值仓储层
    /// </summary>
    public class RB_Member_BalanceRechargeRepository : BaseRepository<RB_Member_BalanceRecharge>
    {
        /// <summary>
        /// 余额充值
        /// </summary>
        public string TableName { get { return nameof(RB_Member_BalanceRecharge); } }
        /// <summary>
        /// 充值列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Member_BalanceRecharge> GetBalanceRechargePageList(int pageIndex, int pageSize, out long rowCount, RB_Member_BalanceRecharge query)
        {
            StringBuilder builder = new StringBuilder();
            builder.Append($" SELECT * FROM {TableName} WHERE  1=1");
            if (query != null)
            {
                if (query.TenantId > 0)
                {
                    builder.Append($" AND {nameof(RB_Member_BalanceRecharge.TenantId)}={query.TenantId}");
                }
                if (query.MallBaseId > 0)
                {
                    builder.Append($" AND {nameof(RB_Member_BalanceRecharge.MallBaseId)}={query.MallBaseId}");
                }
                if (query.UserId > 0)
                {
                    builder.Append($" AND {nameof(RB_Member_BalanceRecharge.UserId)}={query.UserId}");
                }
            }
            return GetPage<RB_Member_BalanceRecharge>(pageIndex, pageSize, out rowCount, builder.ToString()).ToList();
        }


        /// <summary>
        /// 充值信息
        /// </summary>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Member_BalanceRecharge> GetBalanceRechargeList(RB_Member_BalanceRecharge query)
        {
            StringBuilder builder = new StringBuilder();
            builder.Append($" SELECT * FROM {TableName} WHERE 1=1 ");
            if (query != null)
            {
                if (query.TenantId > 0)
                {
                    builder.Append($" AND {nameof(RB_Member_BalanceRecharge.TenantId)}={query.TenantId}");
                }
                if (query.MallBaseId > 0)
                {
                    builder.Append($" AND {nameof(RB_Member_BalanceRecharge.MallBaseId)}={query.MallBaseId}");
                }
                if (query.UserId > 0)
                {
                    builder.Append($" AND {nameof(RB_Member_BalanceRecharge.UserId)}={query.UserId}");
                }
            }
            return Get<RB_Member_BalanceRecharge>(builder.ToString()).ToList();
        }
    }
}
