﻿using System;
using System.Collections.Generic;
using System.Text;
using Mall.Model.Entity.User;
using Mall.Model.Extend.User;
using System.Linq;

namespace Mall.Repository.User
{
    /// <summary>
    /// 视频表仓储层
    /// </summary>
    public class RB_VideoRepository : BaseRepository<RB_Video>
    {
        /// <summary>
        /// 视频分页列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Video_Extend> GetVideoPageListRepository(int pageIndex, int pageSize, out long rowCount, RB_Video_Extend query)
        {
            StringBuilder builder = new StringBuilder();
            builder.AppendFormat(@" SELECT * FROM RB_Video WHERE 1=1 AND Status=0 ");
            if (query.TenantId > 0)
            {
                builder.AppendFormat(" AND {0}={1} ", nameof(RB_Video_Extend.TenantId), query.TenantId);
            }
            if (query.MallBaseId > 0)
            {
                builder.AppendFormat(" AND {0}={1} ", nameof(RB_Video_Extend.MallBaseId), query.MallBaseId);
            }
            if (query.Id > 0)
            {
                builder.AppendFormat(" AND {0}={1} ", nameof(RB_Video_Extend.Id), query.Id);
            }
            if (query.Title != null && !string.IsNullOrEmpty(query.Title.Trim()))
            {
                builder.AppendFormat(" AND {0} LIKE '%{1}%' ", nameof(RB_Video_Extend.Title), query.Title.Trim());
            }
            builder.Append(" ORDER BY Id DESC ");
            return GetPage<RB_Video_Extend>(pageIndex, pageSize, out rowCount, builder.ToString()).ToList();
        }

        /// <summary>
        /// 获取视频列表
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Video_Extend> GetVideoListRepository(RB_Video_Extend query)
        {
            StringBuilder builder = new StringBuilder();
            builder.AppendFormat(@" SELECT * FROM RB_Video WHERE 1=1 AND Status=0 ");
            if (query.TenantId > 0)
            {
                builder.AppendFormat(" AND {0}={1} ", nameof(RB_Video_Extend.TenantId), query.TenantId);
            }
            if (query.MallBaseId > 0)
            {
                builder.AppendFormat(" AND {0}={1} ", nameof(RB_Video_Extend.MallBaseId), query.MallBaseId);
            }
            if (query.Id > 0)
            {
                builder.AppendFormat(" AND {0}={1} ", nameof(RB_Video_Extend.Id), query.Id);
            }
            if (query.Title != null && !string.IsNullOrEmpty(query.Title.Trim()))
            {
                builder.AppendFormat(" AND {0} LIKE '%{1}%' ", nameof(RB_Video_Extend.Title), query.Title.Trim());
            }
            builder.Append(" ORDER BY Id DESC ");
            return Get<RB_Video_Extend>(builder.ToString()).ToList();
        }
    }
}
