﻿using Mall.Common.Enum;
using Mall.Common.Enum.TradePavilion;
using System;
using VT.FW.DB;

namespace Mall.Model.Entity.TradePavilion
{
    /// <summary>
    /// 商会活动报名实体类
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_Commerce_Consult
    {
		/// <summary>
		/// 主键编号
		/// </summary>
		public int Id { get; set; }

		/// <summary>
		/// 活动编号
		/// </summary>
		public int ActivityId { get; set; }

		/// <summary>
		/// 用户编号
		/// </summary>
		public int UserId { get; set; }

		/// <summary>
		/// 联系人
		/// </summary>
		public string LinkMan { get; set; }

		/// <summary>
		/// 联系电话
		/// </summary>
		public string LinkTel { get; set; }

		/// <summary>
		/// 商户号id
		/// </summary>
		public int TenantId { get; set; }

		/// <summary>
		/// 小程序id
		/// </summary>
		public int MallBaseId { get; set; }

		/// <summary>
		/// 报名时间
		/// </summary>
		public DateTime CreateTime { get; set; }

		/// <summary>
		/// 删除状态
		/// </summary>
		public DateStateEnum Status { get; set; }

        /// <summary>
        /// 报名人数
        /// </summary>
        public int PeopleNum { get; set; }

        /// <summary>
        /// 单价（点数）
        /// </summary>
        public int UnitPrice { get; set; }

        /// <summary>
        /// 支付点数
        /// </summary>
        public int Money { get; set; }

        /// <summary>
        /// 备注
        /// </summary>
        public string Remark { get; set; }

        /// <summary>
        /// 是否申请取消  1是  2否
        /// </summary>
        public int IsApplyForCancel { get; set; }

        /// <summary>
        /// 取消备注
        /// </summary>
        public string CancelRemark { get; set; }

        /// <summary>
        /// 申请取消审核状态  1同意  2拒绝
        /// </summary>
        public int ApplyForCancelStatus { get; set; }

        /// <summary>
        /// 拒绝备注
        /// </summary>
        public string RejectRemark { get; set; }


        /// <summary>
        /// 活动ids
        /// </summary>
        public string ActivityIds { get; set; }

        /// <summary>
        /// 单位/企业/机构名称
        /// </summary>
        public string CompanyName { get; set; }

        /// <summary>
        /// 性质
        /// </summary>
        public NatureEnum? Nature { get; set; }

        /// <summary>
        /// 职务
        /// </summary>
        public string Post { get; set; }



        /// <summary>
        /// 所属国籍/省/市
        /// </summary>
        public string CountryInfo { get; set; }
    }
}
