﻿using Mall.Model.Entity.Education;
using Mall.Model.Extend.Education;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Mall.Repository.Education
{
    public class RB_Education_TeacherRepository : BaseRepository<RB_Education_Teacher>
    {
        /// <summary>
        /// 表名称
        /// </summary>
        public string TableName { get { return nameof(RB_Education_Teacher); } }
        /// <summary>
        /// 网课-老师列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Education_Teacher_Extend> GetPageListRepository(int pageIndex, int pageSize, out long rowCount, RB_Education_Teacher_Extend query)
        {
            StringBuilder builder = new StringBuilder();
             builder.Append($" SELECT * FROM {TableName} WHERE  {nameof(RB_Education_Teacher_Extend.Status)}=0");
//            builder.Append(@$" SELECT a.*,c.OrderNum FROM {TableName} as A  LEFT JOIN (SELECT  od.ServicepersonalId,COUNT(*) OrderNum FROM rb_goods_orderdetail od
//INNER JOIN rb_goods_order o on o.OrderId=od.OrderId 
//where o.OrderClassify=2 and o.OrderStatus in(2,3,4,5,6) 
//GROUP BY od.ServicepersonalId) as c on a.id=c.ServicepersonalId WHERE  a.{nameof(RB_Education_Teacher_Extend.Status)}=0");
            if (query != null)
            {
                if (query.TenantId > 0)
                {
                    builder.Append($" AND {nameof(RB_Education_Teacher_Extend.TenantId)}={query.TenantId}");
                }
                if (query.TenantId > 0)
                {
                    builder.Append($" AND {nameof(RB_Education_Teacher_Extend.MallBaseId)}={query.MallBaseId}");
                }
                if (query.ID > 0)
                {
                    builder.Append($" AND {nameof(RB_Education_Teacher_Extend.ID)}={query.ID}");
                }
                if (!string.IsNullOrWhiteSpace(query.Name))
                {
                    builder.Append($" AND {nameof(RB_Education_Teacher_Extend.Name)} like '%{query.Name}%'");
                }
                if (!string.IsNullOrWhiteSpace(query.Telephone))
                {
                    builder.Append($" AND {nameof(RB_Education_Teacher_Extend.Telephone)} like '%{query.Telephone}%'");
                }
                if (query.TeacherStatus > 0)
                {
                    builder.Append($" AND {nameof(RB_Education_Teacher_Extend.TeacherStatus)}={query.TeacherStatus}");
                }
            }
            return GetPage<RB_Education_Teacher_Extend>(pageIndex, pageSize, out rowCount, builder.ToString()).ToList();
        }


        /// <summary>
        /// 网课-老师列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Education_Teacher_Extend> GetTeacherList(RB_Education_Teacher_Extend query)
        {
            StringBuilder builder = new StringBuilder();
            builder.Append($" SELECT a.*,b.`Name` as UserName from {TableName} as a LEFT JOIN rb_member_user as b on a.UserId=b.Id WHERE  a.{nameof(RB_Education_Teacher_Extend.Status)}=0");
            if (query != null)
            {
                if (query.TenantId > 0)
                {
                    builder.Append($" AND a.{nameof(RB_Education_Teacher_Extend.TenantId)}={query.TenantId}");
                }
                if (query.MallBaseId > 0)
                {
                    builder.Append($" AND a.{nameof(RB_Education_Teacher_Extend.MallBaseId)}={query.MallBaseId}");
                }
                if (query.ID > 0)
                {
                    builder.Append($" AND a.{nameof(RB_Education_Teacher_Extend.ID)}={query.ID}");
                }
                if (query.UserId > 0)
                {
                    builder.Append($" AND a.{nameof(RB_Education_Teacher_Extend.UserId)}={query.UserId}");
                }
                if (!string.IsNullOrWhiteSpace(query.Name))
                {
                    builder.Append($" AND a.{nameof(RB_Education_Teacher_Extend.Name)} like '%{query.Name}%'");
                }
                if (!string.IsNullOrWhiteSpace(query.Telephone))
                {
                    builder.Append($" AND a.{nameof(RB_Education_Teacher_Extend.Telephone)} like '%{query.Telephone}%'");
                }
                if (query.TeacherStatus > 0)
                {
                    builder.Append($" AND a.{nameof(RB_Education_Teacher_Extend.TeacherStatus)}={query.TeacherStatus}");
                }
            }
            return Get<RB_Education_Teacher_Extend>(builder.ToString()).ToList();
        }
    }
}
