﻿using System;
using System.Collections.Generic;
using System.Linq;
using Mall.CacheManager.User;
using Mall.Common.API;
using Mall.Common.Plugin;
using Mall.Model.Extend.TradePavilion;
using Mall.Module.TradePavilion;
using Mall.WebApi.Filter;
using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Cors;
using Microsoft.AspNetCore.Mvc;
using Newtonsoft.Json;
using Newtonsoft.Json.Linq;

namespace Mall.WebApi.Controllers.TradePavilion
{
    [Route("api/[controller]/[action]")]
    [ApiExceptionFilter]
    [ApiController]
    [EnableCors("AllowCors")]
    public class TradeController : BaseController
    {
        /// <summary>
        /// 联系人处理类对象
        /// </summary>
        private readonly ContractModule module = new ContractModule();

        /// <summary>
        /// 投资采购处理类对象
        /// </summary>
        private readonly InvestmentProcurementModule procurementModule = new InvestmentProcurementModule();

        /// <summary>
        /// 公司信息处理类对象
        /// </summary>
        private readonly CompanyModule companyModule = new CompanyModule();


        /// <summary>
        /// 商会活动处理类对象
        /// </summary>
        private readonly CommerceActivityModule activityModule = new CommerceActivityModule();

        /// <summary>
        /// 商会活动报名处理类对象
        /// </summary>
        private readonly CommerceConsultModule consultModule = new CommerceConsultModule();

        /// <summary>
        /// 韩国馆新闻处理类
        /// </summary>
        private readonly CommerceNewsModule commerceNewsModule = new CommerceNewsModule();
        /// <summary>
        /// 韩国馆新闻处理类
        /// </summary>
        private readonly CarrierModule carrierModule = new CarrierModule();
        /// <summary>
        /// 认证对象
        /// </summary>
        private readonly AuthenticationModule authenticationModule = new AuthenticationModule();

        /// <summary>
        /// Fat资料处理类对象
        /// </summary>
        private readonly CommerceAskModule askModule = new CommerceAskModule();

        /// <summary>
        /// 会员信息
        /// </summary>
        private readonly Module.User.UserModule userModule = new Module.User.UserModule();


        #region 联系人管理

        /// <summary>
        /// 获取联系人分页列表
        /// </summary>
        /// <returns></returns>
        [HttpGet]
        [HttpPost]
        [AllowAnonymous]
        public ApiResult GetContractPageList()
        {
            ResultPageModel pageModel = JsonConvert.DeserializeObject<ResultPageModel>(RequestParm.msg.ToString());
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var query = new RB_Contract_Extend()
            {
                Name = parms.GetStringValue("Name")
            };
            query.MallBaseId = RequestParm.MallBaseId;
            query.TenantId = RequestParm.TenantId;
            var list = module.GetContractPageListModule(pageModel.pageIndex, pageModel.pageSize, out long rowsCount, query);
            if (list != null && list.Count > 0)
            {
                foreach (var item in list)
                {
                    if (item.CreateBy > 0)
                    {
                        item.CreateByName = UserReidsCache.GetUserLoginInfo(item.CreateBy)?.Account ?? "";
                    }
                }
            }
            pageModel.count = Convert.ToInt32(rowsCount);
            pageModel.pageData = list;
            return ApiResult.Success(data: pageModel);
        }

        /// <summary>
        /// 获取联系人列表
        /// </summary>
        /// <returns></returns>
        public ApiResult GetContractList()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var query = new RB_Contract_Extend()
            {
                Name = parms.GetStringValue("Name")
            };
            query.MallBaseId = RequestParm.MallBaseId;
            query.TenantId = RequestParm.TenantId;
            var list = module.GetContractListModule(query);
            if (list != null && list.Count > 0)
            {
                foreach (var item in list)
                {
                    if (item.CreateBy > 0)
                    {
                        item.CreateByName = UserReidsCache.GetUserLoginInfo(item.CreateBy)?.Account ?? "";
                    }
                }
            }
            return ApiResult.Success(data: list);
        }

        /// <summary>
        /// 新增修改联系人
        /// </summary>
        /// <returns></returns>
        public ApiResult SetContract()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var extModel = new RB_Contract_Extend()
            {
                Id = parms.GetInt("Id"),
                Name = parms.GetStringValue("Name"),
                Tel = parms.GetStringValue("Tel"),
                HeadIcon = parms.GetStringValue("HeadIcon"),
                BgImg = parms.GetStringValue("BgImg"),
                Position = parms.GetStringValue("Position"),
                Intro = parms.GetStringValue("Intro")
            };
            extModel.Status = Common.Enum.DateStateEnum.Normal;
            extModel.MallBaseId = RequestParm.MallBaseId;
            extModel.TenantId = RequestParm.TenantId;
            Int32.TryParse(RequestParm.uid, out int Uid);
            extModel.CreateBy = Uid;
            extModel.CreateDate = DateTime.Now;
            extModel.UpdateBy = Uid;
            extModel.UpdateDate = DateTime.Now;
            var flag = module.SetContractModule(extModel);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }

        /// <summary>
        /// 获取角色实体
        /// </summary>
        /// <returns></returns>
        [HttpGet]
        [HttpPost]
        [AllowAnonymous]
        public ApiResult GetContract()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var Id = parms.GetInt("Id", 0);
            var extModel = module.GetContractModule(Id);
            return ApiResult.Success(data: extModel);
        }

        /// <summary>
        /// 删除联系人
        /// </summary>
        /// <returns></returns>
        public ApiResult RemoveContract()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var Id = parms.GetInt("Id", 0);
            var Status = parms.GetInt("Status", 0);
            var flag = module.RemoveContractModule(Id, Status);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }

        #endregion

        #region 投资采购管理

        /// <summary>
        /// 获取投资采购分页列表
        /// </summary>
        /// <returns></returns>
        public ApiResult GetInvestmentProcurementPage()
        {
            ResultPageModel pageModel = JsonConvert.DeserializeObject<ResultPageModel>(RequestParm.msg.ToString());
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var query = new RB_InvestmentProcurement_Extend()
            {
                CompanyName = parms.GetStringValue("CompanyName"),
                Type = parms.GetInt("Type"),
            };
            query.MallBaseId = RequestParm.MallBaseId;
            query.TenantId = RequestParm.TenantId;
            var list = procurementModule.GetInvestmentProcurementPageListModule(pageModel.pageIndex, pageModel.pageSize, out long rowsCount, query);
            pageModel.count = Convert.ToInt32(rowsCount);
            pageModel.pageData = list;
            return ApiResult.Success(data: pageModel);
        }



        /// <summary>
        /// 获取投资采购详情
        /// </summary>
        /// <returns></returns>
        public ApiResult GetInvestmentProcurement()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var Id = parms.GetInt("Id", 0);
            var extModel = procurementModule.GetInvestmentProcurementModule(Id);
            return ApiResult.Success(data: extModel);
        }

        /// <summary>
        /// 删除投资采购信息
        /// </summary>
        /// <returns></returns>
        public ApiResult RemoveInvestmentProcurement()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var Id = parms.GetInt("Id", 0);
            var Status = parms.GetInt("Status", 0);
            var flag = procurementModule.RemoveInvestmentProcurementModule(Id, Status);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }

        /// <summary>
        /// 投资采购审核
        /// </summary>
        /// <returns></returns>
        public ApiResult AutitInvestmentProcurement()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            Int32.TryParse(RequestParm.uid, out int Uid);
            var extModel = new RB_InvestmentProcurement_Extend()
            {
                Id = parms.GetInt("Id"),
                AuditStatus = parms.GetInt("AuditStatus"),
                AuditTime = DateTime.Now,
                AuditBy = Uid,
                AuditContent = parms.GetStringValue("AuditContent")
            };
            var flag = procurementModule.AuditInvestmentProcurementModule(extModel);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }
        #endregion

        #region 公司信息管理

        /// <summary>
        /// 获取公司信息分页列表
        /// </summary>
        /// <returns></returns>
        public ApiResult GetCompanyPageList()
        {
            ResultPageModel pageModel = JsonConvert.DeserializeObject<ResultPageModel>(RequestParm.msg.ToString());
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var query = new RB_Company_Extend()
            {
                CompanyName = parms.GetStringValue("CompanyName")
            };
            query.MallBaseId = RequestParm.MallBaseId;
            query.TenantId = RequestParm.TenantId;
            var list = companyModule.GetCompanyPageListModule(pageModel.pageIndex, pageModel.pageSize, out long rowsCount, query);
            pageModel.count = Convert.ToInt32(rowsCount);
            pageModel.pageData = list;
            return ApiResult.Success(data: pageModel);
        }


        /// <summary>
        /// 获取公司信息详情
        /// </summary>
        /// <returns></returns>
        public ApiResult GetCompany()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var CompanyId = parms.GetInt("CompanyId", 0);
            var extModel = companyModule.GetCompanyModule(CompanyId);
            return ApiResult.Success(data: extModel);
        }

        /// <summary>
        /// 删除公司信息
        /// </summary>
        /// <returns></returns>
        public ApiResult RemoveCompany()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var CompanyId = parms.GetInt("CompanyId", 0);
            var Status = parms.GetInt("Status", 0);
            var flag = companyModule.RemoveCompanyModule(CompanyId, Status);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }
        /// <summary>
        /// 更新公司信息
        /// </summary>
        /// <returns></returns>
        public ApiResult UpdateCompanyStatus()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var CompanyId = parms.GetInt("CompanyId", 0);
            var Status = parms.GetInt("CompanyStatus", 0);
            var model = companyModule.GetCompanyEntity(CompanyId);
            if (model == null || model.CompanyId <= 0)
            {
                return ApiResult.Failed("公司信息不存在");
            }
            if (Status != 1 && Status != 2)
            {
                return ApiResult.Failed("状态有误");
            }
            if (model.CompanyStatus == 1)
            {
                return ApiResult.Failed("公司信息已审核通过，请勿重复审核");
            }
            var flag = companyModule.UpdateCompanyStatus(CompanyId, Status);
            if (flag && Status > 0)//推送审核结果
            {
                //查询用户的信息
                var umodel = userModule.GetMemberUserInfo(model.CreateBy);
                if (umodel != null && !string.IsNullOrWhiteSpace(umodel.OpenId))
                {
                    List<string> openidList = new List<string>();
                    openidList.Add(umodel.OpenId);
                    new Module.User.MiniProgramMsgModule().SendHatchExamineMsg(model.TenantId, model.MallBaseId, openidList, Status == 1 ? "认证通过" : "认证失败", "企业认证结果通知", System.DateTime.Now.ToString("yyyy年MM月dd日 HH:mm"));
                }

            }
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }
        #endregion

        #region 商会活动管理

        /// <summary>
        /// 获取商会活动分页列表
        /// </summary>
        /// <returns></returns>
        public ApiResult GetCommerceActivityPage()
        {
            ResultPageModel pageModel = JsonConvert.DeserializeObject<ResultPageModel>(RequestParm.msg.ToString());
            JObject jObj = JObject.Parse(RequestParm.msg.ToString());
            var query = new RB_Commerce_Activity_Extend()
            {
                ActivityName = jObj.GetStringValue("ActivityName")
            };
            query.MallBaseId = RequestParm.MallBaseId;
            query.TenantId = RequestParm.TenantId;
            var list = activityModule.GetCommerceActivityPageListModule(pageModel.pageIndex, pageModel.pageSize, out long rowsCount, query, isQuerySignup: true);
            pageModel.count = Convert.ToInt32(rowsCount);
            pageModel.pageData = list;
            return ApiResult.Success(data: pageModel);
        }

        /// <summary>
        /// 新增修改商会活动
        /// </summary>
        /// <returns></returns>
        public ApiResult SetCommerceActivity()
        {
            JObject jObj = JObject.Parse(RequestParm.msg.ToString());
            var extModel = new RB_Commerce_Activity_Extend()
            {
                Id = jObj.GetInt("Id"),
                ActivityName = jObj.GetStringValue("ActivityName"),
                StartTime = jObj.GetDateTime("StartTime"),
                EndTime = jObj.GetDateTime("EndTime"),
                CoverImg = jObj.GetStringValue("CoverImg"),
                ActivityType = jObj.GetInt("ActivityType"),
                ActivityInfo = jObj.GetStringValue("ActivityInfo"),
                SignStartTime = jObj.GetDateTime("SignStartTime"),
                SignEndTime = jObj.GetDateTime("SignEndTime"),
                IsFree = jObj.GetInt("IsFree", 1),
                Price = jObj.GetInt("Price", 0),
                IsCancelConfirm = jObj.GetInt("IsCancelConfirm", 2)
            };
            try
            {
                extModel.CommerceDetailsList = Common.Plugin.JsonHelper.DeserializeObject<List<RB_Commerce_Details_Extend>>(jObj.GetStringValue("CommerceDetailsList"));
            }
            catch (Exception ex)
            {
                Common.Plugin.LogHelper.Write(ex, "SetCommerceActivity_CommerceDetailsList");
            }
            extModel.Status = Common.Enum.DateStateEnum.Normal;
            extModel.MallBaseId = RequestParm.MallBaseId;
            extModel.TenantId = RequestParm.TenantId;
            Int32.TryParse(RequestParm.uid, out int Uid);
            extModel.CreateBy = Uid;
            extModel.CreateDate = DateTime.Now;
            extModel.UpdateBy = Uid;
            extModel.UpdateDate = DateTime.Now;
            if (extModel.IsFree == 1)
            {
                extModel.Price = 0;
            }
            var flag = activityModule.SetCommerceActivityModule(extModel);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }

        /// <summary>
        /// 获取商会活动详情
        /// </summary>
        /// <returns></returns>
        public ApiResult GetCommerceActivity()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var Id = parms.GetInt("Id", 0);
            var extModel = activityModule.GetCommerceActivityModule(Id);
            return ApiResult.Success(data: extModel);
        }

        /// <summary>
        /// 更新商户活动状态
        /// </summary>
        /// <returns></returns>
        public ApiResult RemoveCommerceActivity()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var Id = parms.GetInt("Id", 0);
            var Status = parms.GetInt("Status", 0);
            var flag = activityModule.RemoveCommerceActivityModule(Id, Status);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }

        /// <summary>
        /// 获取商会活动类型分页列表
        /// </summary>
        /// <returns></returns>
        public ApiResult GetCommerceActivityTypePage()
        {
            ResultPageModel pageModel = JsonConvert.DeserializeObject<ResultPageModel>(RequestParm.msg.ToString());
            JObject jObj = JObject.Parse(RequestParm.msg.ToString());
            var query = new RB_Commerce_ActivityType_Extend()
            {
                TypeName = jObj.GetStringValue("TypeName")
            };
            query.MallBaseId = RequestParm.MallBaseId;
            query.TenantId = RequestParm.TenantId;
            var list = activityModule.GetCommerceActivityTypePageListModule(pageModel.pageIndex, pageModel.pageSize, out long rowsCount, query);
            list.ForEach(x => x.LableNameList = string.IsNullOrWhiteSpace(x.LableName) ? new List<string>() : JsonConvert.DeserializeObject<List<string>>(x.LableName));
            pageModel.count = Convert.ToInt32(rowsCount);
            pageModel.pageData = list;
            return ApiResult.Success(data: pageModel);
        }

        /// <summary>
        /// 获取商会活动类型列表
        /// </summary>
        /// <returns></returns>
        public ApiResult GetCommerceActivityTypeList()
        {
            JObject jObj = JObject.Parse(RequestParm.msg.ToString());
            var query = new RB_Commerce_ActivityType_Extend()
            {
                TypeName = jObj.GetStringValue("TypeName")
            };
            query.MallBaseId = RequestParm.MallBaseId;
            query.TenantId = RequestParm.TenantId;
            var list = activityModule.GetCommerceActivityTypeListModule(query);
            list.ForEach(x => x.LableNameList = string.IsNullOrWhiteSpace(x.LableName) ? new List<string>() : JsonConvert.DeserializeObject<List<string>>(x.LableName));
            return ApiResult.Success(data: list);
        }

        /// <summary>
        /// 新增修改商会活动类型
        /// </summary>
        /// <returns></returns>
        public ApiResult SetCommerceActivityType()
        {
            RB_Commerce_ActivityType_Extend extModel = JsonConvert.DeserializeObject<RB_Commerce_ActivityType_Extend>(RequestParm.msg.ToString());
            //JObject jObj = JObject.Parse(RequestParm.msg.ToString());
            //var extModel = new RB_Commerce_ActivityType_Extend()
            //{
            //    Id = jObj.GetInt("Id"),
            //    TypeName = jObj.GetStringValue("TypeName"),
            //    CoverImage=jObj.GetStringValue("CoverImage")
            //};
            extModel.Status = Common.Enum.DateStateEnum.Normal;
            extModel.MallBaseId = RequestParm.MallBaseId;
            extModel.TenantId = RequestParm.TenantId;
            Int32.TryParse(RequestParm.uid, out int Uid);
            extModel.CreateBy = Uid;
            extModel.CreateDate = DateTime.Now;
            extModel.UpdateBy = Uid;
            extModel.UpdateDate = DateTime.Now;
            if (extModel.LableNameList != null && extModel.LableNameList.Any())
            {
                extModel.LableName = JsonConvert.SerializeObject(extModel.LableNameList);
            }
            else
            {
                extModel.LableName = "";
            }
            var flag = activityModule.SetCommerceActivityTypeModule(extModel);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }

        /// <summary>
        /// 获取商会活动类型详情
        /// </summary>
        /// <returns></returns>
        public ApiResult GetCommerceActivityType()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var Id = parms.GetInt("Id", 0);
            var extModel = activityModule.GetCommerceActivityTypeModule(Id);
            extModel.LableNameList = string.IsNullOrWhiteSpace(extModel.LableName) ? new List<string>() : JsonConvert.DeserializeObject<List<string>>(extModel.LableName);
            return ApiResult.Success(data: extModel);
        }

        /// <summary>
        /// 更新商户活动类型状态
        /// </summary>
        /// <returns></returns>
        public ApiResult RemoveCommerceActivityType()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var Id = parms.GetInt("Id", 0);
            var Status = parms.GetInt("Status", 0);
            var flag = activityModule.RemoveCommerceActivityTypeModule(Id, Status);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }
        #endregion

        #region 商会活动报名管理

        /// <summary>
        /// 获取商会活动报名分页列表
        /// </summary>
        /// <returns></returns>
        public ApiResult GetCommerceConsultPage()
        {
            JObject jObj = JObject.Parse(RequestParm.msg.ToString());
            var query = new RB_Commerce_Consult_Extend()
            {
                ActivityId = jObj.GetInt("ActivityId", 0),
                LinkMan = jObj.GetStringValue("LinkMan"),
                EnrollState = jObj.GetInt("EnrollState", 0)
            };
            query.MallBaseId = RequestParm.MallBaseId;
            query.TenantId = RequestParm.TenantId;
            var list = consultModule.GetCommerceConsultListModule(query);
            return ApiResult.Success(data: list);
        }



        /// <summary>
        /// 根据编号获取商会活动报名实体
        /// </summary>
        /// <returns></returns>
        public ApiResult GetCommerceConsult()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var Id = parms.GetInt("Id", 0);
            var extModel = consultModule.GetCommerceConsultModule(Id);
            return ApiResult.Success(data: extModel);
        }

        /// <summary>
        /// 更新商会活动报名状态
        /// </summary>
        /// <returns></returns>
        public ApiResult RemoveCommerceConsult()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var Id = parms.GetInt("Id", 0);
            var Status = parms.GetInt("Status", 0);
            var flag = consultModule.RemoveCommerceConsultModule(Id, Status);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }

        /// <summary>
        /// 操作商会活动报名申请取消
        /// </summary>
        /// <returns></returns>
        public ApiResult SetCommerceConsultApplyCancel()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var Id = parms.GetInt("Id", 0);
            var ApplyForCancelStatus = parms.GetInt("ApplyForCancelStatus", 0);//申请取消审核状态  1同意  2拒绝
            var RejectRemark = parms.GetStringValue("RejectRemark");//拒绝备注
            if (Id <= 0)
            {
                return ApiResult.ParamIsNull("请传递");
            }
            if (ApplyForCancelStatus == 2)
            {
                if (string.IsNullOrEmpty(RejectRemark))
                {
                    return ApiResult.ParamIsNull("请输入拒绝的原因");
                }
            }
            var flag = consultModule.SetCommerceConsultApplyCancel(Id, ApplyForCancelStatus, RejectRemark);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }
        #endregion

        #region 新闻信息管理

        /// <summary>
        /// 获取新闻信息分页列表
        /// </summary>
        /// <returns></returns>
        public ApiResult GetCommerceNewsPage()
        {
            ResultPageModel pageModel = JsonConvert.DeserializeObject<ResultPageModel>(RequestParm.msg.ToString());
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var query = new RB_Commerce_News_Extend()
            {
                Title = parms.GetStringValue("Title"),
                Type = parms.GetInt("Type"),
            };
            query.MallBaseId = RequestParm.MallBaseId;
            query.TenantId = RequestParm.TenantId;
            var list = commerceNewsModule.GetCommerceNewsPageListModule(pageModel.pageIndex, pageModel.pageSize, out long rowsCount, query);
            pageModel.count = Convert.ToInt32(rowsCount);
            pageModel.pageData = list;
            return ApiResult.Success(data: pageModel);
        }


        /// <summary>
        /// 获取新闻信息详情
        /// </summary>
        /// <returns></returns>
        public ApiResult GetCommerceNews()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var Id = parms.GetInt("Id", 0);
            var extModel = commerceNewsModule.GetCommerceNewsModule(Id);
            return ApiResult.Success(data: extModel);
        }

        /// <summary>
        /// 删除新闻信息
        /// </summary>
        /// <returns></returns>
        public ApiResult RemoveCommerceNews()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var Id = parms.GetInt("Id", 0);
            var Status = parms.GetInt("Status", 0);
            var flag = commerceNewsModule.RemoveCommerceNewsModule(Id, Status);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }

        /// <summary>
        /// 新增修改新闻
        /// </summary>
        /// <returns></returns>
        public ApiResult SetCommerceNews()
        {
            JObject jObj = JObject.Parse(RequestParm.msg.ToString());
            var extModel = new RB_Commerce_News_Extend()
            {
                Id = jObj.GetInt("Id"),
                CoverImg = jObj.GetStringValue("CoverImg"),
                Title = jObj.GetStringValue("Title"),
                Industry = jObj.GetStringValue("Industry"),
                PublishTime = jObj.GetDateTime("PublishTime"),
                NewsInfo = jObj.GetStringValue("NewsInfo"),
                Type = jObj.GetInt("Type"),
                Subtitle = jObj.GetStringValue("Subtitle"),
            };
            extModel.Status = Common.Enum.DateStateEnum.Normal;
            extModel.MallBaseId = RequestParm.MallBaseId;
            extModel.TenantId = RequestParm.TenantId;
            Int32.TryParse(RequestParm.uid, out int Uid);
            extModel.CreateBy = Uid;
            extModel.CreateDate = DateTime.Now;
            extModel.UpdateBy = Uid;
            extModel.UpdateDate = DateTime.Now;
            var flag = commerceNewsModule.SetCommerceNewsModule(extModel);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }
        #endregion

        #region 咨询管理
        /// <summary>
        /// 获取投资采购分页列表
        /// </summary>
        /// <returns></returns>
        public ApiResult GetCommerceAskPage()
        {
            ResultPageModel pageModel = JsonConvert.DeserializeObject<ResultPageModel>(RequestParm.msg.ToString());
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var query = new RB_Commerce_Ask_Extend()
            {
                CompanyName = parms.GetStringValue("CompanyName"),
            };
            query.MallBaseId = RequestParm.MallBaseId;
            query.TenantId = RequestParm.TenantId;
            var list = askModule.GetCommerceAskPageListModule(pageModel.pageIndex, pageModel.pageSize, out long rowsCount, query);
            pageModel.count = Convert.ToInt32(rowsCount);
            pageModel.pageData = list;
            return ApiResult.Success(data: pageModel);
        }

        /// <summary>
        /// 获取新闻信息详情
        /// </summary>
        /// <returns></returns>
        public ApiResult GetCommerceAskInfo()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var Id = parms.GetInt("Id", 0);
            var extModel = askModule.GetCommerceAskModule(Id);
            return ApiResult.Success(data: extModel);
        }

        /// <summary>
        /// 获取新闻信息详情
        /// </summary>
        /// <returns></returns>
        public ApiResult ReplyCommerceAsk()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            Int32.TryParse(RequestParm.uid, out int Uid);
            var model = new RB_Commerce_Ask_Extend()
            {
                Id = parms.GetInt("Id", 0),
                AskStatus = parms.GetInt("AskStatus"),
                ReplyTime = DateTime.Now,
                FatContent = parms.GetStringValue("FatContent"),
                ReplyId = Uid
            };
            var extModel = askModule.ReplyCommerceAskModule(model);
            return ApiResult.Success(data: extModel);
        }
        #endregion

        #region 认证管理

        /// <summary>
        /// 获取认证分页列表
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetAuthenticationPageList()
        {
            var parms = RequestParm;
            var userInfo = this.UserInfo;
            ResultPageModel pagelist = JsonConvert.DeserializeObject<ResultPageModel>(parms.msg.ToString());
            RB_Authentication_Extend demodel = JsonConvert.DeserializeObject<RB_Authentication_Extend>(parms.msg.ToString());
            demodel.TenantId = userInfo.TenantId;
            demodel.MallBaseId = userInfo.MallBaseId;
            var list = authenticationModule.GetAuthenticationPageList_V2(pagelist.pageIndex, pagelist.pageSize, out long count, demodel);
            pagelist.count = Convert.ToInt32(count);
            pagelist.pageData = list.Select(x => new
            {
                x.Id,
                x.Name,
                x.CoverImage,
                x.ImageList,
                x.VideoUrl,
                x.Type,
                TypeName = x.Type.GetEnumName(),
                x.BrandType,
                BrandTypeName = x.BrandType.GetEnumName(),
                OpenTime = x.OpenTime.ToString("yyyy-MM-dd HH:mm"),
                x.Address,
                x.TradingArea,
                x.BusinessType,
                BusinessTypeName = x.BusinessType.GetEnumName(),
                x.BusinessDetail,
                x.Description,
                x.County,
                x.Category,
                CategoryName = x.Category.GetEnumName(),
                x.Contact,
                x.ContactMobile,
                x.AuditState,
                x.AuditRemark,
                AuditDate = x.AuditDate.HasValue ? x.AuditDate.Value.ToString("yyyy-MM-dd HH:mm") : "",
                CreateDate = x.CreateDate.ToString("yyyy-MM-dd HH:mm"),
                x.CreateName,
                x.CreatePhoto
            });
            return ApiResult.Success("", pagelist);
        }

        /// <summary>
        /// 认证Excel下载
        /// </summary>
        [HttpPost]
        public FileContentResult GetAuthenticationListToExcel()
        {
            var userInfo = this.UserInfo;
            RB_Authentication_Extend demodel = JsonConvert.DeserializeObject<RB_Authentication_Extend>(RequestParm.msg.ToString());
            string ExcelName = "首店申请" + DateTime.Now.ToString("yyyyMMddHHmmss") + ".xls";
            List<ExcelDataSource> slist = new List<ExcelDataSource>();
            ExcelDataSource header = new ExcelDataSource()
            {
                ExcelRows = new List<ExcelColumn>(30) {
                    new ExcelColumn(value: "首店名称") { CellWidth = 15, HAlignmentEnum = HAlignmentEnum.CENTER, VAlignmentEnum = VAlignmentEnum.CENTER },
                    new ExcelColumn(value: "封面图") { CellWidth = 15, HAlignmentEnum = HAlignmentEnum.CENTER, VAlignmentEnum = VAlignmentEnum.CENTER },
                    new ExcelColumn(value: "图片") { CellWidth = 15, HAlignmentEnum = HAlignmentEnum.CENTER, VAlignmentEnum = VAlignmentEnum.CENTER },
                    new ExcelColumn(value: "视频") { CellWidth = 15, HAlignmentEnum = HAlignmentEnum.CENTER, VAlignmentEnum = VAlignmentEnum.CENTER },
                    new ExcelColumn(value: "类型") { CellWidth = 15, HAlignmentEnum = HAlignmentEnum.CENTER, VAlignmentEnum = VAlignmentEnum.CENTER },
                    new ExcelColumn(value: "品牌归属地") { CellWidth = 15, HAlignmentEnum = HAlignmentEnum.CENTER, VAlignmentEnum = VAlignmentEnum.CENTER },
                    new ExcelColumn(value: "开业时间") { CellWidth = 15, HAlignmentEnum = HAlignmentEnum.CENTER, VAlignmentEnum = VAlignmentEnum.CENTER },
                    new ExcelColumn(value: "详细地址") { CellWidth = 15, HAlignmentEnum = HAlignmentEnum.CENTER, VAlignmentEnum = VAlignmentEnum.CENTER },
                    new ExcelColumn(value: "商圈") { CellWidth = 15, HAlignmentEnum = HAlignmentEnum.CENTER, VAlignmentEnum = VAlignmentEnum.CENTER },
                    new ExcelColumn(value: "行业") { CellWidth = 15, HAlignmentEnum = HAlignmentEnum.CENTER, VAlignmentEnum = VAlignmentEnum.CENTER },
                    new ExcelColumn(value: "首店业种类型") { CellWidth = 15, HAlignmentEnum = HAlignmentEnum.CENTER, VAlignmentEnum = VAlignmentEnum.CENTER },
                    new ExcelColumn(value: "简介") { CellWidth = 15, HAlignmentEnum = HAlignmentEnum.CENTER, VAlignmentEnum = VAlignmentEnum.CENTER },
                    new ExcelColumn(value: "所在区县") { CellWidth = 15, HAlignmentEnum = HAlignmentEnum.CENTER, VAlignmentEnum = VAlignmentEnum.CENTER },
                    new ExcelColumn(value: "类别") { CellWidth = 15, HAlignmentEnum = HAlignmentEnum.CENTER, VAlignmentEnum = VAlignmentEnum.CENTER },
                    new ExcelColumn(value: "联系人") { CellWidth = 15, HAlignmentEnum = HAlignmentEnum.CENTER, VAlignmentEnum = VAlignmentEnum.CENTER },
                    new ExcelColumn(value: "联系电话") { CellWidth = 15, HAlignmentEnum = HAlignmentEnum.CENTER, VAlignmentEnum = VAlignmentEnum.CENTER },
                    new ExcelColumn(value: "审核状态") { CellWidth = 15, HAlignmentEnum = HAlignmentEnum.CENTER, VAlignmentEnum = VAlignmentEnum.CENTER },
                    new ExcelColumn(value: "申请时间") { CellWidth = 15, HAlignmentEnum = HAlignmentEnum.CENTER, VAlignmentEnum = VAlignmentEnum.CENTER },
                }
            };

            slist.Add(header);

            try
            {
                demodel.TenantId = userInfo.TenantId;
                demodel.MallBaseId = userInfo.MallBaseId;
                var list = authenticationModule.GetAuthenticationPageList_V2(1, 100000, out long count, demodel);
                #region 组装数据
                foreach (var item in list)
                {
                    string AuditState = "审核中";
                    if (item.AuditState == 2)
                    {
                        AuditState = "通过";
                    }
                    else if (item.AuditState == 3)
                    {
                        AuditState = "不通过";
                    }
                    ExcelDataSource datarow = new ExcelDataSource()
                    {
                        ExcelRows = new List<ExcelColumn>(30) {
                            new ExcelColumn(value:item.Name){ },
                            new ExcelColumn(value:item.CoverImage){ },
                            new ExcelColumn(value:item.Images){ },
                            new ExcelColumn(value:item.VideoUrl){ },
                            new ExcelColumn(value:item.Type.GetEnumName()){ },
                            new ExcelColumn(value:item.BrandType.GetEnumName()){ },
                            new ExcelColumn(value:item.OpenTime.ToString("yyyy-MM-dd HH:mm")){ },
                            new ExcelColumn(value:item.Address){ },
                            new ExcelColumn(value:item.TradingArea){ },
                            new ExcelColumn(value:item.BusinessType.GetEnumName()){ },
                            new ExcelColumn(value:item.BusinessDetail){ },
                            new ExcelColumn(value:item.Description){ },
                            new ExcelColumn(value:item.County){ },
                            new ExcelColumn(value:item.Category.GetEnumName()){ },
                            new ExcelColumn(value:item.Contact){ },
                            new ExcelColumn(value:item.ContactMobile){ },
                            new ExcelColumn(value:AuditState){ },
                            new ExcelColumn(value:item.CreateDate.ToString("yyyy-MM-dd HH:mm")){ }
                        }
                    };
                    slist.Add(datarow);
                }
                #endregion

                var byteData = ExcelTempLateHelper.ToExcelExtend(slist);

                return File(byteData, "application/octet-stream", ExcelName);
            }
            catch (Exception ex)
            {
                LogHelper.Write(ex, string.Format("GetFileFromWebApi_requestData: {0}", JsonHelper.Serialize(RequestParm)));
                var byteData1 = ExcelTempLateHelper.ToExcelExtend(slist);
                return File(byteData1, "application/octet-stream", ExcelName);
            }

        }

        /// <summary>
        /// 获取认证详情
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetAuthenticationInfo()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            int AuthenticationId = parms.GetInt("AuthenticationId", 0);
            if (AuthenticationId <= 0)
            {
                return ApiResult.ParamIsNull("请传递认证id");
            }
            var model = authenticationModule.GetAuthenticationInfo(AuthenticationId);
            if (model == null) { return ApiResult.Failed("认证不存在"); }
            return ApiResult.Success("", new
            {
                model.Id,
                model.Name,
                model.CoverImage,
                model.ImageList,
                model.VideoUrl,
                model.Type,
                TypeName = model.Type.GetEnumName(),
                model.BrandType,
                BrandTypeName = model.BrandType.GetEnumName(),
                OpenTime = model.OpenTime.ToString("yyyy-MM-dd HH:mm"),
                model.Address,
                model.TradingArea,
                model.BusinessType,
                BusinessTypeName = model.BusinessType.GetEnumName(),
                model.BusinessDetail,
                model.Description,
                model.County,
                model.Category,
                CategoryName = model.Category.GetEnumName(),
                model.Contact,
                model.ContactMobile,
                model.AuditState,
                model.AuditRemark,
                AuditDate = model.AuditDate.HasValue ? model.AuditDate.Value.ToString("yyyy-MM-dd HH:mm") : "",
                CreateDate = model.CreateDate.ToString("yyyy-MM-dd HH:mm")
            });
        }

        /// <summary>
        /// 认证审核
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult SetAuthenticationAudit()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            int AuthenticationId = parms.GetInt("AuthenticationId", 0);
            int AuditState = parms.GetInt("AuditState", 0);//审核状态  2审核通过   3审核不通过
            string AuditRemark = parms.GetStringValue("AuditRemark");
            if (AuthenticationId <= 0)
            {
                return ApiResult.ParamIsNull("请传递认证id");
            }
            if (AuditState != 2 && AuditState != 3)
            {
                return ApiResult.Failed("状态有误");
            }
            bool flag = authenticationModule.SetAuthenticationAudit(AuthenticationId, AuditState, AuditRemark);
            if (flag)
            {
                //查询用户的信息
                var model = authenticationModule.GetAuthenticationInfo(AuthenticationId);
                var umodel = userModule.GetMemberUserInfo(model.CreateBy);
                if (umodel != null && !string.IsNullOrWhiteSpace(umodel.OpenId))
                {
                    List<string> openidList = new List<string>();
                    openidList.Add(umodel.OpenId);
                    new Module.User.MiniProgramMsgModule().SendHatchExamineMsg(model.TenantId, model.MallBaseId, openidList, AuditState == 2 ? "认证通过" : "认证失败", "首店认证结果通知", System.DateTime.Now.ToString("yyyy年MM月dd日 HH:mm"));
                }
                return ApiResult.Success();
            }
            else
            {
                return ApiResult.Failed();
            }
        }

        #endregion

        #region 载体信息
        /// <summary>
        /// 获取载体分页列表
        /// </summary>
        /// <returns></returns>
        [HttpGet]
        [HttpPost]
        public ApiResult GetCarrierPageList()
        {
            ResultPageModel pageModel = JsonConvert.DeserializeObject<ResultPageModel>(RequestParm.msg.ToString());
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var query = new RB_Carrier_Extend()
            {
                MetroName = parms.GetStringValue("MetroName"),
                CarrierName = parms.GetStringValue("CarrierName"),
                MetroNum = parms.GetInt("MetroNum", 0),
                Developers = parms.GetStringValue("Developers"),
                StartOpenTime = parms.GetStringValue("StartOpenTime"),
                EndOpenTime = parms.GetStringValue("EndOpenTime"),
                ProjectType = (Common.Enum.TradePavilion.ProjectTypeEnum)parms.GetInt("ProjectType", 0)
            };
            query.MallBaseId = RequestParm.MallBaseId;
            query.TenantId = RequestParm.TenantId;
            var list = carrierModule.GetCarrierPageList(pageModel.pageIndex, pageModel.pageSize, out long rowsCount, query);
            pageModel.count = Convert.ToInt32(rowsCount);
            pageModel.pageData = list.Select(x => new
            {
                x.ID,
                x.CarrierName,
                x.Logo,
                CreateDate = x.CreateDate.ToString("yyyy-MM-dd HH:mm"),
                x.Address,
                x.LatAndLon,
                x.Developers,
                OpenTime = x.OpenTime.HasValue ? x.OpenTime.Value.ToString("yyyy-MM-dd HH:mm") : "",
                x.ProjectType,
                ProjectTypeName = x.ProjectType.GetEnumName(),
                x.CarrierSize,
                x.LayersNum,
                x.CarNum,
                x.CarrierPlan,
                x.CarrierTarget,
                x.Location,
                x.Crowd,
                x.VideoUrl,
                x.CarrierMetroList
            });
            return ApiResult.Success(data: pageModel);
        }


        /// <summary>
        /// 获取载体实体
        /// </summary>
        /// <returns></returns>
        [HttpGet]

        [HttpPost]
        public ApiResult GetCarrierDetails()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var query = new RB_Carrier_Extend()
            {
                ID = parms.GetInt("ID", 0),
            };
            query.MallBaseId = RequestParm.MallBaseId;
            query.TenantId = RequestParm.TenantId;
            var extModel = carrierModule.GetCarrierModel(query);
            return ApiResult.Success(data: extModel);
        }

        /// <summary>
        /// 新增/修改载体信息
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetSetCarrier()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            RB_Carrier_Extend query = JsonConvert.DeserializeObject<RB_Carrier_Extend>(RequestParm.msg.ToString());
            if (string.IsNullOrWhiteSpace(query.CarrierName))
            {
                return ApiResult.Failed("请输入载体名称");
            }
            
            if (string.IsNullOrWhiteSpace(query.Developers))
            {
                return ApiResult.Failed("请输入开发商");
            }
            if (query.BannerList == null || !query.BannerList.Any())
            {
                return ApiResult.Failed("请上传介绍图");
            }
            if (query.BannerList != null && query.BannerList.Any())
            {
                query.Banner = JsonConvert.SerializeObject(query.BannerList);
            }
            else
            {
                query.Banner = "";
            }
            if (query.ID == 0)
            {
                query.CreateDate = System.DateTime.Now;
                query.MallBaseId = RequestParm.MallBaseId;
                query.TenantId = RequestParm.TenantId;
            }
            query.UpdateDate = System.DateTime.Now;
            bool flag = carrierModule.SetCarrier(query);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }



        /// <summary>
        /// 删除载体信息
        /// </summary>
        /// <returns></returns>
        public ApiResult RemoveCarrier()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var CarrierId = parms.GetInt("CarrierId", 0);
            var Status = parms.GetInt("Status", 0);
            var flag = carrierModule.RemoveCarrierModule(CarrierId, RequestParm.TenantId, RequestParm.MallBaseId, Status);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }
        #endregion


        #region 品牌管理


        /// <summary>
        /// 获取商品性质枚举
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        [AllowAnonymous]
        public ApiResult GetProjectTypeEnumList()
        {
            var list = EnumHelper.GetEnumList(typeof(Common.Enum.TradePavilion.ProjectTypeEnum));
            return ApiResult.Success("", list.OrderBy(x => Convert.ToInt32(x.Value)).Select(x => new
            {
                Name = x.Key,
                Id = Convert.ToInt32(x.Value)
            }));
        }

        /// <summary>
        /// 获取品牌分类分页列表
        /// </summary>
        /// <returns></returns>
        [HttpGet]
        [HttpPost]
        public ApiResult GetBrandClassPageList()
        {
            ResultPageModel pageModel = JsonConvert.DeserializeObject<ResultPageModel>(RequestParm.msg.ToString());
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var query = new RB_BrandClass_Extend()
            {
                ClassName = parms.GetStringValue("ClassName")
            };
            query.MallBaseId = RequestParm.MallBaseId;
            query.TenantId = RequestParm.TenantId;
            var list = carrierModule.GetBrandClassPageListRepository(pageModel.pageIndex, pageModel.pageSize, out long rowsCount, query);
            pageModel.count = Convert.ToInt32(rowsCount);
            pageModel.pageData = list;
            return ApiResult.Success(data: pageModel);
        }

        /// <summary>
        /// 获取品牌分类分页列表
        /// </summary>
        /// <returns></returns>
        [HttpGet]
        [HttpPost]
        public ApiResult GetBrandClassList()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var query = new RB_BrandClass_Extend();
            query.MallBaseId = RequestParm.MallBaseId;
            query.TenantId = RequestParm.TenantId;
            var list = carrierModule.GetBrandClassList(query);
            return ApiResult.Success(data: list);
        }

        /// <summary>
        /// 获取品牌分类实体
        /// </summary>
        /// <returns></returns>
        [HttpGet]
        [HttpPost]
        public ApiResult GetBrandClassDetails()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var query = new RB_BrandClass_Extend()
            {
                ID = parms.GetInt("ID", 0),
            };
            query.MallBaseId = RequestParm.MallBaseId;
            query.TenantId = RequestParm.TenantId;
            var extModel = carrierModule.GetBrandClassRepository(query);
            return ApiResult.Success(data: extModel);
        }

        /// <summary>
        /// 新增/修改品牌信息
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetSetBrandClass()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            RB_BrandClass_Extend query = JsonConvert.DeserializeObject<RB_BrandClass_Extend>(RequestParm.msg.ToString());
            if (string.IsNullOrWhiteSpace(query.ClassName))
            {
                return ApiResult.Failed("请输入分类名称");
            }
            //if (string.IsNullOrWhiteSpace(query.Logo))
            //{
            //    return ApiResult.Failed("请上传Logo");
            //}
            if (query.ID == 0)
            {
                query.CreateDate = System.DateTime.Now;
                query.MallBaseId = RequestParm.MallBaseId;
                query.TenantId = RequestParm.TenantId;
            }
            query.Status = 0;
            query.UpdateDate = System.DateTime.Now;
            bool flag = carrierModule.SetBrandClass(query);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }

        /// <summary>
        /// 删除品牌信息
        /// </summary>
        /// <returns></returns>
        public ApiResult RemoveBrandClass()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var CarrierId = parms.GetInt("Id", 0);
            var flag = carrierModule.RemoveBrandClassModule(CarrierId);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }

        /// <summary>
        /// 获取品牌分页列表
        /// </summary>
        /// <returns></returns>
        [HttpGet]
        [HttpPost]
        public ApiResult GetBrandPageList()
        {
            ResultPageModel pageModel = JsonConvert.DeserializeObject<ResultPageModel>(RequestParm.msg.ToString());
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var query = new RB_Brand_Extend()
            {
                BrandName = parms.GetStringValue("BrandName"),
                ProjectType = (Common.Enum.TradePavilion.ProjectTypeEnum)parms.GetInt("ProjectType", 0),
                BrandClassId = parms.GetInt("BrandClassId", 0),
                RanQi = parms.GetInt("RanQi", -1),
                KongTiao = parms.GetInt("KongTiao", -1),
                XinFeng = parms.GetInt("XinFeng", -1),
                Plumbing = parms.GetInt("Plumbing", -1),
                Caliber = parms.GetInt("Caliber", -1),
                Sewage = parms.GetInt("Sewage", -1),
                PaiYan = parms.GetInt("PaiYan", -1),
                DianLiang = parms.GetStringValue("DianLiang"),
            };
            query.MallBaseId = RequestParm.MallBaseId;
            query.TenantId = RequestParm.TenantId;
            var list = carrierModule.GetBrandPageList(pageModel.pageIndex, pageModel.pageSize, out long rowsCount, query);
            foreach (var item in list)
            {
                item.ProjectName = item.ClassName;
                if (!string.IsNullOrWhiteSpace(item.Banner))
                {
                    item.BannerList = JsonConvert.DeserializeObject<List<string>>(item.Banner);
                }
                else
                {
                    item.BannerList = new List<string>();
                }
            }
            pageModel.count = Convert.ToInt32(rowsCount);
            pageModel.pageData = list;
            return ApiResult.Success(data: pageModel);
        }


        /// <summary>
        /// 获取品牌分类实体
        /// </summary>
        /// <returns></returns>
        [HttpGet]

        [HttpPost]
        public ApiResult GetBrandDetails()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var query = new RB_Brand_Extend()
            {
                ID = parms.GetInt("ID", 0),

            };
            query.MallBaseId = RequestParm.MallBaseId;
            query.TenantId = RequestParm.TenantId;
            var extModel = carrierModule.GetBrand(query);

            if (!string.IsNullOrWhiteSpace(extModel.Banner))
            {
                extModel.BannerList = JsonConvert.DeserializeObject<List<string>>(extModel.Banner);
            }
            else
            {
                extModel.BannerList = new List<string>();
            }
            return ApiResult.Success(data: extModel);
        }

        /// <summary>
        /// 新增/修改品牌信息
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetSetBrand()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            RB_Brand_Extend query = JsonConvert.DeserializeObject<RB_Brand_Extend>(RequestParm.msg.ToString());
            if (string.IsNullOrWhiteSpace(query.BrandName))
            {
                return ApiResult.Failed("请输入品牌名称");
            }
            if (string.IsNullOrWhiteSpace(query.Logo))
            {
                return ApiResult.Failed("请上传Logo");
            }

            if (query.BrandClassId == 0)
            {
                return ApiResult.Failed("请选择品牌分类");
            }
            if (query.BannerList != null && query.BannerList.Any())
            {
                query.Banner = JsonConvert.SerializeObject(query.BannerList);
            }
            else
            {
                query.Banner = "";
            }
            if (query.ID == 0)
            {
                query.CreateDate = System.DateTime.Now;
                query.MallBaseId = RequestParm.MallBaseId;
                query.TenantId = RequestParm.TenantId;
            }
            query.Status = 0;
            query.UpdateDate = System.DateTime.Now;
            bool flag = carrierModule.SetBrand(query);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }

        /// <summary>
        /// 删除品牌信息
        /// </summary>
        /// <returns></returns>
        public ApiResult RemoveBrand()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var CarrierId = parms.GetInt("Id", 0);
            var flag = carrierModule.RemoveBrandModule(CarrierId);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }
        #endregion
    }
}
