﻿using VT.FW.DB;
using System;
using System.Collections.Generic;
using System.Text;
using Mall.Model.Entity.Product;

namespace Mall.Model.Extend.Product
{
    /// <summary>
    /// 商品评论表扩展实体
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_Goods_Comment_Extend : RB_Goods_Comment
    {
        /// <summary>
        /// 商品图片
        /// </summary>
        public string CarouselImage { get; set; }
        /// <summary>
        /// 商品名称
        /// </summary>
        public string GoodsName { get; set; }
        /// <summary>
        /// 封面图
        /// </summary>
        public string CoverImage { get; set; }
        /// <summary>
        /// 评论图片列表
        /// </summary>
        public List<string> CommentImgList { get; set; }
        /// <summary>
        /// 头像路径
        /// </summary>
        public string UserPhotoPath { get; set; }
        /// <summary>
        /// 评论数量
        /// </summary>
        public int CommentNum { get; set; }

        /// <summary>
        /// 评论总分
        /// </summary>
        public decimal TotalCarScore { get; set; }


        /// <summary>
        /// 评论总分
        /// </summary>
        public decimal TotalGuideScore { get; set; }
    }
}
