﻿using VT.FW.DB;
using Mall.Common.Enum.MarketingCenter;
using System;
using System.Collections.Generic;
using System.Text;

namespace Mall.Model.Entity.Education
{
    /// <summary>
    ///  教育-课程卡实体表
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_Education_Coupon
    {

        public int ID { get; set; }

        /// <summary>
        /// 商户id
        /// </summary>
        public int TenantId { get; set; }

        /// <summary>
        /// 小程序id
        /// </summary>
        public int MallBaseId { get; set; }


        public int Status { get; set; }

        public DateTime CreateDate { get; set; }
        public DateTime UpdateDate { get; set; }
        public string Name { get; set; }

        public string CouponIco { get; set; }


        /// <summary>
        /// 领取方式设置1-领劵中心
        /// </summary>
        public int PickupCenter { get; set; }

        /// <summary>
        /// 店铺id
        /// </summary>
        public int SmallShopId { get; set; }


        /// <summary>
        /// 是否赞羊使用0-否，1-是
        /// </summary>
        public int IsZanYangUse { get; set; }

        /// <summary>
        /// 有效期类型，1-领取后N天内有效，2-时间段
        /// </summary>
        public IndateTypeEnum IndateType { get; set; }


        /// <summary>
        /// 有效天数
        /// </summary>
        public int IndateDay { get; set; }

        /// <summary>
        /// 总核销次数
        /// </summary>
        public int HeXiao { get; set; }

        /// <summary>
        /// 可发放数量,-1 无限制
        /// </summary>
        public int TotalNum { get; set; }



        /// <summary>
        /// 1-指定商品类型，2-指定商品，3-全场通用，4-当面付
        /// </summary>
        public UseTypeEnum UseType { get; set; }

        /// <summary>
        /// 描述
        /// </summary>
        public string Describe { get; set; }


        /// <summary>
        /// 领取数量
        /// </summary>
        public int ReceiveNum { get; set; }

        /// <summary>
        /// 有效期开始时间
        /// </summary>
        public DateTime? StartDate { get; set; }

        /// <summary>
        /// 有效期结束时间
        /// </summary>
        public DateTime? EndDate { get; set; }
    }
}
