﻿using Mall.Common.Plugin;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Mall.Common.Enum.Goods
{
    /// <summary>
    /// 分销订单导出选项枚举
    /// </summary>
    public enum DistributionOrdersExportEnum
    {
        /// <summary>
        /// 所属平台
        /// </summary>
        [EnumField("所属平台")]
        SSPT = 1,
        /// <summary>
        /// 订单号
        /// </summary>
        [EnumField("订单号")]
        DDH = 2,
        /// <summary>
        /// 下单用户
        /// </summary>
        [EnumField("下单用户")]
        XDYH = 4,
        /// <summary>
        /// 商品名
        /// </summary>
        [EnumField("商品名")]
        SPM = 5,
        /// <summary>
        /// 规格
        /// </summary>
        [EnumField("规格")]
        GG = 6,
        /// <summary>
        /// 数量
        /// </summary>
        [EnumField("数量")]
        SL = 7,
        /// <summary>
        /// 货号
        /// </summary>
        [EnumField("货号")]
        HH = 8,
        /// <summary>
        /// 收件人
        /// </summary>
        [EnumField("收件人")]
        SJR = 10,
        /// <summary>
        /// 收件人电话
        /// </summary>
        [EnumField("收件人电话")]
        SJRDH = 11,
        /// <summary>
        /// 收件人地址
        /// </summary>
        [EnumField("收件人地址")]
        SJRDZ = 12,
        /// <summary>
        /// 总金额
        /// </summary>
        [EnumField("总金额")]
        ZJE = 13,
        /// <summary>
        /// 实际付款
        /// </summary>
        [EnumField("实际付款")]
        SJFK = 14,
        /// <summary>
        /// 下单时间
        /// </summary>
        [EnumField("下单时间")]
        XDSJ = 16,
        /// <summary>
        /// 订单状态
        /// </summary>
        [EnumField("订单状态")]
        DDZT = 17,
        /// <summary>
        /// 支付方式
        /// </summary>
        [EnumField("支付方式")]
        ZFFS = 18,        
        /// <summary>
        /// 付款状态
        /// </summary>
        [EnumField("支付状态")]
        FKZT = 19,
        /// <summary>
        /// 付款时间
        /// </summary>
        [EnumField("支付时间")]
        FKSJ = 20,
        /// <summary>
        /// 备注/表单
        /// </summary>
        [EnumField("备注/表单")]
        BZBD = 21,
        /// <summary>
        /// 买家留言
        /// </summary>
        [EnumField("买家留言")]
        MJLY = 22,
        /// <summary>
        /// 自购返利
        /// </summary>
        [EnumField("自购返利")]
        SJBZ = 23,
        /// <summary>
        /// 一级分销商
        /// </summary>
        [EnumField("一级分销商")]
        YJFXS = 24,
        /// <summary>
        /// 二级分销商
        /// </summary>
        [EnumField("二级分销商")]
        EJFXS = 25,
        /// <summary>
        /// 三级分销商
        /// </summary>
        [EnumField("三级分销商")]
        SJFXS = 26,
        /// <summary>
        /// 一级佣金
        /// </summary>
        [EnumField("一级佣金")]
        YJYJ = 27,
        /// <summary>
        /// 二级佣金
        /// </summary>
        [EnumField("二级佣金")]
        EJYJ = 28,
        /// <summary>
        /// 三级佣金
        /// </summary>
        [EnumField("三级佣金")]
        SJYJ = 29
    }

    /// <summary>
    /// 粉象分销订单导出
    /// </summary>
    public enum DistributionOrdersExportForFXEnum
    {
        /// <summary>
        /// 所属平台
        /// </summary>
        [EnumField("所属平台")]
        SSPT = 1,
        /// <summary>
        /// 订单号
        /// </summary>
        [EnumField("订单号")]
        DDH = 2,
        /// <summary>
        /// 下单用户
        /// </summary>
        [EnumField("下单用户")]
        XDYH = 4,
        /// <summary>
        /// 商品名
        /// </summary>
        [EnumField("商品名")]
        SPM = 5,
        /// <summary>
        /// 规格
        /// </summary>
        [EnumField("规格")]
        GG = 6,
        /// <summary>
        /// 数量
        /// </summary>
        [EnumField("数量")]
        SL = 7,
        /// <summary>
        /// 货号
        /// </summary>
        [EnumField("货号")]
        HH = 8,
        /// <summary>
        /// 收件人
        /// </summary>
        [EnumField("收件人")]
        SJR = 10,
        /// <summary>
        /// 收件人电话
        /// </summary>
        [EnumField("收件人电话")]
        SJRDH = 11,
        /// <summary>
        /// 收件人地址
        /// </summary>
        [EnumField("收件人地址")]
        SJRDZ = 12,
        /// <summary>
        /// 总金额
        /// </summary>
        [EnumField("总金额")]
        ZJE = 13,
        /// <summary>
        /// 实际付款
        /// </summary>
        [EnumField("实际付款")]
        SJFK = 14,
        /// <summary>
        /// 下单时间
        /// </summary>
        [EnumField("下单时间")]
        XDSJ = 16,
        /// <summary>
        /// 订单状态
        /// </summary>
        [EnumField("订单状态")]
        DDZT = 17,
        /// <summary>
        /// 支付方式
        /// </summary>
        [EnumField("支付方式")]
        ZFFS = 18,
        /// <summary>
        /// 付款状态
        /// </summary>
        [EnumField("支付状态")]
        FKZT = 19,
        /// <summary>
        /// 付款时间
        /// </summary>
        [EnumField("支付时间")]
        FKSJ = 20,
        /// <summary>
        /// 备注/表单
        /// </summary>
        [EnumField("备注/表单")]
        BZBD = 21,
        /// <summary>
        /// 买家留言
        /// </summary>
        [EnumField("买家留言")]
        MJLY = 22,
        /// <summary>
        /// 返利级别
        /// </summary>
        [EnumField("返利级别")]
        FLJB = 23,
        /// <summary>
        /// 昵称
        /// </summary>
        [EnumField("昵称")]
        NCXM = 24,
        /// <summary>
        /// 佣金金额
        /// </summary>
        [EnumField("佣金金额")]
        YJJE = 25
    }

    /// <summary>
    /// 推荐分销订单导出
    /// </summary>
    public enum DistributionOrdersExportForRecommendEnum
    {
        /// <summary>
        /// 所属平台
        /// </summary>
        [EnumField("所属平台")]
        SSPT = 1,
        /// <summary>
        /// 订单号
        /// </summary>
        [EnumField("订单号")]
        DDH = 2,
        /// <summary>
        /// 下单用户
        /// </summary>
        [EnumField("下单用户")]
        XDYH = 4,
        /// <summary>
        /// 商品名
        /// </summary>
        [EnumField("商品名")]
        SPM = 5,
        /// <summary>
        /// 规格
        /// </summary>
        [EnumField("规格")]
        GG = 6,
        /// <summary>
        /// 数量
        /// </summary>
        [EnumField("数量")]
        SL = 7,
        /// <summary>
        /// 货号
        /// </summary>
        [EnumField("货号")]
        HH = 8,
        /// <summary>
        /// 收件人
        /// </summary>
        [EnumField("收件人")]
        SJR = 10,
        /// <summary>
        /// 收件人电话
        /// </summary>
        [EnumField("收件人电话")]
        SJRDH = 11,
        /// <summary>
        /// 收件人地址
        /// </summary>
        [EnumField("收件人地址")]
        SJRDZ = 12,
        /// <summary>
        /// 总金额
        /// </summary>
        [EnumField("总金额")]
        ZJE = 13,
        /// <summary>
        /// 实际付款
        /// </summary>
        [EnumField("实际付款")]
        SJFK = 14,
        /// <summary>
        /// 下单时间
        /// </summary>
        [EnumField("下单时间")]
        XDSJ = 16,
        /// <summary>
        /// 订单状态
        /// </summary>
        [EnumField("订单状态")]
        DDZT = 17,
        /// <summary>
        /// 支付方式
        /// </summary>
        [EnumField("支付方式")]
        ZFFS = 18,
        /// <summary>
        /// 付款状态
        /// </summary>
        [EnumField("支付状态")]
        FKZT = 19,
        /// <summary>
        /// 付款时间
        /// </summary>
        [EnumField("支付时间")]
        FKSJ = 20,
        /// <summary>
        /// 备注/表单
        /// </summary>
        [EnumField("备注/表单")]
        BZBD = 21,
        /// <summary>
        /// 买家留言
        /// </summary>
        [EnumField("买家留言")]
        MJLY = 22,
        /// <summary>
        /// 推荐人
        /// </summary>
        [EnumField("推荐人")]
        NCXM = 24,
        /// <summary>
        /// 佣金金额
        /// </summary>
        [EnumField("佣金金额")]
        YJJE = 25
    }

    /// <summary>
    /// 微店订单导出
    /// </summary>
    public enum SmallShopsOrdersExportEnum
    {
        /// <summary>
        /// 所属平台
        /// </summary>
        [EnumField("所属平台")]
        SSPT = 1,
        /// <summary>
        /// 订单号
        /// </summary>
        [EnumField("订单号")]
        DDH = 2,
        /// <summary>
        /// 下单用户
        /// </summary>
        [EnumField("下单用户")]
        XDYH = 4,
        /// <summary>
        /// 商品名
        /// </summary>
        [EnumField("商品名")]
        SPM = 5,
        /// <summary>
        /// 规格
        /// </summary>
        [EnumField("规格")]
        GG = 6,
        /// <summary>
        /// 数量
        /// </summary>
        [EnumField("数量")]
        SL = 7,
        /// <summary>
        /// 货号
        /// </summary>
        [EnumField("货号")]
        HH = 8,
        /// <summary>
        /// 收件人
        /// </summary>
        [EnumField("收件人")]
        SJR = 10,
        /// <summary>
        /// 收件人电话
        /// </summary>
        [EnumField("收件人电话")]
        SJRDH = 11,
        /// <summary>
        /// 收件人地址
        /// </summary>
        [EnumField("收件人地址")]
        SJRDZ = 12,
        /// <summary>
        /// 总金额
        /// </summary>
        [EnumField("总金额")]
        ZJE = 13,
        /// <summary>
        /// 实际付款
        /// </summary>
        [EnumField("实际付款")]
        SJFK = 14,
        /// <summary>
        /// 下单时间
        /// </summary>
        [EnumField("下单时间")]
        XDSJ = 16,
        /// <summary>
        /// 订单状态
        /// </summary>
        [EnumField("订单状态")]
        DDZT = 17,
        /// <summary>
        /// 支付方式
        /// </summary>
        [EnumField("支付方式")]
        ZFFS = 18,
        /// <summary>
        /// 付款状态
        /// </summary>
        [EnumField("支付状态")]
        FKZT = 19,
        /// <summary>
        /// 付款时间
        /// </summary>
        [EnumField("支付时间")]
        FKSJ = 20,
        /// <summary>
        /// 备注/表单
        /// </summary>
        [EnumField("备注/表单")]
        BZBD = 21,
        /// <summary>
        /// 买家留言
        /// </summary>
        [EnumField("买家留言")]
        MJLY = 22,
        /// <summary>
        /// 微店名称
        /// </summary>
        [EnumField("微店名称")]
        WDMC = 23,
        /// <summary>
        /// 用户昵称
        /// </summary>
        [EnumField("用户昵称")]
        NCXM = 24,
        /// <summary>
        /// 佣金金额
        /// </summary>
        [EnumField("佣金金额")]
        YJJE = 25
    }
}
