﻿using Mall.Common.Enum.TradePavilion;
using Mall.Model.Entity.TradePavilion;
using System;
using System.Collections.Generic;
using System.Text;

namespace Mall.Model.Extend.TradePavilion
{
    /// <summary>
    /// 商会活动报名扩展实体类
    /// </summary>
    public class RB_Commerce_Consult_Extend : RB_Commerce_Consult
    {
        /// <summary>
        /// 活动编号【查询使用】
        /// </summary>
        public string QActivityIds { get; set; }

        /// <summary>
        /// 用户编号【查询使用】
        /// </summary>
        public string QUserIds { get; set; }

        /// <summary>
        /// 报名时间
        /// </summary>
        public string CreateTimeStr { get { return Common.ConvertHelper.FormatTime(this.CreateTime); } }

        /// <summary>
        /// 报名状态   1正常  2取消  3查询所有
        /// </summary>
        public int EnrollState { get; set; }

        /// <summary>
        /// 活动名称
        /// </summary>
        public string ActivityName { get; set; }

        /// <summary>
        /// 活动封面图
        /// </summary>
        public string CoverImg { get; set; }
        /// <summary>
        /// 活动开始时间
        /// </summary>
        public DateTime? StartTime { get; set; }
        /// <summary>
        /// 活动结束时间
        /// </summary>
        public DateTime? EndTime { get; set; }

        /// <summary>
        /// 类型名称
        /// </summary>
        public string TypeName { get; set; }
    }



    /// <summary>
    /// 首店活动报名
    /// </summary>

    public class FirstShopConsult
    {
        /// <summary>
        /// 单位/企业/机构名称
        /// </summary>
        public string CompanyName { get; set; }

        /// <summary>
        /// 性质
        /// </summary>
        public NatureEnum? Nature { get; set; }

        /// <summary>
        /// 活动ids
        /// </summary>
        public string ActivityIds { get; set; }

        /// <summary>
        /// 备注
        /// </summary>
        public string Remark { get; set; }


        /// <summary>
        /// 报名人信息
        /// </summary>
        public List<FirstShopLinkManModel> FirstShopLinkManList { get; set; }
    }


    /// <summary>
    /// 首店活动报名
    /// </summary>
    public class FirstShopLinkManModel
    {



        /// <summary>
        /// 联系人
        /// </summary>
        public string LinkMan { get; set; }

        /// <summary>
        /// 联系电话
        /// </summary>
        public string LinkTel { get; set; }

        /// <summary>
        /// 职务
        /// </summary>
        public string Post { get; set; }


        /// <summary>
        /// 所属国籍/省/市
        /// </summary>
        public string CountryInfo { get; set; }
    }
}
