﻿using VT.FW.DB;
using Mall.Common.Enum.User;
using System;
using System.Collections.Generic;
using System.Text;

namespace Mall.Model.Entity.User
{
    /// <summary>
    /// 商户分销基础表实体
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_Distributor_Basics
    {

        /// <summary>
        /// Id
        /// </summary>        
        public int Id
        {
            get;
            set;
        }
        /// <summary>
        /// 分销商层级 0关闭  1 一级  2二级  3三级 
        /// </summary>        
        public int? DistributorTier
        {
            get;
            set;
        }
        /// <summary>
        /// 分销内购  1开启  2关闭
        /// </summary>        
        public int? InPurchasing
        {
            get;
            set;
        }
        /// <summary>
        /// 下线条件  枚举
        /// </summary>        
        public DistrbutorReferralsEnum? ReferralsCondition
        {
            get;
            set;
        }
        /// <summary>
        /// 申请成为分销商  枚举
        /// </summary>        
        public DistributorApplyForEnum? ApplyFor
        {
            get;
            set;
        }
        /// <summary>
        /// 成为分销商的条件 枚举
        /// </summary>        
        public DistributorConditionEnum? DistributorCondition
        {
            get;
            set;
        }
        /// <summary>
        /// 分销佣金类型  1 百分比  2固定金额
        /// </summary>        
        public int? DistributorCommissionType
        {
            get;
            set;
        }
        /// <summary>
        /// 一级佣金
        /// </summary>        
        public decimal? OneCommission
        {
            get;
            set;
        }
        /// <summary>
        /// 二级佣金
        /// </summary>        
        public decimal? TwoCommission
        {
            get;
            set;
        }
        /// <summary>
        /// 三级佣金
        /// </summary>        
        public decimal? ThreeCommission
        {
            get;
            set;
        }
        /// <summary>
        /// 分销商等级入口  1开启  2关闭
        /// </summary>        
        public int? GradeEntrance
        {
            get;
            set;
        }
        /// <summary>
        /// 分销商等级入口图片
        /// </summary>
        public string GradeEntranceImage { get; set; }
        /// <summary>
        /// 提现方式  枚举 json格式
        /// </summary>        
        public string WithdrawWay
        {
            get;
            set;
        }
        /// <summary>
        /// 最少提现额度
        /// </summary>        
        public decimal? MinimumWithdrawalLimit
        {
            get;
            set;
        }
        /// <summary>
        /// 每日提现上限  -1表示不限制
        /// </summary>        
        public decimal? DailyWithdrawalLimit
        {
            get;
            set;
        }
        /// <summary>
        /// 提现手续费 百分比
        /// </summary>        
        public decimal? WithdrawFee
        {
            get;
            set;
        }
        /// <summary>
        /// 申请协议
        /// </summary>        
        public string ApplicationProtocol
        {
            get;
            set;
        }
        /// <summary>
        /// 用户须知
        /// </summary>        
        public string UserNotes
        {
            get;
            set;
        }
        /// <summary>
        /// 待审核页面背景图片
        /// </summary>        
        public int? BackgroundImage
        {
            get;
            set;
        }
        /// <summary>
        /// 首页背景图片
        /// </summary>        
        public int? IndexImage
        {
            get;
            set;
        }
        /// <summary>
        /// 商户号
        /// </summary>        
        public int TenantId
        {
            get;
            set;
        }
        /// <summary>
        /// 小程序id
        /// </summary>
        public int MallBaseId { get; set; }
        /// <summary>
        /// 创建时间
        /// </summary>        
        public DateTime? CreateDate
        {
            get;
            set;
        }
        /// <summary>
        /// 修改时间
        /// </summary>        
        public DateTime? UpdateDate
        {
            get;
            set;
        }
        /// <summary>
        /// 佣金是否提完   1是  2否
        /// </summary>
        public int? IsCommissionResidue { get; set; }

        /// <summary>
        /// 是否开启和平下线审核   1是  2否
        /// </summary>
        public int? HpReferralsGradeAudit { get; set; }
        /// <summary>
        /// 是否必须提完所有
        /// </summary>
        public int? IsWithdrawAll { get; set; }
        /// <summary>
        /// 是否启用粉象返佣   1是  2否
        /// </summary>
        public int? IsEnableFXGrade { get; set; }
        /// <summary>
        /// 是否启用无上级返佣
        /// </summary>
        public int? IsEnableNoSuperiorFY { get; set; }
    }
}
