﻿using System;
using System.Collections.Generic;
using System.Text;
using Mall.Model.Entity.User;
using Mall.Model.Extend.User;
using System.Linq;
using Mall.Model.Query;

namespace Mall.Repository.User
{
    /// <summary>
    /// 用户积分仓储层
    /// </summary>
    public class RB_Member_IntegralRepository : RepositoryBase<RB_Member_Integral>
    {
        public string MemberTableName { get { return nameof(RB_Member_User); } }
        /// <summary>
        /// 表名称
        /// </summary>
        public string TableName { get { return nameof(RB_Member_Integral); } }
        /// <summary>
        /// 分页列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="dmodel">查询条件</param>
        /// <returns></returns>
        public List<RB_Member_Integral_Extend> GetPageList(int pageIndex, int pageSize, out long rowCount, RB_Member_Integral_Extend dmodel)
        {
            string where = " 1=1 ";
            if (dmodel.TenantId > 0)
            {
                where += $@" and {nameof(RB_Member_Integral.TenantId)}={dmodel.TenantId}";
            }
            if (dmodel.MallBaseId > 0)
            {
                where += $@" and {nameof(RB_Member_Integral.MallBaseId)}={dmodel.MallBaseId}";
            }
            if (dmodel.Id > 0)
            {
                where += $@" and {nameof(RB_Member_Integral.Id)}={dmodel.Id}";
            }
            if (dmodel.Type > 0)
            {
                where += $@" and {nameof(RB_Member_Integral.Type)}={dmodel.Type}";
            }
            if (dmodel.UserId > 0)
            {
                where += $@" and {nameof(RB_Member_Integral.UserId)}={dmodel.UserId}";
            }

            string sql = $@"select * from RB_Member_Integral where {where} order by Id desc";
            return GetPage<RB_Member_Integral_Extend>(pageIndex, pageSize, out rowCount, sql).ToList();
        }

        /// <summary>
        /// 获取列表
        /// </summary>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public List<RB_Member_Integral_Extend> GetList(RB_Member_Integral_Extend dmodel)
        {
            string where = " 1=1 ";
            if (dmodel.TenantId > 0)
            {
                where += $@" and {nameof(RB_Member_Integral.TenantId)}={dmodel.TenantId}";
            }
            if (dmodel.MallBaseId > 0)
            {
                where += $@" and {nameof(RB_Member_Integral.MallBaseId)}={dmodel.MallBaseId}";
            }
            if (dmodel.Id > 0)
            {
                where += $@" and {nameof(RB_Member_Integral.Id)}={dmodel.Id}";
            }
            if (dmodel.Type > 0)
            {
                where += $@" and {nameof(RB_Member_Integral.Type)}={dmodel.Type}";
            }
            if (dmodel.PlatformType != null && (int)dmodel.PlatformType > 0)
            {
                where += $@" and {nameof(RB_Member_Integral.PlatformType)}={dmodel.PlatformType}";
            }
            if (dmodel.UserId > 0)
            {
                where += $@" and {nameof(RB_Member_Integral.UserId)}={dmodel.UserId}";
            }

            string sql = $@"select * from RB_Member_Integral where {where} order by Id desc";
            return Get<RB_Member_Integral_Extend>(sql).ToList();
        }


        /// <summary>
        /// 营销中心-积分记录
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Member_Integral_Extend> GetRechargeRecordPageList(int pageIndex, int pageSize, out long rowCount, RB_Member_Integral_Extend query)
        {
            StringBuilder builder = new StringBuilder();
            builder.Append($" SELECT a.*,b.`Name` as MemberName FROM {TableName} as a LEFT JOIN {MemberTableName} as b on a.UserId = b.Id WHERE 1=1 ");
            if (query != null)
            {
                if (query.Id > 0)
                {
                    builder.Append($" AND a.{nameof(RB_Member_Integral_Extend.Id)}={query.Id}");
                }
                if (query.TenantId > 0)
                {
                    builder.Append($" AND a.{nameof(RB_Member_Integral_Extend.TenantId)}={query.TenantId}");
                }
                if (query.TenantId > 0)
                {
                    builder.Append($" AND a.{nameof(RB_Member_Integral_Extend.MallBaseId)}={query.MallBaseId}");
                }
                if (!string.IsNullOrWhiteSpace(query.MemberName))
                {
                    builder.Append($" AND b.{nameof(RB_Member_Integral_Extend.MemberName)} like '%{query.MemberName}%'");
                }
                if (!string.IsNullOrWhiteSpace(query.StartDate))
                {
                    builder.Append($" AND DATE_FORMAT(a.{nameof(RB_Member_Integral_Extend.CreateDate)},'%Y-%m-%d' )>= DATE_FORMAT('{nameof(RB_Member_Integral_Extend.StartDate)}','%Y-%m-%d' )");
                }
                if (!string.IsNullOrWhiteSpace(query.EndDate))
                {
                    builder.Append($" AND DATE_FORMAT(a.{nameof(RB_Member_Integral_Extend.CreateDate)},'%Y-%m-%d' )<= DATE_FORMAT('{nameof(RB_Member_Integral_Extend.EndDate)}','%Y-%m-%d' )");
                }
            }
            return GetPage<RB_Member_Integral_Extend>(pageIndex, pageSize, out rowCount, builder.ToString()).ToList();
        }
        /// <summary>
        /// 数据统计-积分收支
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<Integral_Query> GetIntegraStatisticslList(int pageIndex, int pageSize, out long rowCount, Integral_Query query)
        {
            StringBuilder builder = new StringBuilder();
            if (query != null)
            {
                if (query.TenantId > 0)
                {
                    builder.Append($" AND {nameof(RB_Member_Integral_Extend.TenantId)}={query.TenantId}");
                }
                if (query.TenantId > 0)
                {
                    builder.Append($" AND {nameof(RB_Member_Integral_Extend.MallBaseId)}={query.MallBaseId}");
                }
                if (query.PlatformType > 0)
                {
                    builder.Append($" AND {nameof(RB_Member_Integral_Extend.PlatformType)}={query.PlatformType}");
                }
                if (!string.IsNullOrWhiteSpace(query.StartDate))
                {
                    builder.Append($" AND DATE_FORMAT({nameof(RB_Member_Integral_Extend.CreateDate)},'%Y-%m-%d' )>= DATE_FORMAT('{nameof(RB_Member_Integral_Extend.StartDate)}','%Y-%m-%d' )");
                }
                if (!string.IsNullOrWhiteSpace(query.EndDate))
                {
                    builder.Append($" AND DATE_FORMAT({nameof(RB_Member_Integral_Extend.CreateDate)},'%Y-%m-%d' )<= DATE_FORMAT('{nameof(RB_Member_Integral_Extend.EndDate)}','%Y-%m-%d' )");
                }
            }
            string sql = @$" SELECT CreateDate,SUM(Income) as Income, SUM(Expend) as Expend from (
select DATE_FORMAT(CreateDate, '%Y-%m-%d') as CreateDate, Integral as Income, 0 as Expend from rb_member_integral where  Type = 1 {builder.ToString()}
union all
select DATE_FORMAT(CreateDate, '%Y-%m-%d') as CreateDate, 0 as Income, Integral as Expend from rb_member_integral where Type = 2 {builder.ToString()}
) as t GROUP BY CreateDate ";
            return GetPage<Integral_Query>(pageIndex, pageSize, out rowCount, sql).ToList();
        }
    }
}
