﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Microsoft.AspNetCore.Cors;
using Microsoft.AspNetCore.Mvc;

namespace Mall.WebApi.Controllers
{
    [Route("api/[controller]/[action]")]
    [ApiExceptionFilter]
    [ApiFilter]
    [EnableCors("AllowCors")]
    public class PApiController : ControllerBase
    {
        /// <summary>
        /// 整理前端传递的post参数
        /// </summary>
        /// <param name="requestMsg"></param>
        /// <returns></returns>
        public RequestParm GetRequestParm()
        {
            #region 读取post参数
            //Request.EnableBuffering();//重置读取
            //Request.Body.Seek(0, 0);
            //Request.Body.Position = 0;
            //Stream stream = Request.Body;
            //Encoding encoding = Encoding.UTF8;
            //byte[] buffer = new byte[Request.ContentLength.Value];
            //stream.ReadAsync(buffer, 0, buffer.Length);
            //var requestMsg = Encoding.UTF8.GetString(buffer);
            //var requestParm = JsonConvert.DeserializeObject<RequestParm>(requestMsg);

            var requestMsg = Request.HttpContext.Items[GlobalKey.UserPostInfo];
            LogHelper.WriteInfo(requestMsg.ToString());
            var requestParm = JsonConvert.DeserializeObject<RequestParm>(requestMsg.ToString());
            var UObj = Request.HttpContext.Items[GlobalKey.TokenUserInfo];
            if (UObj != null)
            {
                JObject parms = JObject.Parse(UObj.ToString());
                requestParm.uid = parms.GetStringValue("uid");
            }
            #endregion
            //根据token 获取uid

            return requestParm;
        }
    }
}