﻿using VT.FW.DB;
using Mall.Common.Enum.Goods;
using Mall.Common.Enum.User;
using System;
using System.Collections.Generic;
using System.Text;

namespace Mall.Model.Entity.Product
{
    /// <summary>
    /// 商品订单明细表实体
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_Goods_OrderDetailFreeShipping
    {

        /// <summary>
        /// Id
        /// </summary>        
        public int Id
        {
            get;
            set;
        }

        /// <summary>
        /// 订单商品id
        /// </summary>        
        public int? OrderDetailId
        {
            get;
            set;
        }

        /// <summary>
        /// 单品满件包邮
        /// </summary>        
        public int? FullNumPinkage
        {
            get;
            set;
        }
        /// <summary>
        /// 单品满额包邮
        /// </summary>        
        public decimal? FullMoneyPinkage
        {
            get;
            set;
        }

        /// <summary>
        /// 包邮规则名称
        /// </summary>
        public string Name { get; set; }

        public int Status { get; set; }

        /// <summary>
        /// 包邮规则对应的分类
        /// </summary>
        public int? Category { get; set; }
        /// <summary>
        /// 商户号
        /// </summary>        
        public int TenantId
        {
            get;
            set;
        }
        /// <summary>
        /// 小程序id
        /// </summary>        
        public int MallBaseId
        {
            get;
            set;
        }
        /// <summary>
        /// CreateDate
        /// </summary>        
        public DateTime? CreateDate
        {
            get;
            set;
        }

    }
}
