﻿using Mall.Model.Entity.Reserve;
using Mall.Model.Extend.Reserve;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Mall.Repository.Reserve
{
    public class RB_Reserve_ServicePersonalRepository : BaseRepository<RB_Reserve_ServicePersonal>
    {

        /// <summary>
        /// 表名称
        /// </summary>
        public string TableName { get { return nameof(RB_Reserve_ServicePersonal); } }



        /// <summary>
        ///服务人员信息列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Reserve_ServicePersonal_Extend> GetServicePersonalPageList(int pageIndex, int pageSize, out long rowCount, RB_Reserve_ServicePersonal_Extend query)
        {
            StringBuilder builder = new StringBuilder();
            builder.Append($" SELECT a.*,b.`Name` as  StoreName FROM {TableName} as A  LEFT JOIN rb_stores as b on a.StoreId=b.Id WHERE  a.{nameof(RB_Reserve_ServicePersonal_Extend.Status)}=0");
            if (query != null)
            {
                if (query.TenantId > 0)
                {
                    builder.Append($" AND a.{nameof(RB_Reserve_ServicePersonal_Extend.TenantId)}={query.TenantId}");
                }
                if (query.TenantId > 0)
                {
                    builder.Append($" AND a.{nameof(RB_Reserve_ServicePersonal_Extend.MallBaseId)}={query.MallBaseId}");
                }
                if (query.ServiceStatus > 0)
                {
                    builder.Append($" AND a.{nameof(RB_Reserve_ServicePersonal_Extend.ServiceStatus)}={query.ServiceStatus}");
                }
                if (query.StoreId > 0)
                {
                    builder.Append($" AND a.{nameof(RB_Reserve_ServicePersonal_Extend.StoreId)}={query.StoreId}");
                }
                if (!string.IsNullOrWhiteSpace(query.Name))
                {
                    builder.Append($" AND a.{nameof(RB_Reserve_ServicePersonal_Extend.Name)} like '%{query.Name}%'");
                }
            }
            builder.Append($"  order by  a.{nameof(RB_Reserve_ServicePersonal_Extend.ID)} desc");
            return GetPage<RB_Reserve_ServicePersonal_Extend>(pageIndex, pageSize, out rowCount, builder.ToString()).ToList();
        }






        /// <summary>
        ///小程序端服务人员信息列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Reserve_ServicePersonal_Extend> GetMinServicePersonalList(int pageIndex, int pageSize, out long rowCount, RB_Reserve_ServicePersonal_Extend query)
        {
            StringBuilder builder = new StringBuilder();
            builder.Append(@$" SELECT a.*,b.CommentNum FROM {TableName} as A  
LEFT JOIN (SELECT ServicePersonalId,COUNT(*) as CommentNum  from rb_goods_comment where Is_Show=1 and Status=0 GROUP by ServicePersonalId) as b on a.ID=b.ServicePersonalId  WHERE  a.{nameof(RB_Reserve_ServicePersonal_Extend.Status)}=0");
            if (query != null)
            {
                if (query.TenantId > 0)
                {
                    builder.Append($" AND a.{nameof(RB_Reserve_ServicePersonal_Extend.TenantId)}={query.TenantId}");
                }
                if (query.TenantId > 0)
                {
                    builder.Append($" AND a.{nameof(RB_Reserve_ServicePersonal_Extend.MallBaseId)}={query.MallBaseId}");
                }
                if (query.ServiceStatus > 0)
                {
                    builder.Append($" AND a.{nameof(RB_Reserve_ServicePersonal_Extend.ServiceStatus)}={query.ServiceStatus}");
                }
                if (query.StoreId > 0)
                {
                    builder.Append($" AND a.{nameof(RB_Reserve_ServicePersonal_Extend.StoreId)}={query.StoreId}");
                }
                if (!string.IsNullOrWhiteSpace(query.Name))
                {
                    builder.Append($" AND a.{nameof(RB_Reserve_ServicePersonal_Extend.Name)} like '%{query.Name}%'");
                }
            }
            builder.Append($"  order by  a.{nameof(RB_Reserve_ServicePersonal_Extend.ID)} desc");
            return GetPage<RB_Reserve_ServicePersonal_Extend>(pageIndex, pageSize, out rowCount, builder.ToString()).ToList();
        }




        /// <summary>
        ///小程序端服务人员信息列表  待完善
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Reserve_ServicePersonal_Extend> GetServicePersonalDetailList(int pageIndex, int pageSize, out long rowCount, RB_Reserve_ServicePersonal_Extend query)
        {
            StringBuilder builder = new StringBuilder();
            builder.Append(@$" SELECT a.*,b.CommentNum FROM {TableName} as A  
LEFT JOIN (SELECT ServicePersonalId,COUNT(*) as CommentNum  from rb_goods_comment where Is_Show=1 and Status=0 GROUP by ServicePersonalId) as b on a.ID=b.ServicePersonalId  WHERE  a.{nameof(RB_Reserve_ServicePersonal_Extend.Status)}=0");
            if (query != null)
            {
                if (query.TenantId > 0)
                {
                    builder.Append($" AND a.{nameof(RB_Reserve_ServicePersonal_Extend.TenantId)}={query.TenantId}");
                }
                if (query.TenantId > 0)
                {
                    builder.Append($" AND a.{nameof(RB_Reserve_ServicePersonal_Extend.MallBaseId)}={query.MallBaseId}");
                }
                if (query.ServiceStatus > 0)
                {
                    builder.Append($" AND a.{nameof(RB_Reserve_ServicePersonal_Extend.ServiceStatus)}={query.ServiceStatus}");
                }
                if (query.StoreId > 0)
                {
                    builder.Append($" AND a.{nameof(RB_Reserve_ServicePersonal_Extend.StoreId)}={query.StoreId}");
                }
                if (!string.IsNullOrWhiteSpace(query.Name))
                {
                    builder.Append($" AND a.{nameof(RB_Reserve_ServicePersonal_Extend.Name)} like '%{query.Name}%'");
                }
            }
            builder.Append($"  order by  a.{nameof(RB_Reserve_ServicePersonal_Extend.ID)} desc");
            return GetPage<RB_Reserve_ServicePersonal_Extend>(pageIndex, pageSize, out rowCount, builder.ToString()).ToList();
        }






        /// <summary>
        /// 服务人员信息排名
        /// </summary>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Reserve_ServicePersonal_Extend> GetServicePersonalRank(RB_Reserve_ServicePersonal_Extend query, bool IsSelectDel = false)
        {
            StringBuilder builder = new StringBuilder();

            if (query != null)
            {
                if (query.ID > 0)
                {
                    builder.Append($" AND  a.ServicepersonalId={query.ID}");
                }

                if (query.TenantId > 0)
                {
                    builder.Append($" AND b.{nameof(RB_Reserve_ServicePersonal_Extend.TenantId)}={query.TenantId}");
                }
                if (query.TenantId > 0)
                {
                    builder.Append($" AND b.{nameof(RB_Reserve_ServicePersonal_Extend.MallBaseId)}={query.MallBaseId}");
                }

            }
            string sql = $@"SELECT t.ServicepersonalId,t.orderNum,
CASE 
WHEN @prevRank = t.orderNum THEN @curRank 
WHEN @prevRank := t.orderNum THEN @curRank := @curRank + 1
END AS Rank
FROM (SELECT a.ServicepersonalId,COUNT(*) orderNum from rb_goods_orderdetail  as a LEFT JOIN rb_goods_order as b 
on a.OrderId=b.OrderId where b.OrderStatus in(2,3,4,5,6)  and  DATE_FORMAT(b.PaymentTime,'%Y-%m-%d' )>=DATE_FORMAT('{System.DateTime.Now.AddMonths(-1)}','%Y-%m-%d' )  
and  DATE_FORMAT(b.PaymentTime,'%Y-%m-%d' )<= DATE_FORMAT('{System.DateTime.Now}','%Y-%m-%d' )  {builder.ToString()} GROUP BY a.ServicepersonalId ) as t, 
(SELECT @curRank :=0, @prevRank := NULL) r
ORDER BY t.orderNum desc ";
            return Get<RB_Reserve_ServicePersonal_Extend>(sql).ToList();
        }


        /// <summary>
        /// 服务人员信息列表
        /// </summary>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Reserve_ServicePersonal_Extend> GetServicePersonalList(RB_Reserve_ServicePersonal_Extend query, bool IsSelectDel = false)
        {
            StringBuilder builder = new StringBuilder();
            if (IsSelectDel)
            {
                builder.Append($" SELECT a.*,b.`Name` as  StoreName,b.Address as StoreAddress FROM {TableName} as A  LEFT JOIN rb_stores as b on a.StoreId=b.Id WHERE 1=1");
            }
            else
            {
                builder.Append($" SELECT a.*,b.`Name` as  StoreName,b.Address as StoreAddress FROM {TableName} as A  LEFT JOIN rb_stores as b on a.StoreId=b.Id WHERE  a.{nameof(RB_Reserve_ServicePersonal_Extend.Status)}=0");
            }

            if (query != null)
            {
                if (query.TenantId > 0)
                {
                    builder.Append($" AND a.{nameof(RB_Reserve_ServicePersonal_Extend.TenantId)}={query.TenantId}");
                }
                if (query.TenantId > 0)
                {
                    builder.Append($" AND a.{nameof(RB_Reserve_ServicePersonal_Extend.MallBaseId)}={query.MallBaseId}");
                }
                if (query.ServiceStatus > 0)
                {
                    builder.Append($" AND a.{nameof(RB_Reserve_ServicePersonal_Extend.ServiceStatus)}={query.ServiceStatus}");
                }
                if (query.StoreId > 0)
                {
                    builder.Append($" AND a.{nameof(RB_Reserve_ServicePersonal_Extend.StoreId)}={query.StoreId}");
                }
                if (query.ID > 0)
                {
                    builder.Append($" AND a.{nameof(RB_Reserve_ServicePersonal_Extend.ID)}={query.ID}");
                }
                if (!string.IsNullOrWhiteSpace(query.Name))
                {
                    builder.Append($" AND a.{nameof(RB_Reserve_ServicePersonal_Extend.Name)} like '%{query.Name}%'");
                }
            }
            builder.Append($"  order by  a.{nameof(RB_Reserve_ServicePersonal_Extend.ID)} desc");
            return Get<RB_Reserve_ServicePersonal_Extend>(builder.ToString()).ToList();
        }







        /// <summary>
        /// 当天排班服务人员列表
        /// </summary>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Reserve_ServicePersonal_Extend> GetKanBanServicePersonalList(RB_Reserve_ServicePersonal_Extend query)
        {
            StringBuilder builder = new StringBuilder();

            builder.Append($" SELECT a.*,b.Date FROM rb_reserve_servicepersonal as A  LEFT JOIN rb_reserve_servicetargetdate as b on a.ID=b.ServiceId  WHERE  a.{nameof(RB_Reserve_ServicePersonal_Extend.Status)}=0");
            if (query != null)
            {
                if (query.TenantId > 0)
                {
                    builder.Append($" AND a.{nameof(RB_Reserve_ServicePersonal_Extend.TenantId)}={query.TenantId}");
                }
                if (query.TenantId > 0)
                {
                    builder.Append($" AND a.{nameof(RB_Reserve_ServicePersonal_Extend.MallBaseId)}={query.MallBaseId}");
                }
                if (query.ServiceStatus > 0)
                {
                    builder.Append($" AND a.{nameof(RB_Reserve_ServicePersonal_Extend.ServiceStatus)}={query.ServiceStatus}");
                }
                if (query.StoreId > 0)
                {
                    builder.Append($" AND a.{nameof(RB_Reserve_ServicePersonal_Extend.StoreId)}={query.StoreId}");
                }
                if (!string.IsNullOrWhiteSpace(query.Name))
                {
                    builder.Append($" AND a.{nameof(RB_Reserve_ServicePersonal_Extend.Name)} like '%{query.Name}%'");
                }

                if (!string.IsNullOrWhiteSpace(query.WorkDate))
                {
                    builder.Append($"  and  DATE_FORMAT(b.Date,'%Y-%m-%d' )=DATE_FORMAT('{query.WorkDate}','%Y-%m-%d'");
                }
            }
            builder.Append($"  order by  a.{nameof(RB_Reserve_ServicePersonal_Extend.ID)} desc");
            return Get<RB_Reserve_ServicePersonal_Extend>(builder.ToString()).ToList();
        }




        /// <summary>
        /// 根据门店、商品编号和商品分类编号获取服务人员列表
        /// </summary>
        /// <param name="storeId"></param>
        /// <param name="productId"></param>
        /// <param name="categoryIds"></param>
        /// <returns></returns>
        public List<RB_Reserve_ServicePersonal_Extend> GetServicePersonalListExtRepository(int storeId, int productId, string categoryIds)
        {
            StringBuilder builder = new StringBuilder();
            builder.AppendFormat(@"
SELECT DISTINCT A.* 
FROM  RB_Reserve_ServicePersonal AS A  
INNER JOIN 
(
  SELECT * FROM rb_reserve_servicepersonalproduct WHERE ServiceType=3 AND `Status`=0
  UNION 
  SELECT * FROM rb_reserve_servicepersonalproduct WHERE ServiceType=2 AND `Status`=0 AND ProductId={0}
  UNION 
  SELECT * FROM rb_reserve_servicepersonalproduct WHERE ServiceType=1 AND `Status`=0 AND ProductId IN({1})
) AS B ON A.ID=B.ServiceId
WHERE A.Status=0  AND A.StoreId={2}
", productId, categoryIds, storeId);
            return Get<RB_Reserve_ServicePersonal_Extend>(builder.ToString()).ToList();
        }
    }
}
