﻿using Mall.CacheManager.Base;
using Mall.CacheManager.DataStatistic;
using Mall.Model.Extend.User;
using Newtonsoft.Json;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Mall.CacheManager.ByteDance
{
    public class ByteDanceRedis
    {

        static RedisHelper redis = new RedisHelper(DataConstant.REDIS_DB2);
          /// <summary>
          /// 获取微信用的formID
          /// </summary>
          /// <param name="uid"></param>
          /// <returns></returns>
        public static List<ByteDanceCustomer> GetByteDanceList(int customerId, string FormId)
        {
            string cacheKey = CacheKey.UserModuleCacheKeyConfig.ByteDanceFormId + customerId + "_" + FormId;
            List<ByteDanceCustomer> airInfo = new List<ByteDanceCustomer>();
            try
            {
                var dic = redis.StringGet(cacheKey);
                foreach (var item in dic)
                {
                    var model = JsonConvert.DeserializeObject<List<ByteDanceCustomer>>(item.ToString());
                    airInfo.AddRange(model);
                }
            }
            catch (Exception ex)
            {
                Common.Plugin.LogHelper.Write(ex, "GetByteDanceList");
            }
            return airInfo;
        }

        /// <summary>
        /// 设置缓存
        /// </summary>
        /// <param name="airList"></param>
        public static void SetDyteDanceInfo(List<ByteDanceCustomer> airList)
        {
            string cacheKey = CacheKey.UserModuleCacheKeyConfig.ByteDanceFormId + airList.FirstOrDefault().UserID + "_" + airList.FirstOrDefault().FormId;
            TimeSpan ts = GetExpirTime(7 * 60 * 60 * 24 - 60 * 1);
            redis.StringSet(cacheKey, JsonConvert.SerializeObject(airList), ts);
        }

        /// <summary>
        /// 获取缓存时长
        /// </summary>
        /// <param name="JwtExpirTime"></param>
        /// <returns></returns>
        private static TimeSpan GetExpirTime(int JwtExpirTime)
        {
            DateTime dt = DateTime.Now;
            DateTime dt2 = DateTime.Now;
            TimeSpan ts = dt.AddSeconds(JwtExpirTime) - dt2;
            return ts;
        }


        /// <summary>
        /// 设置缓存
        /// </summary>
        /// <param name="airList"></param>
        public static void RemoveCacheKey(string CustomerID, string FormId, ByteDanceCustomer model)
        {
            string cacheKey = CacheKey.UserModuleCacheKeyConfig.ByteDanceFormId + CustomerID + "_" + FormId;
            redis.ListRemove(cacheKey, model);
        }
    }
}
