﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Mall.Common.API;
using Mall.Common.Plugin;
using Mall.Model.Extend.MarketingCenter;
using Mall.Module.MarketingCenter;
using Mall.WebApi.Filter;
using Microsoft.AspNetCore.Cors;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Newtonsoft.Json;
using Newtonsoft.Json.Linq;

namespace Mall.WebApi.Controllers.MarketingCenter
{
    [Route("api/[controller]/[action]")]
    [ApiExceptionFilter]
    [ApiController]
    [EnableCors("AllowCors")]
    public class ShareController : BaseController
    {
        /// <summary>
        /// 分享处理类对象
        /// </summary>
        private readonly ShareModule shareModule = new ShareModule();

        /// <summary>
        /// 获取分享分类分页列表
        /// </summary>
        /// <returns></returns>
        public ApiResult GetShareCategoryPageList()
        {
            var parms = RequestParm;
            ResultPageModel pagelist = JsonConvert.DeserializeObject<ResultPageModel>(RequestParm.msg.ToString());
            var query = JsonConvert.DeserializeObject<RB_Share_Category_Extend>(RequestParm.msg.ToString());
            query.TenantId = UserInfo.TenantId;
            query.MallBaseId = parms.MallBaseId;
            var list = shareModule.GetShareCategoryPageListModule(pagelist.pageIndex, pagelist.pageSize, out long count, query);
            pagelist.count = Convert.ToInt32(count);
            pagelist.pageData = list;
            return ApiResult.Success("", pagelist);
        }

        /// <summary>
        /// 获取分享分类列表
        /// </summary>
        /// <returns></returns>
        public ApiResult GetShareCategoryList()
        {
            var query = JsonConvert.DeserializeObject<RB_Share_Category_Extend>(RequestParm.msg.ToString());
            query.TenantId = UserInfo.TenantId;
            query.MallBaseId = RequestParm.MallBaseId;
            var list = shareModule.GetShareCategoryListModule(query);
            return ApiResult.Success("", list);
        }

        /// <summary>
        /// 新增修改分享分类
        /// </summary>
        /// <returns></returns>
        public ApiResult SetShareCategory()
        {
            var extModel = JsonConvert.DeserializeObject<RB_Share_Category_Extend>(RequestParm.msg.ToString());
            extModel.TenantId = UserInfo.TenantId;
            extModel.MallBaseId = RequestParm.MallBaseId;
            extModel.CreateDate = DateTime.Now;
            extModel.UpdateDate = DateTime.Now;
            bool flag = shareModule.SetShareCategoryModule(extModel);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }

        /// <summary>
        /// 批量修改排序
        /// </summary>
        /// <returns></returns>
        public ApiResult SetShareCategorySortList()
        {
            var list = JsonConvert.DeserializeObject<List<RB_Share_Category_Extend>>(RequestParm.msg.ToString());
            bool flag = shareModule.SetShareCategorySortListModule(list);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }

        /// <summary>
        /// 删除分享分类
        /// </summary>
        /// <returns></returns>
        public ApiResult RemoveShareCategory()
        {
            JObject parm = JObject.Parse(RequestParm.msg.ToString());
            int Id = parm.GetInt("Id", 0);
            bool flag = shareModule.RemoveShareCategoryModule(Id);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }

        /// <summary>
        /// 根据编号获取分享分类
        /// </summary>
        /// <returns></returns>
        public ApiResult GetShareCategory()
        {
            JObject parm = JObject.Parse(RequestParm.msg.ToString());
            int Id = parm.GetInt("Id", 0);
            var extModel = shareModule.GetShareCategoryModule(Id);
            return ApiResult.Success(data: extModel);
        }


        /// <summary>
        /// 获取分享详情分页列表
        /// </summary>
        /// <returns></returns>
        public ApiResult GetShareFriendPageList()
        {
            var parms = RequestParm;
            ResultPageModel pagelist = JsonConvert.DeserializeObject<ResultPageModel>(RequestParm.msg.ToString());
            var query = JsonConvert.DeserializeObject<RB_Share_Friend_Extend>(RequestParm.msg.ToString());
            query.TenantId = UserInfo.TenantId;
            query.MallBaseId = parms.MallBaseId;
            var list = shareModule.GetShareFriendPageListModule(pagelist.pageIndex, pagelist.pageSize, out long count, query);
            pagelist.count = Convert.ToInt32(count);
            pagelist.pageData = list;
            return ApiResult.Success("", pagelist);
        }

        /// <summary>
        /// 获取分享详情列表
        /// </summary>
        /// <returns></returns>
        public ApiResult GetShareFriendList()
        {
            var query = JsonConvert.DeserializeObject<RB_Share_Friend_Extend>(RequestParm.msg.ToString());
            query.TenantId = UserInfo.TenantId;
            query.MallBaseId = RequestParm.MallBaseId;
            var list = shareModule.GetShareFriendListModule(query);
            return ApiResult.Success("", list);
        }

        /// <summary>
        /// 新增修改分享详情
        /// </summary>
        /// <returns></returns>
        public ApiResult SetShareFriend()
        {
            JObject parm = JObject.Parse(RequestParm.msg.ToString());
            var extModel = JsonConvert.DeserializeObject<RB_Share_Friend_Extend>(RequestParm.msg.ToString());
            extModel.TenantId = UserInfo.TenantId;
            extModel.MallBaseId = RequestParm.MallBaseId;
            extModel.CreateDate = DateTime.Now;
            extModel.UpdateDate = DateTime.Now;
            extModel.IsUse = 1;
            var imgStr = parm.GetStringValue("ImgList");
            if (!string.IsNullOrWhiteSpace(imgStr))
            {
                extModel.MaterialImg = imgStr;
            }
            bool flag = shareModule.SetShareFriendModule(extModel);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }

        /// <summary>
        /// 根据编号删除分享详情
        /// </summary>
        /// <returns></returns>
        public ApiResult RemoveShareFriend()
        {
            JObject parm = JObject.Parse(RequestParm.msg.ToString());
            int Id = parm.GetInt("Id", 0);
            bool flag = shareModule.RemoveShareFriendModule(Id);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }

        /// <summary>
        /// 根据编号获取分享详情实体
        /// </summary>
        /// <returns></returns>
        public ApiResult GetShareFriend()
        {
            JObject parm = JObject.Parse(RequestParm.msg.ToString());
            int Id = parm.GetInt("Id", 0);
            var extModel = shareModule.GetShareFriendModule(Id);
            return ApiResult.Success(data: extModel);
        }

        /// <summary>
        /// 更新置顶状态
        /// </summary>
        /// <returns></returns>
        public ApiResult SetShareFriendIsTop()
        {
            JObject parm = JObject.Parse(RequestParm.msg.ToString());
            int Id = parm.GetInt("Id", 0);
            int IsTop = parm.GetInt("IsTop", 0);
            bool flag = shareModule.SetShareFriendIsTopModule(Id, IsTop);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }


        /// <summary>
        /// 更新是否启用
        /// </summary>
        /// <returns></returns>
        public ApiResult SetShareFriendIsUse()
        {
            JObject parm = JObject.Parse(RequestParm.msg.ToString());
            int Id = parm.GetInt("Id", 0);
            int IsUse = parm.GetInt("IsUse", 0);
            bool flag = shareModule.SetShareFriendIsUseModule(Id, IsUse);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }

        /// <summary>
        /// 更新排序
        /// </summary>
        /// <returns></returns>
        public ApiResult SetShareFriendSortNum()
        {
            JObject parm = JObject.Parse(RequestParm.msg.ToString());
            int Id = parm.GetInt("Id", 0);
            int SortNum = parm.GetInt("SortNum", 0);
            bool flag = shareModule.SetShareFriendSortNumModule(Id, SortNum);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }

        /// <summary>
        /// 更新文案
        /// </summary>
        /// <returns></returns>
        public ApiResult SetShareFriendMaterialInfo()
        {
            JObject parm = JObject.Parse(RequestParm.msg.ToString());
            int Id = parm.GetInt("Id", 0);
            var MaterialInfo = parm.GetStringValue("MaterialInfo");
            bool flag = shareModule.SetShareFriendMaterialInfoModule(Id, MaterialInfo);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }

    }
}