﻿using VT.FW.DB;
using Mall.Common.Enum.Goods;
using Mall.Common.Enum.User;
using System;
using System.Collections.Generic;
using System.Text;

namespace Mall.Model.Entity.Product
{
    /// <summary>
    /// 商品订单明细表实体
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_Goods_OrderDetail
    {

        /// <summary>
        /// Id
        /// </summary>        
        public int Id
        {
            get;
            set;
        }
        /// <summary>
        /// 订单id
        /// </summary>        
        public int? OrderId
        {
            get;
            set;
        }
        /// <summary>
        /// 商品id
        /// </summary>        
        public int? GoodsId
        {
            get;
            set;
        }
        /// <summary>
        /// 订单类型  枚举
        /// </summary>        
        public OrderTypeEnum? OrderType
        {
            get;
            set;
        }
        /// <summary>
        /// 商品名称
        /// </summary>        
        public string GoodsName
        {
            get;
            set;
        }
        /// <summary>
        /// 封面图
        /// </summary>        
        public string CoverImage
        {
            get;
            set;
        }
        /// <summary>
        /// 规格
        /// </summary>        
        public string Specification
        {
            get;
            set;
        }
        /// <summary>
        /// 规格key
        /// </summary>
        public string SpecificationSort { get; set; }
        /// <summary>
        /// 货号
        /// </summary>        
        public string ProductCode
        {
            get;
            set;
        }
        /// <summary>
        /// 单价
        /// </summary>        
        public decimal? Unit_Price
        {
            get;
            set;
        }
        /// <summary>
        /// 数量
        /// </summary>        
        public int? Number
        {
            get;
            set;
        }
        /// <summary>
        /// 原价 (=单价*数量)
        /// </summary>        
        public decimal? Original_Price
        {
            get;
            set;
        }
        /// <summary>
        /// 最终价格(不包含运费)
        /// </summary>        
        public decimal? Final_Price
        {
            get;
            set;
        }
        /// <summary>
        /// 折扣
        /// </summary>        
        public decimal? DiscountRate
        {
            get;
            set;
        }
        /// <summary>
        /// 是否商品单独会员价购买  1是  2否
        /// </summary>        
        public int? IsMemberPrice
        {
            get;
            set;
        }
        /// <summary>
        /// 商户号
        /// </summary>        
        public int TenantId
        {
            get;
            set;
        }
        /// <summary>
        /// 小程序id
        /// </summary>        
        public int MallBaseId
        {
            get;
            set;
        }
        /// <summary>
        /// CreateDate
        /// </summary>        
        public DateTime? CreateDate
        {
            get;
            set;
        }
        /// <summary>
        /// UpdateDate
        /// </summary>        
        public DateTime? UpdateDate
        {
            get;
            set;
        }
        /// <summary>
        /// 成本价
        /// </summary>
        public decimal? CostMoney { get; set; }

        /// <summary>
        /// 已付成本价（已付商品成本+已付运费成本）
        /// </summary>
        public decimal? PaidCostMoney { get; set; }

        /// <summary>
        /// 是否评论   1是  2否
        /// </summary>
        public int? IsComment { get; set; }
        /// <summary>
        /// 运费
        /// </summary>
        public decimal? FreightMoney { get; set; }
        /// <summary>
        /// 使用积分数量
        /// </summary>
        public int? IntegralNumber { get; set; }
        /// <summary>
        /// 积分抵扣金额
        /// </summary>
        public decimal? IntegralMoney { get; set; }
        /// <summary>
        /// 优惠券使用金额
        /// </summary>
        public decimal? CouponMoney { get; set; }


        /// <summary>
        /// 运费成本
        /// </summary>
        public decimal? FreightCostMoney { get; set; }

        /// <summary>
        /// 供应商id
        /// </summary>
        public int SupplierId { get; set; }


        /// <summary>
        /// 成本单据ID
        /// </summary>
        public int CostFinanceId { get; set; }

        /// <summary>
        /// 运费成本单据ID
        /// </summary>
        public int FreightFinanceId { get; set; }

        /// <summary>
        /// 积分赠送
        /// </summary>
        public int? IntegralGoodsPresent { get; set; }

        /// <summary>
        /// 赠送粉象等级
        /// </summary>
        public int? PresentFXGrade { get; set; }
        /// <summary>
        /// 赠送粉象等级期限（月）
        /// </summary>
        public int? PresentFXMonth { get; set; }

        /// <summary>
        /// 分类包邮规则备注
        /// </summary>
        public string FreeShippingRemarks { get; set; }
        /// <summary>
        /// 微店成本价格
        /// </summary>
        public decimal? SmallShopsCostPrice { get; set; }
        /// <summary>
        /// 主播佣金
        /// </summary>
        public decimal? LiveCommission { get; set; }
        /// <summary>
        /// 主播佣金生成的财务单据   逗号分隔
        /// </summary>
        public string LiveFinanceIds { get; set; }
        /// <summary>
        /// 主播数量
        /// </summary>
        public int? LivePeopleNum { get; set; }
        /// <summary>
        /// 其他应收金额
        /// </summary>
        public decimal? YSMoney { get; set; }
        /// <summary>
        /// 其他实收金额
        /// </summary>
        public decimal? RealMoney { get; set; }
        /// <summary>
        /// 其他应付金额
        /// </summary>
        public decimal? YFMoney { get; set; }
        /// <summary>
        /// 其他实付金额
        /// </summary>
        public decimal? PayMoney { get; set; }

        /// <summary>
        /// 公司id
        /// </summary>
        public int CompanyId { get; set; }


        /// <summary>
        /// 公司毛利比例
        /// </summary>
        public decimal CompanyProfitRate { get; set; }
    }
}
