﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Mall.Model.Entity.User;
using Mall.Model.Extend.User;

namespace Mall.Repository.User
{
    /// <summary>
    /// 储值卡合并/赠送仓储层
    /// </summary>
    public class RB_Member_DepositBalanceRepository : BaseRepository<RB_Member_DepositBalance>
    {
        /// <summary>
        /// 表名称
        /// </summary>
        public string TableName { get { return nameof(RB_Member_DepositBalance); } }
        /// <summary>
        /// 储值卡余额信息列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Member_DepositBalance_Extend> GetDepositBalancePageList(int pageIndex, int pageSize, out long rowCount, RB_Member_DepositBalance_Extend query)
        {
            StringBuilder builder = new StringBuilder();
            builder.Append($" SELECT * FROM {TableName} WHERE  {nameof(RB_Member_DepositBalance_Extend.Status)}=0");
            if (query != null)
            {
                if (query.TenantId > 0)
                {
                    builder.Append($" AND {nameof(RB_Member_DepositBalance_Extend.TenantId)}={query.TenantId}");
                }
                if (query.MergeType > 0)
                {
                    builder.Append($" AND {nameof(RB_Member_DepositBalance_Extend.MergeType)}={query.MergeType}");
                }
                if (query.MallBaseId > 0)
                {
                    builder.Append($" AND {nameof(RB_Member_DepositBalance_Extend.MallBaseId)}={query.MallBaseId}");
                }
                if (!string.IsNullOrWhiteSpace(query.Name))
                {
                    builder.Append($" AND {nameof(RB_Member_DepositBalance_Extend.Name)} like '%{query.Name}%'");
                }
                if (query.Type > 0)
                {
                    builder.Append($" AND {nameof(RB_Member_DepositBalance_Extend.Type)}={query.Type}");
                }
                if (query.OldDepositBuyId > 0)
                {
                    builder.Append($" AND {nameof(RB_Member_DepositBalance_Extend.OldDepositBuyId)}={query.OldDepositBuyId}");
                }
                if (query.UserId > 0)
                {
                    builder.Append($" AND {nameof(RB_Member_DepositBalance_Extend.UserId)}={query.UserId}");
                }
            }
            return GetPage<RB_Member_DepositBalance_Extend>(pageIndex, pageSize, out rowCount, builder.ToString()).ToList();
        }


        /// <summary>
        /// 储值卡余额信息列表
        /// </summary>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Member_DepositBalance_Extend> GetDepositBalanceList(RB_Member_DepositBalance_Extend query)
        {
            StringBuilder builder = new StringBuilder();
            builder.Append($" SELECT * FROM {TableName} WHERE {nameof(RB_Member_DepositBalance_Extend.Status)}=0 ");
            if (query != null)
            {
                if (query.TenantId > 0)
                {
                    builder.Append($" AND {nameof(RB_Member_DepositBalance_Extend.TenantId)}={query.TenantId}");
                }
                if (query.Id > 0)
                {
                    builder.Append($" AND {nameof(RB_Member_DepositBalance_Extend.Id)}={query.Id}");
                }
                if (query.MergeType > 0)
                {
                    builder.Append($" AND {nameof(RB_Member_DepositBalance_Extend.MergeType)}={query.MergeType}");
                }
                if (query.Type > 0)
                {
                    builder.Append($" AND {nameof(RB_Member_DepositBalance_Extend.Type)}={(int)query.Type}");
                }
                if (query.MallBaseId > 0)
                {
                    builder.Append($" AND {nameof(RB_Member_DepositBalance_Extend.MallBaseId)}={query.MallBaseId}");
                }
                if (!string.IsNullOrWhiteSpace(query.Name))
                {
                    builder.Append($" AND {nameof(RB_Member_DepositBalance_Extend.Name)} like '%{query.Name}%'");
                }
                if (query.OldDepositBuyId > 0)
                {
                    builder.Append($" AND {nameof(RB_Member_DepositBalance_Extend.OldDepositBuyId)}={query.OldDepositBuyId}");
                }
            }
            return Get<RB_Member_DepositBalance_Extend>(builder.ToString()).ToList();
        }
    }
}
