﻿using Mall.Model.Extend.Product;
using Mall.Repository.Product;
using System.Collections.Generic;
using VT.FW.DB;
using System.Linq;
using Mall.Model.Entity.Product;
using Mall.AOP.CustomerAttribute;
using System;

namespace Mall.Module.Product
{
    /// <summary>
    /// 拼团活动处理类
    /// </summary>
    public partial class GroupBuyActivityModule
    {
        /// <summary>
        /// 新增修改拼团活动
        /// </summary>
        /// <param name="extModel"></param>
        /// <returns></returns>
        [TransactionCallHandler]
        public virtual bool SetGroupbuyActivityModule(RB_Groupbuy_Activity_Extend extModel)
        {
            bool flag = false;

            var oldModel = GetGroupbuyActivityEntityModule(new RB_Groupbuy_Activity_Extend() { ActivityId = extModel.ActivityId }, isGetSpec: false);
            int oldSeparateDistributionType = 0;
            if (oldModel != null)
            {
                oldSeparateDistributionType = oldModel?.SeparateDistributionType ?? 0;
            }
            if (extModel.ActivityId > 0)
            {
                Dictionary<string, object> fileds = new Dictionary<string, object>()
                {
                    { nameof(RB_Groupbuy_Activity_Extend.StartTime),extModel.StartTime},
                    { nameof(RB_Groupbuy_Activity_Extend.EndTime),extModel.EndTime},
                    { nameof(RB_Groupbuy_Activity_Extend.GoodId),extModel.GoodId},
                    { nameof(RB_Groupbuy_Activity_Extend.GoodsStatus),extModel.GoodsStatus},
                    { nameof(RB_Groupbuy_Activity_Extend.SellingPrice),extModel.SellingPrice},
                    { nameof(RB_Groupbuy_Activity_Extend.Original_Price),extModel.Original_Price},
                    { nameof(RB_Groupbuy_Activity_Extend.Goods_Stock),extModel.Goods_Stock},
                    { nameof(RB_Groupbuy_Activity_Extend.Goods_unit),extModel.Goods_unit},
                    { nameof(RB_Groupbuy_Activity_Extend.Goods_no),extModel.Goods_no},
                    { nameof(RB_Groupbuy_Activity_Extend.Goods_weight),extModel.Goods_weight},
                    { nameof(RB_Groupbuy_Activity_Extend.Sort),extModel.Sort},
                    { nameof(RB_Groupbuy_Activity_Extend.Is_Auto_Add_Robot),extModel.Is_Auto_Add_Robot},
                    { nameof(RB_Groupbuy_Activity_Extend.Virtual_Sales),extModel.Virtual_Sales},
                    { nameof(RB_Groupbuy_Activity_Extend.Is_Alone_Buy),extModel.Is_Alone_Buy},
                    { nameof(RB_Groupbuy_Activity_Extend.IsDefaultService),extModel.IsDefaultService},
                    { nameof(RB_Groupbuy_Activity_Extend.GoodsService),extModel.GoodsService},
                    { nameof(RB_Groupbuy_Activity_Extend.FreightId),extModel.FreightId},
                    { nameof(RB_Groupbuy_Activity_Extend.FormsId),extModel.FormsId},
                    { nameof(RB_Groupbuy_Activity_Extend.Confine_Count),extModel.Confine_Count},
                    { nameof(RB_Groupbuy_Activity_Extend.Confine_Order_Count),extModel.Confine_Order_Count},
                    { nameof(RB_Groupbuy_Activity_Extend.Pieces),extModel.Pieces},
                    { nameof(RB_Groupbuy_Activity_Extend.Forehead),extModel.Forehead},
                    { nameof(RB_Groupbuy_Activity_Extend.Is_Area_Limit),extModel.Is_Area_Limit},
                    //{ nameof(RB_Groupbuy_Activity_Extend.Area_limit),extModel.Area_limit},
                    { nameof(RB_Groupbuy_Activity_Extend.Is_quick_shop),extModel.Is_quick_shop},
                    { nameof(RB_Groupbuy_Activity_Extend.Give_integral),extModel.Give_integral},
                    { nameof(RB_Groupbuy_Activity_Extend.Give_integral_type),extModel.Give_integral_type},
                    { nameof(RB_Groupbuy_Activity_Extend.Is_forehead_integral),extModel.Is_forehead_integral},
                    { nameof(RB_Groupbuy_Activity_Extend.Forehead_integral_type),extModel.Forehead_integral_type},
                    { nameof(RB_Groupbuy_Activity_Extend.Accumulative),extModel.Accumulative},
                    { nameof(RB_Groupbuy_Activity_Extend.CardIds),extModel.CardIds},
                    { nameof(RB_Groupbuy_Activity_Extend.App_share_title),extModel.App_share_title},
                    { nameof(RB_Groupbuy_Activity_Extend.App_share_pic),extModel.App_share_pic},
                    { nameof(RB_Groupbuy_Activity_Extend.IsCustomSpecification),extModel.IsCustomSpecification},
                    { nameof(RB_Groupbuy_Activity_Extend.SeparateDistribution),extModel.SeparateDistribution},
                    { nameof(RB_Groupbuy_Activity_Extend.SeparateDistributionType),extModel.SeparateDistributionType},
                    { nameof(RB_Groupbuy_Activity_Extend.SeparateDistributionMoneyType),extModel.SeparateDistributionMoneyType},
                    { nameof(RB_Groupbuy_Activity_Extend.EnjoyMember),extModel.EnjoyMember},
                    { nameof(RB_Groupbuy_Activity_Extend.SeparateSetMember),extModel.SeparateSetMember},
                };
                flag = groupbuy_ActivityRepository.Update(fileds, new WhereHelper(nameof(RB_Groupbuy_Activity_Extend.ActivityId), extModel.ActivityId));
            }
            else
            {
                var newId = groupbuy_ActivityRepository.Insert(extModel);
                extModel.ActivityId = newId;
                flag = newId > 0;
            }
            if (flag)
            {
                flag = SetGroupBuyAreaModule(extModel);
                flag = SetGoodsSpecificationModule(extModel, out bool isChange);
                flag = SetGoodGroupStepModule(extModel, isChange, oldSeparateDistributionType);
            }
            return flag;
        }

        /// <summary>
        /// 新增修改区域
        /// </summary>
        /// <param name="extModel"></param>
        /// <returns></returns>
        private bool SetGroupBuyAreaModule(RB_Groupbuy_Activity_Extend extModel)
        {
            bool flag = false;
            var alist = GetGroupBuyAreaModule(new RB_GroupBuy_Area_Extend() { GoodsId = extModel.GoodId, TenantId = extModel.TenantId, MallBaseId = extModel.MallBaseId });
            var insertList1 = extModel.AreaList.Where(x => !alist.Select(y => y.AreaId).Contains(x.AreaId)).ToList();
            var deleteList1 = alist.Where(x => !extModel.AreaList.Select(y => y.AreaId).Contains(x.AreaId)).ToList();
            foreach (var item in insertList1)
            {
                flag = groupbuy_AreaRepository.Insert(new RB_GroupBuy_Area_Extend()
                {
                    AreaId = item.AreaId,
                    AreaType = item.AreaType,
                    CreateDate = DateTime.Now,
                    GoodsId = extModel.GoodId,
                    Id = 0,
                    MallBaseId = extModel.MallBaseId,
                    Status = 0,
                    TenantId = extModel.TenantId
                }) > 0;
            }
            foreach (var item in deleteList1)
            {
                flag= groupbuy_AreaRepository.Delete(item.Id)>0;
            }
            return false;
        }

        /// <summary>
        /// 添加修改商品规格
        /// </summary>
        /// <param name="extModel"></param>
        /// <param name="isChange">是否规格有改变</param>
        /// <returns></returns>
        private bool SetGoodsSpecificationModule(RB_Groupbuy_Activity_Extend extModel, out bool isChange)
        {
            isChange = false;
            bool flag = true;
            var old_SpecificationList = GetGroupbuyActivitySpecificationListModule(
                new RB_Groupbuy_Activity_Specification_Extend() { GoodsId = extModel.GoodId, TenantId = extModel.TenantId, MallBaseId = extModel.MallBaseId });
            if (extModel.IsCustomSpecification == 1)
            {
                //判断规格条数是否变动
                if (old_SpecificationList.Count() != extModel.SpecificationList.Count() || old_SpecificationList.Count() != extModel.SpecificationList.Where(x => x.Id > 0).Count())
                {
                    isChange = true;
                    //删除规格
                    groupbuy_Activity_SpecificationRepository.DeleteOne(new WhereHelper(nameof(RB_Groupbuy_Activity_Specification_Extend.GoodsId), extModel.GoodId));
                    //删除规格值
                    groupbuy_Activity_SpecificationValueRepository.DeleteOne(new WhereHelper(nameof(RB_Groupbuy_Activity_Specificationvalue_Extend.GoodsId), extModel.GoodId));
                    //删除规格价格
                    groupbuy_Activity_SpecificationPriceRepository.DeleteOne(new WhereHelper(nameof(RB_Groupbuy_Activity_Specificationprice_Extend.GoodsId), extModel.GoodId));

                    //新增规格和规格值
                    foreach (var specItem in extModel.SpecificationList)
                    {
                        //新增规格
                        var specModel = new RB_Groupbuy_Activity_Specification_Extend()
                        {
                            CreateDate = DateTime.Now,
                            EnabledImage = specItem.EnabledImage,
                            GoodsId = extModel.GoodId,
                            Id = 0,
                            TenantId = extModel.TenantId,
                            MallBaseId = extModel.MallBaseId,
                            Status = 0,
                            Name = specItem.Name,
                            Sort = specItem.Sort,
                        };

                        var newSpecId = groupbuy_Activity_SpecificationRepository.Insert(specModel);
                        specModel.Id = newSpecId;
                        flag = newSpecId > 0;

                        //新增规格值
                        if (specItem.SpecificationValueList != null && specItem.SpecificationValueList.Count > 0)
                        {
                            foreach (var specValueItem in specItem.SpecificationValueList)
                            {
                                var specValueModel = new RB_Groupbuy_Activity_Specificationvalue_Extend()
                                {
                                    MallBaseId = extModel.MallBaseId,
                                    TenantId = extModel.TenantId,
                                    SpecificationId = specModel.Id,
                                    GoodsId = extModel.GoodId,
                                    CreateDate = DateTime.Now,
                                    Status = 0,
                                    Id = 0,
                                    Image = specValueItem.Image,
                                    Name = specValueItem.Name,
                                    Sort = specValueItem.Sort,
                                };
                                var specValueId = groupbuy_Activity_SpecificationValueRepository.Insert(specValueModel);
                                specValueModel.Id = specValueId;
                                flag = specValueId > 0;
                            }
                        }
                    }

                    //新增规格价格
                    foreach (var priceItem in extModel.SpecificationPriceList)
                    {
                        var priceModel = new RB_Groupbuy_Activity_Specificationprice_Extend()
                        {
                            Id = 0,
                            MallBaseId = extModel.MallBaseId,
                            TenantId = extModel.TenantId,
                            GoodsId = extModel.GoodId,
                            Status = 0,
                            CreateDate = DateTime.Now,
                            UpdateDate = DateTime.Now,
                            GoodsNumbers = priceItem.GoodsNumbers,
                            GoodsWeight = priceItem.GoodsWeight,
                            InventoryNum = priceItem.InventoryNum,
                            SellingPrice = priceItem.SellingPrice,
                            SpecificationSort = priceItem.SpecificationSort,
                            Commission = priceItem.Commission,
                            CostMoney = priceItem.CostMoney
                        };
                        flag = groupbuy_Activity_SpecificationPriceRepository.Insert(priceModel) > 0;
                    }
                }
                else
                {
                    var specValuelist = GetGroupbuyActivitySpecificationValueListModule(new RB_Groupbuy_Activity_Specificationvalue_Extend() { GoodsId = extModel.GoodId, TenantId = extModel.TenantId, MallBaseId = extModel.MallBaseId });
                    var specPricelist = GetGroupbuyActivitySpecificationpriceListModule(new RB_Groupbuy_Activity_Specificationprice_Extend() { GoodsId = extModel.GoodId, TenantId = extModel.TenantId, MallBaseId = extModel.MallBaseId });
                    foreach (var item in old_SpecificationList)
                    {
                        var supmodel = extModel.SpecificationList.Where(x => x.Id == item.Id).FirstOrDefault();
                        Dictionary<string, object> specFileds = new Dictionary<string, object>()
                        {
                            { nameof(RB_Groupbuy_Activity_Specification_Extend.EnabledImage),supmodel.EnabledImage},
                            { nameof(RB_Groupbuy_Activity_Specification_Extend.Name),supmodel.Name},
                            { nameof(RB_Groupbuy_Activity_Specification_Extend.Sort),supmodel.Sort}
                        };
                        flag = groupbuy_Activity_SpecificationRepository.Update(specFileds, new WhereHelper(nameof(RB_Groupbuy_Activity_Specification_Extend.Id), item.Id));
                        if (flag)
                        {
                            var sv2list = specValuelist.Where(x => x.SpecificationId == item.Id).ToList();
                            if (sv2list.Count() != supmodel.SpecificationValueList.Count() || sv2list.Count() != supmodel.SpecificationValueList.Where(x => x.Id > 0).Count())
                            {
                                isChange = true;
                                groupbuy_Activity_SpecificationValueRepository.Delete(new WhereHelper(nameof(RB_Groupbuy_Activity_Specificationvalue_Extend.GoodsId), extModel.GoodId));
                                foreach (var specValueItem in supmodel.SpecificationValueList)
                                {
                                    flag = groupbuy_Activity_SpecificationValueRepository.Insert(new RB_Groupbuy_Activity_Specificationvalue_Extend()
                                    {
                                        MallBaseId = extModel.MallBaseId,
                                        TenantId = extModel.TenantId,
                                        SpecificationId = supmodel.Id,
                                        GoodsId = extModel.GoodId,
                                        CreateDate = DateTime.Now,
                                        Status = 0,
                                        Id = 0,
                                        Image = specValueItem.Image,
                                        Name = specValueItem.Name,
                                        Sort = specValueItem.Sort,
                                    }) > 0;
                                }
                            }
                            else
                            {
                                foreach (var qitem in sv2list)
                                {
                                    var supModel1 = supmodel.SpecificationValueList.Where(x => x.Id == qitem.Id).FirstOrDefault();
                                    Dictionary<string, object> specValueFileds = new Dictionary<string, object>()
                                    {
                                        { nameof(RB_Groupbuy_Activity_Specificationvalue_Extend.Image),supModel1.Image},
                                        { nameof(RB_Groupbuy_Activity_Specificationvalue_Extend.Name),supModel1.Name},
                                        { nameof(RB_Groupbuy_Activity_Specificationvalue_Extend.Sort),supModel1.Sort}
                                    };
                                    flag = groupbuy_Activity_SpecificationValueRepository.Update(specValueFileds, new WhereHelper(nameof(RB_Groupbuy_Activity_Specificationvalue_Extend.Id), qitem.Id));
                                }
                            }
                        }
                    }

                    //规格价格处理
                    if (specPricelist.Count() != extModel.SpecificationPriceList.Count() || specPricelist.Count() != extModel.SpecificationPriceList.Where(x => specPricelist.Select(y => y.SpecificationSort).Contains(x.SpecificationSort)).Count())
                    {
                        isChange = true;
                        //删除规格价格
                        groupbuy_Activity_SpecificationPriceRepository.DeleteOne(new WhereHelper(nameof(RB_Groupbuy_Activity_Specificationprice_Extend.GoodsId), extModel.GoodId));
                        foreach (var priceItem in extModel.SpecificationPriceList)
                        {
                            var priceModel = new RB_Groupbuy_Activity_Specificationprice_Extend()
                            {
                                Id = 0,
                                MallBaseId = extModel.MallBaseId,
                                TenantId = extModel.TenantId,
                                GoodsId = extModel.GoodId,
                                Status = 0,
                                CreateDate = DateTime.Now,
                                UpdateDate = DateTime.Now,
                                GoodsNumbers = priceItem.GoodsNumbers,
                                GoodsWeight = priceItem.GoodsWeight,
                                InventoryNum = priceItem.InventoryNum,
                                SellingPrice = priceItem.SellingPrice,
                                SpecificationSort = priceItem.SpecificationSort,
                                Commission = priceItem.Commission,
                                CostMoney = priceItem.CostMoney
                            };
                            flag = groupbuy_Activity_SpecificationPriceRepository.Insert(priceModel) > 0;
                        }
                    }
                    else
                    {
                        foreach (var item in specPricelist)
                        {
                            var pupmodel = extModel.SpecificationPriceList.Where(x => x.SpecificationSort == item.SpecificationSort).FirstOrDefault();
                            if (item.Commission != pupmodel.Commission || item.CostMoney != pupmodel.CostMoney || item.SellingPrice != pupmodel.SellingPrice || item.InventoryNum != pupmodel.InventoryNum || item.GoodsNumbers != pupmodel.GoodsNumbers || item.GoodsWeight != pupmodel.GoodsWeight)
                            {
                                Dictionary<string, object> specPriceFileds = new Dictionary<string, object>()
                                {
                                    { nameof(RB_Groupbuy_Activity_Specificationprice_Extend.SellingPrice),pupmodel.SellingPrice},
                                    { nameof(RB_Groupbuy_Activity_Specificationprice_Extend.InventoryNum),pupmodel.InventoryNum},
                                    { nameof(RB_Groupbuy_Activity_Specificationprice_Extend.GoodsWeight),pupmodel.GoodsWeight},
                                    { nameof(RB_Groupbuy_Activity_Specificationprice_Extend.GoodsNumbers),pupmodel.GoodsNumbers},
                                    { nameof(RB_Groupbuy_Activity_Specificationprice_Extend.Commission),pupmodel.Commission},
                                    { nameof(RB_Groupbuy_Activity_Specificationprice_Extend.CostMoney),pupmodel.CostMoney},
                                };
                                flag = groupbuy_Activity_SpecificationPriceRepository.Update(specPriceFileds, new WhereHelper(nameof(RB_Groupbuy_Activity_Specificationprice_Extend.Id),item.Id));
                            }
                        }
                    }
                }
            }
            return flag;
        }

        /// <summary>
        /// 新增修改阶梯团价
        /// </summary>
        /// <param name="extModel"></param>
        /// <param name="isChange"></param>
        /// <param name="oldSeparateDistributionType"></param>
        /// <returns></returns>
        private bool SetGoodGroupStepModule(RB_Groupbuy_Activity_Extend extModel, bool isChange, int oldSeparateDistributionType)
        {
            bool flag = true;
            var stepList =  GetGroupBuyActivityListModule(new RB_Groupbuy_Activity_Step_Extend() { GoodId = extModel.GoodId, MallBaseId = extModel.MallBaseId, TenantId = extModel.TenantId });
            if (isChange || (stepList.Count() != extModel.GroupList.Count() || stepList.Count() != extModel.GroupList.Where(qitem => qitem.StepId > 0).Count()))
            {
                stepRepository.DeleteOne(new WhereHelper(nameof(RB_Groupbuy_Activity_Step_Extend.GoodId), extModel.GoodId));
                groupbuy_Activity_Step_PriceRepository.DeleteOne(new WhereHelper(nameof(RB_Groupbuy_Activity_Step_Price_Extend.GoodId), extModel.GoodId));
                groupBuy_DistributioncommissionRepository.DeleteOne(new WhereHelper(nameof(RB_GroupBuy_Distributioncommission_Extend.GoodsId), extModel.GoodId));
                groupbuy_MemberpriceRepository.DeleteOne(new WhereHelper(nameof(RB_Groupbuy_Memberprice_Extend.GoodsId), extModel.GoodId));
                foreach (var groupItem in extModel.GroupList)
                {
                    var groupModel = new RB_Groupbuy_Activity_Step_Extend()
                    {
                        TenantId = extModel.TenantId,
                        MallBaseId = extModel.MallBaseId,
                        GoodId = extModel.GoodId,
                        People_Num = groupItem.People_Num,
                        Preferential_Price = groupItem.Preferential_Price,
                        Pintuan_Time = groupItem.Pintuan_Time,
                        Group_Num = groupItem.Group_Num,
                    };
                    var newStepId = stepRepository.Insert(groupModel);
                    groupModel.StepId = newStepId;
                    flag = newStepId > 0;

                    if (groupModel.StepId > 0)
                    {
                        if (groupItem.StepPriceList != null && groupItem.StepPriceList.Count > 0)
                        {
                            //添加会员价格
                            foreach (var subItem in groupItem.StepPriceList)
                            {
                                var stepPriceModel = new RB_Groupbuy_Activity_Step_Price_Extend()
                                {
                                    MallBaseId = extModel.MallBaseId,
                                    TenantId = extModel.TenantId,
                                    GoodId = extModel.GoodId,
                                    StepId = groupModel.StepId,
                                    PinTuanPrice = subItem.PinTuanPrice,
                                    PinTuanStock = subItem.PinTuanStock,
                                    SpecificationSort = subItem.SpecificationSort,
                                    SortNum = subItem.SortNum,
                                };
                                flag = groupbuy_Activity_Step_PriceRepository.Insert(stepPriceModel) > 0;
                            }
                        }
                        //设置分销佣金
                        SetDistributioncommissionModule(extModel, groupItem, groupModel.StepId, isCreate: true);

                        //会员价设置
                        if (groupItem.MemberpriceList != null && groupItem.MemberpriceList.Count > 0)
                        {
                            foreach (var subItem in groupItem.MemberpriceList)
                            {
                                if (subItem.GradeMemberPriceList != null && subItem.GradeMemberPriceList.Count > 0)
                                {
                                    foreach (var childItem in subItem.GradeMemberPriceList)
                                    {
                                        var memberModel = new RB_Groupbuy_Memberprice_Extend()
                                        {
                                            SpecificationSort = subItem.SpecificationSort,
                                            GoodsId = extModel.GoodId,
                                            Status = 0,
                                            TenantId = extModel.TenantId,
                                            MallBaseId = extModel.MallBaseId,
                                            StepId = groupModel.StepId,
                                            CreateDate = DateTime.Now,
                                            UpdateDate = DateTime.Now,
                                            MemberGrade = childItem.MemberGrade,
                                            MemberPrice = childItem.MemberPrice,
                                        };
                                        var newMemberId = groupbuy_MemberpriceRepository.Insert(memberModel);
                                        memberModel.Id = newMemberId;
                                        flag = newMemberId > 0;
                                    }
                                }
                            }
                        }
                    }
                }
            }
            else
            {
                var stepPriceList = GetGroupbuyActivitySpecificationpriceListModule(new RB_Groupbuy_Activity_Step_Price_Extend()
                {
                    GoodId = extModel.GoodId,
                    TenantId = extModel.TenantId,
                    MallBaseId = extModel.MallBaseId
                });
                var memberPriceList = GetGroupBuyMemberpriceModule(new RB_Groupbuy_Memberprice_Extend()
                {
                    GoodsId = extModel.GoodId,
                    TenantId = extModel.TenantId,
                    MallBaseId = extModel.MallBaseId
                });
                if (oldSeparateDistributionType != extModel.SeparateDistributionType)
                {
                    groupBuy_DistributioncommissionRepository.DeleteOne(new WhereHelper(nameof(RB_GroupBuy_Distributioncommission_Extend.GoodsId), extModel.GoodId));
                }
                foreach (var item in stepList)
                {
                    var stepModel = extModel.GroupList.Where(qitem => qitem.StepId == item.StepId).FirstOrDefault();
                    Dictionary<string, object> stepFileds = new Dictionary<string, object>()
                    {
                        { nameof(RB_Groupbuy_Activity_Step_Extend.People_Num),stepModel.People_Num},
                        { nameof(RB_Groupbuy_Activity_Step_Extend.Preferential_Price),stepModel.Preferential_Price},
                        { nameof(RB_Groupbuy_Activity_Step_Extend.Pintuan_Time),stepModel.Pintuan_Time},
                        { nameof(RB_Groupbuy_Activity_Step_Extend.Group_Num),stepModel.Group_Num},
                    };
                    flag = stepRepository.Update(stepFileds, new WhereHelper(nameof(RB_Groupbuy_Activity_Step_Extend.StepId), item.StepId));

                    //更新价格和库存
                    foreach (var subItem in stepModel.StepPriceList)
                    {
                        var subPriceModel = stepPriceList.Where(qitem => qitem.StepId == item.StepId && qitem.SpecificationSort == subItem.SpecificationSort).FirstOrDefault();
                        Dictionary<string, object> stepPriceFileds = new Dictionary<string, object>()
                        {
                            { nameof(RB_Groupbuy_Activity_Step_Price_Extend.PinTuanPrice),subItem.PinTuanPrice},
                            { nameof(RB_Groupbuy_Activity_Step_Price_Extend.PinTuanStock),subItem.PinTuanStock},
                            { nameof(RB_Groupbuy_Activity_Step_Price_Extend.SortNum),subItem.SortNum},
                        };
                        flag = groupbuy_Activity_Step_PriceRepository.Update(stepPriceFileds, new WhereHelper(nameof(RB_Groupbuy_Activity_Step_Price_Extend.Id), subPriceModel.Id));
                    }

                    //更新会员价
                    foreach (var subItem in stepModel.MemberpriceList)
                    {
                        foreach (var childItem in subItem.GradeMemberPriceList)
                        {
                            var memberPriceModel = memberPriceList.Where(qitem => qitem.StepId == item.StepId &&qitem.MemberGrade==childItem.MemberGrade && qitem.SpecificationSort == subItem.SpecificationSort).FirstOrDefault();
                            if (memberPriceModel != null)
                            {
                                Dictionary<string, object> memberPriceFileds = new Dictionary<string, object>()
                                {
                                    { nameof(RB_Groupbuy_Memberprice_Extend.MemberGrade),childItem.MemberGrade},
                                    { nameof(RB_Groupbuy_Memberprice_Extend.MemberPrice),childItem.MemberPrice},
                                };
                                flag = groupbuy_MemberpriceRepository.Update(memberPriceFileds, new WhereHelper(nameof(RB_Groupbuy_Memberprice_Extend.Id), memberPriceModel.Id));
                            }
                            else
                            {
                                childItem.SpecificationSort = subItem.SpecificationSort;
                                childItem.GoodsId = extModel.GoodId;
                                childItem.Status = 0;
                                childItem.TenantId = extModel.TenantId;
                                childItem.MallBaseId = extModel.MallBaseId;
                                childItem.StepId = item.StepId;
                                childItem.CreateDate = DateTime.Now;
                                childItem.UpdateDate = DateTime.Now;
                                flag = groupbuy_MemberpriceRepository.Insert(childItem) > 0;
                            }
                        }
                    }

                    if (oldSeparateDistributionType != extModel.SeparateDistributionType)
                    {
                        //设置分销佣金
                        SetDistributioncommissionModule(extModel, stepModel, item.StepId, isCreate: true);
                    }
                    else
                    {
                        //设置分销佣金
                        SetDistributioncommissionModule(extModel, stepModel, item.StepId, isCreate: false);
                    }
                }
            }
            return flag;
        }

        /// <summary>
        /// 添加修改分销佣金
        /// </summary>
        /// <param name="extModel"></param>
        /// <param name="groupItem"></param>
        /// <param name="StepId"></param>
        /// <returns></returns>
        private bool SetDistributioncommissionModule(RB_Groupbuy_Activity_Extend extModel, RB_Groupbuy_Activity_Step_Extend groupItem, int StepId, bool isCreate = true)
        {
            bool flag = false;
            //新增分销佣金
            if (isCreate)
            {
                //普通设置
                if (extModel.SeparateDistributionType == 1)
                {
                    //分销商分销佣金设置
                    if (groupItem.DistributioncommissionList != null && groupItem.DistributioncommissionList.Count > 0)
                    {
                        foreach (var subItem in groupItem.DistributioncommissionList)
                        {
                            var commissionModel = new RB_GroupBuy_Distributioncommission_Extend()
                            {
                                GoodsId = extModel.GoodId,
                                Status = 0,
                                TenantId = extModel.TenantId,
                                MallBaseId = extModel.MallBaseId,
                                StepId = StepId,
                                UpdateDate = DateTime.Now,
                                CreateDate = DateTime.Now,
                                SpecificationSort = subItem.SpecificationSort,
                                DistributorGrade = subItem.DistributorGrade,
                                OneCommission = subItem.OneCommission,
                                TwoCommission = subItem.TwoCommission,
                                ThreeCommission = subItem.ThreeCommission,
                            };
                            var newDistriId = groupBuy_DistributioncommissionRepository.Insert(commissionModel);
                            commissionModel.Id = newDistriId;
                            flag = newDistriId > 0;
                        }
                    }
                } //详细设置
                else if (extModel.SeparateDistributionType == 2)
                {
                    if (groupItem.DistributionCommissionTreeList != null && groupItem.DistributionCommissionTreeList.Count > 0)
                    {
                        foreach (var subItem in groupItem.DistributionCommissionTreeList)
                        {
                            if (subItem.GradeCommissionList != null && subItem.GradeCommissionList.Count > 0)
                            {
                                foreach (var childItem in subItem.GradeCommissionList)
                                {
                                    var commissionModel = new RB_GroupBuy_Distributioncommission_Extend()
                                    {
                                        GoodsId = extModel.GoodId,
                                        Status = 0,
                                        TenantId = extModel.TenantId,
                                        MallBaseId = extModel.MallBaseId,
                                        StepId = StepId,
                                        UpdateDate = DateTime.Now,
                                        CreateDate = DateTime.Now,
                                        SpecificationSort = subItem.SpecificationSort,
                                        DistributorGrade = childItem.DistributorGrade,
                                        OneCommission = childItem.OneCommission,
                                        TwoCommission = childItem.TwoCommission,
                                        ThreeCommission = childItem.ThreeCommission,
                                    };
                                    var newDistriId = groupBuy_DistributioncommissionRepository.Insert(commissionModel);
                                    commissionModel.Id = newDistriId;
                                    flag = newDistriId > 0;
                                }
                            }
                        }
                    }
                }
            }
            //修改分销佣金
            else
            {
                var distributionList = GetGroupBuyCommissionModule(new RB_GroupBuy_Distributioncommission_Extend()
                {
                    GoodsId = extModel.GoodId,
                    TenantId = extModel.TenantId,
                    MallBaseId = extModel.MallBaseId
                });
                //普通设置
                if (extModel.SeparateDistributionType == 1)
                {
                    foreach (var item in groupItem.DistributioncommissionList)
                    {
                        var defaultModel = distributionList?.Where(qitem => qitem.StepId == StepId && qitem.SpecificationSort == item.SpecificationSort && qitem.DistributorGrade == item.DistributorGrade).FirstOrDefault();
                        if (defaultModel != null && defaultModel.Id > 0)
                        {
                            Dictionary<string, object> comFileds = new Dictionary<string, object>()
                            {
                                { nameof(RB_GroupBuy_Distributioncommission_Extend.OneCommission),item.OneCommission},
                                { nameof(RB_GroupBuy_Distributioncommission_Extend.TwoCommission),item.TwoCommission},
                                { nameof(RB_GroupBuy_Distributioncommission_Extend.ThreeCommission),item.ThreeCommission},
                            };
                            flag = groupBuy_DistributioncommissionRepository.Update(comFileds, new WhereHelper(nameof(RB_GroupBuy_Distributioncommission_Extend.Id), defaultModel.Id));
                        }
                        else
                        {
                            var commissionModel = new RB_GroupBuy_Distributioncommission_Extend()
                            {
                                GoodsId = extModel.GoodId,
                                Status = 0,
                                TenantId = extModel.TenantId,
                                MallBaseId = extModel.MallBaseId,
                                StepId = StepId,
                                UpdateDate = DateTime.Now,
                                CreateDate = DateTime.Now,
                                SpecificationSort = item.SpecificationSort,
                                DistributorGrade = item.DistributorGrade,
                                OneCommission = item.OneCommission,
                                TwoCommission = item.TwoCommission,
                                ThreeCommission = item.ThreeCommission,
                            };
                            var newDistriId = groupBuy_DistributioncommissionRepository.Insert(commissionModel);
                            commissionModel.Id = newDistriId;
                            flag = newDistriId > 0;
                        }
                    }
                } //详细设置
                else if (extModel.SeparateDistributionType == 2)
                {
                    if (groupItem.DistributionCommissionTreeList != null && groupItem.DistributionCommissionTreeList.Count > 0)
                    {
                        foreach (var subItem in groupItem.DistributionCommissionTreeList)
                        {
                            if (subItem.GradeCommissionList != null && subItem.GradeCommissionList.Count > 0)
                            {
                                foreach (var childItem in subItem.GradeCommissionList)
                                {
                                    var oldModel = distributionList.Where(qitem => qitem.StepId == childItem.StepId && qitem.SpecificationSort == subItem.SpecificationSort && qitem.DistributorGrade == childItem.DistributorGrade).FirstOrDefault();
                                    if (oldModel != null && oldModel.Id > 0)
                                    {
                                        Dictionary<string, object> comFileds = new Dictionary<string, object>()
                                        {
                                            { nameof(RB_GroupBuy_Distributioncommission_Extend.OneCommission),childItem.OneCommission},
                                            { nameof(RB_GroupBuy_Distributioncommission_Extend.TwoCommission),childItem.TwoCommission},
                                            { nameof(RB_GroupBuy_Distributioncommission_Extend.ThreeCommission),childItem.ThreeCommission},
                                        };
                                        flag = groupBuy_DistributioncommissionRepository.Update(comFileds, new WhereHelper(nameof(RB_GroupBuy_Distributioncommission_Extend.Id), oldModel.Id));
                                    }
                                    else
                                    {
                                        var commissionModel = new RB_GroupBuy_Distributioncommission_Extend()
                                        {
                                            GoodsId = extModel.GoodId,
                                            Status = 0,
                                            TenantId = extModel.TenantId,
                                            MallBaseId = extModel.MallBaseId,
                                            StepId = StepId,
                                            UpdateDate = DateTime.Now,
                                            CreateDate = DateTime.Now,
                                            SpecificationSort = subItem.SpecificationSort,
                                            DistributorGrade = childItem.DistributorGrade,
                                            OneCommission = childItem.OneCommission,
                                            TwoCommission = childItem.TwoCommission,
                                            ThreeCommission = childItem.ThreeCommission,
                                        };
                                        var newDistriId = groupBuy_DistributioncommissionRepository.Insert(commissionModel);
                                        commissionModel.Id = newDistriId;
                                        flag = newDistriId > 0;
                                    }
                                }
                            }
                        }
                    }
                }
            }
            return flag;
        }

        /// <summary>
        /// 根据编号删除活动商品规格
        /// </summary>
        /// <returns></returns>
        public bool RemoveGroupBuySpecificationModule(object Id)
        {
            //根据商品规格删除商品价格
            //List<WhereHelper> specValues = new List<WhereHelper>()
            //{
            //  new WhereHelper(nameof(RB_Groupbuy_Activity_Specificationprice_Extend.SpecificationId),Id)
            //};
            //groupbuy_Activity_SpecificationPriceRepository.Delete(specValues);
            return groupbuy_Activity_SpecificationPriceRepository.Delete(Id) > 0;
        }

        /// <summary>
        /// 根据编号删除活动商品规格值
        /// </summary>
        /// <returns></returns>
        public bool RemoveGroupBuySpecificationValueModule(object Id)
        {
            //根据规格值删除价格
            //List<WhereHelper> specValues = new List<WhereHelper>()
            //{
            //  new WhereHelper(nameof(RB_Groupbuy_Activity_Specificationprice_Extend.SpecificationValueId),Id)
            //};
            //groupbuy_Activity_SpecificationPriceRepository.Delete(specValues);
            return groupbuy_Activity_SpecificationValueRepository.Delete(Id) > 0;
        }
    }
}