﻿using System;
using System.Collections.Generic;
using System.Text;
using Mall.Model.Entity.User;
using Mall.Model.Extend.User;
using Mall.Repository;
using Mall.Repository.User;
using System.Linq;

namespace Mall.Module.User
{
    /// <summary>
    /// 员工相关处理类
    /// </summary>
    public class EmployeeModule
    {
        /// <summary>
        /// 角色管理仓储层对象
        /// </summary>
        private readonly RB_RoleRepository roleRepository = new RB_RoleRepository();

        /// <summary>
        /// 员工管理仓储层对象
        /// </summary>
        private readonly RB_EmployeeRepository employeeRepository = new RB_EmployeeRepository();

        /// <summary>
        /// 员工配置仓储层对象
        /// </summary>
        private readonly RB_Emp_ConfigRepository emp_ConfigRepository = new RB_Emp_ConfigRepository();

        #region  角色管理
        /// <summary>
        /// 角色分页列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Role_Extend> GetRolePageListModule(int pageIndex, int pageSize, out long rowCount, RB_Role_Extend query)
        {
            return roleRepository.GetRolePageListRepository(pageIndex, pageSize, out rowCount, query);
        }

        /// <summary>
        /// 获取角色列表
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Role_Extend> GetRoleListModule(RB_Role_Extend query)
        {
            return roleRepository.GetRoleListRepository(query);
        }

        /// <summary>
        /// 新增修改角色
        /// </summary>
        /// <param name="extModel"></param>
        /// <returns></returns>
        public bool SetRoleModule(RB_Role_Extend extModel)
        {
            bool flag = false;
            if (extModel.RoleId > 0)
            {
                Dictionary<string, object> fileds = new Dictionary<string, object>()
                {
                    { nameof(RB_Role_Extend.RoleName),extModel.RoleName.Trim()},
                    { nameof(RB_Role_Extend.RoleIntro),extModel.RoleIntro},
                    { nameof(RB_Role_Extend.RoleAuth),extModel.RoleAuth},
                };
                flag = roleRepository.Update(fileds, new WhereHelper(nameof(RB_Role_Extend.RoleId), extModel.RoleId));
            }
            else
            {
                var newId = roleRepository.Insert(extModel);
                extModel.RoleId = newId;
                flag = newId > 0;
            }
            return flag;
        }

        /// <summary>
        /// 获取角色实体
        /// </summary>
        /// <param name="RoleId"></param>
        /// <returns></returns>
        public RB_Role_Extend GetRoleModule(object RoleId)
        {
            return roleRepository.GetEntity<RB_Role_Extend>(RoleId);
        }

        /// <summary>
        /// 删除角色
        /// </summary>
        /// <param name="RoleId"></param>
        /// <returns></returns>
        public bool RemoveRoleModule(object RoleId)
        {
            bool flag = false;
            Dictionary<string, object> fileds = new Dictionary<string, object>()
            {
                { nameof(RB_Role_Extend.Status),1},
            };
            flag = roleRepository.Update(fileds, new WhereHelper(nameof(RB_Role_Extend.RoleId), RoleId));
            return flag;
        }

        #endregion

        #region  员工管理

        /// <summary>
        /// 员工分页列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Employee_Extend> GetEmployeePageListModule(int pageIndex, int pageSize, out long rowCount, RB_Employee_Extend query)
        {
            return employeeRepository.GetEmployeePageListRepository(pageIndex, pageSize, out rowCount, query);
        }

        /// <summary>
        /// 获取员工列表
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Employee_Extend> GetEmployeeListModule(RB_Employee_Extend query)
        {
            return employeeRepository.GetEmployeeListRepository(query);
        }

        /// <summary>
        /// 新增修改员工
        /// </summary>
        /// <param name="extModel"></param>
        /// <returns></returns>
        public bool SetEmployeeModule(RB_Employee_Extend extModel)
        {
            bool flag = false;
            if (extModel.EmpId > 0)
            {
                Dictionary<string, object> fileds = new Dictionary<string, object>()
                {
                    { nameof(RB_Employee_Extend.EmpAccount),extModel.EmpAccount.Trim()},
                    { nameof(RB_Employee_Extend.EmpPwd),extModel.EmpPwd},
                    { nameof(RB_Employee_Extend.EmpName),extModel.EmpName},
                    { nameof(RB_Employee_Extend.RoleAuth),extModel.RoleAuth},
                };
                flag = employeeRepository.Update(fileds, new WhereHelper(nameof(RB_Employee_Extend.EmpId), extModel.EmpId));
            }
            else
            {
                var newId = employeeRepository.Insert(extModel);
                extModel.EmpId = newId;
                flag = newId > 0;
            }
            return flag;
        }

        /// <summary>
        /// 获取员工实体
        /// </summary>
        /// <param name="EmpId"></param>
        /// <returns></returns>
        public RB_Employee_Extend GetEmployeeModule(object EmpId)
        {
            return employeeRepository.GetEntity<RB_Employee_Extend>(EmpId);
        }

        /// <summary>
        /// 删除员工
        /// </summary>
        /// <param name="EmpId"></param>
        /// <returns></returns>
        public bool RemoveEmployeeModule(object EmpId)
        {
            bool flag = false;
            Dictionary<string, object> fileds = new Dictionary<string, object>()
            {
                { nameof(RB_Employee_Extend.Status),1},
            };
            flag = roleRepository.Update(fileds, new WhereHelper(nameof(RB_Employee_Extend.EmpId), EmpId));
            return flag;
        }

        #endregion

        #region 员工配置

        /// <summary>
        /// 获取员工配置实体
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public RB_Emp_Config_Extend GetEmpConfigListModule(RB_Emp_Config_Extend query)
        {
            return emp_ConfigRepository.GetEmpConfigListRepository(query)?.FirstOrDefault();
        }

        /// <summary>
        /// 新增修改员工配置
        /// </summary>
        /// <param name="extModel"></param>
        /// <returns></returns>
        public bool SetEmpConfigModule(RB_Emp_Config_Extend extModel)
        {
            bool flag = false;
            if (extModel.ConfigId > 0)
            {
                Dictionary<string, object> fileds = new Dictionary<string, object>()
                {
                    { nameof(RB_Emp_Config_Extend.IsUpdatePwd),extModel.IsUpdatePwd},
                    { nameof(RB_Emp_Config_Extend.Logo),extModel.Logo},
                    { nameof(RB_Emp_Config_Extend.Copyright),extModel.Copyright},
                    { nameof(RB_Emp_Config_Extend.CopyrightLink),extModel.CopyrightLink},
                };
                flag = emp_ConfigRepository.Update(fileds, new WhereHelper(nameof(RB_Emp_Config_Extend.ConfigId), extModel.ConfigId));
            }
            else
            {
                var newId = emp_ConfigRepository.Insert(extModel);
                extModel.ConfigId = newId;
                flag = newId > 0;
            }
            return flag;
        }
        #endregion
    }
}