using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text.Encodings.Web;
using System.Text.Unicode;
using System.Threading.Tasks;
using Dnc.Api.Throttle;
using Mall.ThirdCore.Message;
using Mall.WebApi.Filter;
using Microsoft.AspNetCore.Builder;
using Microsoft.AspNetCore.Hosting;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.HttpsPolicy;
using Microsoft.AspNetCore.Mvc;
using Microsoft.Extensions.Configuration;
using Microsoft.Extensions.DependencyInjection;
using Microsoft.Extensions.Hosting;
using Microsoft.Extensions.Logging;
using Microsoft.Extensions.Options;
using Senparc.CO2NET;
using Senparc.CO2NET.HttpUtility;
using Senparc.CO2NET.RegisterServices;
using Senparc.Weixin;
using Senparc.Weixin.Entities;
using Senparc.Weixin.RegisterServices;

namespace Mall.WebApi
{
    public class Startup
    {
        public Startup(IConfiguration configuration)
        {
            Configuration = configuration;
        }

        public IConfiguration Configuration { get; }

        // This method gets called by the runtime. Use this method to add services to the container.
        public void ConfigureServices(IServiceCollection services)
        {
            //services.AddHttpClient("elite-wechat").ConfigurePrimaryHttpMessageHandler(() =>
            //{
            //    var httpClientHandler = HttpClientHelper.GetHttpClientHandler(null, RequestUtility.SenparcHttpClientWebProxy, System.Net.DecompressionMethods.GZip);
            //    httpClientHandler.ServerCertificateCustomValidationCallback = (message, cert, chain, errir) => true;
            //    return httpClientHandler;
            //});

            services.Configure<Microsoft.AspNetCore.Server.Kestrel.Core.KestrelServerOptions>(x => x.AllowSynchronousIO = true)
                .Configure<IISServerOptions>(x => x.AllowSynchronousIO = true);
            services.AddControllers();
            services.AddSingleton<IHttpContextAccessor, HttpContextAccessor>(); //עhttp
            services.AddSenparcGlobalServices(Configuration)//Senparc.CO2NET ȫע
                     .AddSenparcWeixinServices(Configuration);//Senparc.Weixin ע
            services.AddMvc().AddJsonOptions(options =>
            {
                options.JsonSerializerOptions.Encoder = JavaScriptEncoder.Create(UnicodeRanges.All);
                options.JsonSerializerOptions.PropertyNamingPolicy = null;
            });
            List<string> corsArray = new List<string>()
            {
                "http://localhost:8081",
                 "http://localhost:8181",
                "http://localhost:8080",
                "http://localhost:8082",
                 "http://localhost:8083",
                "http://127.0.0.1:50512",
                "http://127.0.0.1:20224",
                "http://127.0.0.1:28221",
                "http://www.test.com:8080",
                "http://www.test.com:8081",
                "http://yx.oytour.com",
                "http://mall.oytour.com",
                "http://testmall.oytour.com",
                "http://yx.oytour.com",
                "https://mallapi.oytour.com",
                "http://edu.oytour.com"
            };
            services.AddCors(options => options.AddPolicy("AllowCors", policy => policy.AllowAnyHeader().AllowAnyMethod().AllowCredentials().WithOrigins(corsArray.ToArray())));

            //services.AddCap(x =>
            //{
            //    x.UseMongoDB(Common.Config.Mongo);
            //    x.UseRabbitMQ(cfg =>
            //    {
            //        cfg.HostName = Common.Config.ReadConfigKey("RabbitMqConfig", "HostName");
            //        cfg.VirtualHost = Common.Config.ReadConfigKey("RabbitMqConfig", "VirtualHost");
            //        cfg.Port = Convert.ToInt32(Common.Config.ReadConfigKey("RabbitMqConfig", "Port"));
            //        cfg.UserName = Common.Config.ReadConfigKey("RabbitMqConfig", "UserName");
            //        cfg.Password = Common.Config.ReadConfigKey("RabbitMqConfig", "Password");
            //    });
            //    //ʧܺԴĬ50ΣFailedRetryIntervalĬ60£Ĭ50*60(50)֮ʧ
            //    x.FailedRetryCount = 10;
            //    //ʧܺʰĬ60
            //    x.FailedRetryInterval = 10;
            //    //óɹϢɾʱĬ24*3600
            //    x.SucceedMessageExpiredAfter = 3600;
            //});
            //Api
            services.AddApiThrottle(options => {
                //redis
                //CacheStorageʹͬһredis԰
                options.UseRedisCacheAndStorage(opts => {
                    opts.ConnectionString = "47.96.23.199,password=Viitto2018,connectTimeout=5000,allowAdmin=false,defaultDatabase=0";
                    opts.KeyPrefix = "apithrottle"; //ָkeyǰ׺ĬΪapithrottle
                });
            });

            //ApiThrottleActionFilter
            services.AddMvc(opts => {
                opts.Filters.Add(typeof(ApiThrottleActionFilter));

            }).SetCompatibilityVersion(CompatibilityVersion.Version_3_0);

            services.AddApiThrottle(options =>
                {
                    options.Global.AddValves(new BlackListValve
                    {
                        Policy = Policy.Ip,
                        Priority = 99
                    }, new WhiteListValve
                    {
                        Policy = Policy.UserIdentity,
                        Priority = 88
                    },
               new BlackListValve
               {
                   Policy = Policy.Header,
                   PolicyKey = "throttle",
               });
                });
        }




        // This method gets called by the runtime. Use this method to configure the HTTP request pipeline.
        public void Configure(IApplicationBuilder app, IWebHostEnvironment env, IHostApplicationLifetime appLifetime, IOptions<SenparcSetting> senparcSetting, IOptions<SenparcWeixinSetting> senparcWeixinSetting)
        {
            if (env.IsDevelopment())
            {
                app.UseDeveloperExceptionPage();
            }

            app.UseApiThrottle();
            app.UseHttpsRedirection();

            app.UseRouting();
            // пcorsConfigureServicesõĿ
            app.UseCors("AllowCors");

            app.UseAuthorization();

            app.UseEndpoints(endpoints =>
            {
                endpoints.MapControllers();
            });

            //  CO2NET ȫעᣬ룡
            IRegisterService register = RegisterService.Start(senparcSetting.Value)
                                                        .UseSenparcGlobal(false, null);

            //ʼע΢Ϣ룡
            register.UseSenparcWeixin(senparcWeixinSetting.Value, senparcSetting.Value);
            System.WebHttpContext.HttpContext.Configure(app.ApplicationServices.GetRequiredService<Microsoft.AspNetCore.Http.IHttpContextAccessor>());
            //Ϣ
            Task.Run(() => MessageCore.Init());

            //ȡǰעQuartz
            //var quartz = app.ApplicationServices.GetRequiredService<QuartzHelper>();
            appLifetime.ApplicationStarted.Register(() =>
            {
                Timers.TimerJobj.RunTimer(); //վִ
            });

            appLifetime.ApplicationStopped.Register(() =>
            {
                Timers.TimerJobj.RunStop();  //վִֹͣ
            });
            string filePath = Path.Combine(Directory.GetCurrentDirectory(), "upfile");
            if (System.IO.Directory.Exists(filePath) == false)//ھʹfileļ
            {
                System.IO.Directory.CreateDirectory(filePath);
            }
            app.UseStaticFiles(new StaticFileOptions
            {
                FileProvider = new Microsoft.Extensions.FileProviders.PhysicalFileProvider(
                Path.Combine(Directory.GetCurrentDirectory(), "upfile")),
                RequestPath = "/upfile"
            });
        }
    }
}
