﻿using System;
using System.Collections.Generic;
using System.Text;
using Mall.Model.Entity.Product;
using Mall.Model.Extend.Product;
using System.Linq;

namespace Mall.Repository.Product
{
    /// <summary>
    /// 商品关联课程仓储层
    /// </summary>
    public class RB_Goods_WK_CourseRepository : BaseRepository<RB_Goods_WK_Course>
    {

        /// <summary>
        /// 列表
        /// </summary>
        /// <param name="dmodel">查询条件</param>
        /// <returns></returns>
        public List<RB_Goods_WK_Course_Extend> GetList(RB_Goods_WK_Course_Extend dmodel)
        {
            string where = $" 1=1 and gc.{nameof(RB_Goods_WK_Course.Status)}=0";
            if (dmodel.TenantId > 0) {
                where += $@" and gc.{nameof(RB_Goods_WK_Course.TenantId)}={dmodel.TenantId}";
            }
            if (dmodel.MallBaseId > 0) {
                where += $@" and gc.{nameof(RB_Goods_WK_Course.MallBaseId)}={dmodel.MallBaseId}";
            }
            if (dmodel.Id > 0) {
                where += $@" and gc.{nameof(RB_Goods_WK_Course.Id)}={dmodel.Id}";
            }
            if (dmodel.GoodsId > 0) {
                where += $@" and gc.{nameof(RB_Goods_WK_Course.GoodsId)}={dmodel.GoodsId}";
            }
            if (!string.IsNullOrEmpty(dmodel.GoodsIds)) {
                where += $@" and gc.{nameof(RB_Goods_Category.GoodsId)} in({dmodel.GoodsIds})";
            }
            
            string sql = $@"
SELECT gc.* FROM RB_Goods_WK_Course gc 
WHERE {where} ORDER BY gc.Sort asc ";
            return Get<RB_Goods_WK_Course_Extend>(sql).ToList();
        }

        /// <summary>
        /// 获取分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="count"></param>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public List<RB_Goods_WK_Course_Extend> GetPageList(int pageIndex, int pageSize, out long count, RB_Goods_WK_Course_Extend dmodel)
        {
            string where = $" 1=1 and gc.{nameof(RB_Goods_WK_Course.Status)}=0";
            if (dmodel.TenantId > 0)
            {
                where += $@" and gc.{nameof(RB_Goods_WK_Course.TenantId)}={dmodel.TenantId}";
            }
            if (dmodel.MallBaseId > 0)
            {
                where += $@" and gc.{nameof(RB_Goods_WK_Course.MallBaseId)}={dmodel.MallBaseId}";
            }
            if (dmodel.Id > 0)
            {
                where += $@" and gc.{nameof(RB_Goods_WK_Course.Id)}={dmodel.Id}";
            }
            if (dmodel.GoodsId > 0)
            {
                where += $@" and gc.{nameof(RB_Goods_WK_Course.GoodsId)}={dmodel.GoodsId}";
            }
            if (!string.IsNullOrEmpty(dmodel.GoodsIds))
            {
                where += $@" and gc.{nameof(RB_Goods_Category.GoodsId)} in({dmodel.GoodsIds})";
            }

            string sql = $@"
SELECT gc.* FROM RB_Goods_WK_Course gc 
WHERE {where} ORDER BY gc.Sort asc ";
            return GetPage<RB_Goods_WK_Course_Extend>(pageIndex, pageSize, out count, sql).ToList();
        }
    }
}
