﻿using Mall.Common.API;
using Mall.WebApi.Filter;
using Microsoft.AspNetCore.Cors;
using Microsoft.AspNetCore.Mvc;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Net.Http;
using System.Security.Cryptography;
using System.Text;
using System.Threading.Tasks;

namespace Mall.WebApi.Controllers.Adapay
{

    [Route("api/[controller]/[action]")]
    [ApiExceptionFilter]
    [ApiController]
    [EnableCors("AllowCors")]
    public class MessageController : ControllerBase
    {
        public string token = "jjswviitto";
        public string aes = "leHp9tJo9shWv63PFebqWT3UR6o5OKMD9YKFrDd2yxT";
        public string appId = "wx5349e63aea0c8529";

        /// <summary>
        /// 接口认证
        /// </summary>
        /// <param name="echostr"></param>
        /// <param name="signature"></param>
        /// <param name="timestamp"></param>
        /// <param name="nonce"></param>
        /// <returns></returns>
        [HttpGet]
        public string CheckSignature(string echostr, string signature, string timestamp, string nonce)
        {
            string query = string.Format("echostr:{0} signature:{1} timestamp:{2} nonce:{3}", echostr, signature, timestamp, nonce);
            Common.Plugin.LogHelper.Write("CheckSignature_Query:: " + query);
            string[] ArrTmp = { token, timestamp, nonce };
            Array.Sort(ArrTmp);
            string tmpStr = string.Join("", ArrTmp);
            Common.Plugin.LogHelper.Write("CheckSignature_tmpStr:: " + tmpStr);
            SHA1 sha;
            string hash = "";
            try
            {
                Common.Plugin.LogHelper.Write("CheckSignature_hash:: 11" );
                sha = new SHA1CryptoServiceProvider();
                Common.Plugin.LogHelper.Write("CheckSignature_hash:: 22");
                byte[] dataToHash = Encoding.UTF8.GetBytes(tmpStr);
                Common.Plugin.LogHelper.Write("CheckSignature_hash:: 33");
                byte[] dataHashed = sha.ComputeHash(dataToHash);
                Common.Plugin.LogHelper.Write("CheckSignature_hash:: 44");
                hash = BitConverter.ToString(dataHashed).Replace("-", "");
                Common.Plugin.LogHelper.Write("CheckSignature_hash:: 55");
                hash = hash.ToLower();
            }
            catch (Exception ex)
            {
                Common.Plugin.LogHelper.Write(ex, "CheckSignature");
            }
            Common.Plugin.LogHelper.Write("CheckSignature_hash:: " + hash);
            Common.Plugin.LogHelper.Write("CheckSignature_signature:: " + signature);
            if (hash == signature)
            {
                return echostr;
            }
            return "";
        }


        /// <summary>
        /// 接口认证
        /// </summary>
        /// <param name="echostr"></param>
        /// <param name="signature"></param>
        /// <param name="timestamp"></param>
        /// <param name="nonce"></param>
        /// <returns></returns>
        [HttpPost]
        public string CheckSignature(string signature, string timestamp, string nonce)
        {
            string query = string.Format("echostr1:signature:{1} timestamp:{2} nonce:{3}",  signature, timestamp, nonce);
            Common.Plugin.LogHelper.Write("CheckSignature_Query1:: " + query);
            string[] ArrTmp = { token, timestamp, nonce };
            Array.Sort(ArrTmp);
            string tmpStr = string.Join("", ArrTmp);
            Common.Plugin.LogHelper.Write("CheckSignature_tmpStr:: " + tmpStr);
            SHA1 sha;
            string hash = "";
            try
            {
                Common.Plugin.LogHelper.Write("CheckSignature_hash:: 11");
                sha = new SHA1CryptoServiceProvider();
                Common.Plugin.LogHelper.Write("CheckSignature_hash:: 22");
                byte[] dataToHash = Encoding.UTF8.GetBytes(tmpStr);
                Common.Plugin.LogHelper.Write("CheckSignature_hash:: 33");
                byte[] dataHashed = sha.ComputeHash(dataToHash);
                Common.Plugin.LogHelper.Write("CheckSignature_hash:: 44");
                hash = BitConverter.ToString(dataHashed).Replace("-", "");
                Common.Plugin.LogHelper.Write("CheckSignature_hash:: 55");
                hash = hash.ToLower();
            }
            catch (Exception ex)
            {
                Common.Plugin.LogHelper.Write(ex, "CheckSignature");
            }
            Common.Plugin.LogHelper.Write("CheckSignature_hash:: " + hash);
            Common.Plugin.LogHelper.Write("CheckSignature_signature:: " + signature);
            if (hash == signature)
            {
                return echostr;
            }
            return "";
        }

    }
}
