using System;
using System.Collections.Generic;
using System.Linq;
using System.Text.Encodings.Web;
using System.Text.Unicode;
using System.Threading.Tasks;
using Mall.ThirdCore.Message;
using Microsoft.AspNetCore.Builder;
using Microsoft.AspNetCore.Hosting;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.HttpsPolicy;
using Microsoft.AspNetCore.Mvc;
using Microsoft.Extensions.Configuration;
using Microsoft.Extensions.DependencyInjection;
using Microsoft.Extensions.Hosting;
using Microsoft.Extensions.Logging;

namespace Mall.WebApi
{
    public class Startup
    {
        public Startup(IConfiguration configuration)
        {
            Configuration = configuration;
        }

        public IConfiguration Configuration { get; }

        // This method gets called by the runtime. Use this method to add services to the container.
        public void ConfigureServices(IServiceCollection services)
        {
            //services.Configure<Microsoft.AspNetCore.Server.Kestrel.Core.KestrelServerOptions>(options =>
            //{
            //    options.AllowSynchronousIO = true;
            //});
            services.Configure<Microsoft.AspNetCore.Server.Kestrel.Core.KestrelServerOptions>(x => x.AllowSynchronousIO = true)
                .Configure<IISServerOptions>(x => x.AllowSynchronousIO = true);
            services.AddControllers();
            services.AddSingleton<IHttpContextAccessor, HttpContextAccessor>(); //עhttp
                                                                                //ע Quartz
                                                                                //services.AddSingleton<QuartzHelper>();
                                                                                //services.AddTransient<TimingHelper>();      // ʹ˲ʱע
           // services.AddSingleton<ISchedulerFactory, StdSchedulerFactory>();//עISchedulerFactoryʵ
                                                                            //
                                                                            //services.AddMvc().AddNewtonsoftJson(options =>
                                                                            //{
                                                                            //    // ѭ
                                                                            //    options.SerializerSettings.ReferenceLoopHandling = Newtonsoft.Json.ReferenceLoopHandling.Ignore;
                                                                            //    // ʹշ
                                                                            //    options.SerializerSettings.ContractResolver = new Newtonsoft.Json.Serialization.DefaultContractResolver();//jsonַСдԭ
                                                                            //    // ʱʽ
                                                                            //    options.SerializerSettings.DateFormatString = "yyyy-MM-dd HH:mm:ss";
                                                                            //    // ֶΪnullֵֶβ᷵صǰ
                                                                            //    // options.SerializerSettings.NullValueHandling = NullValueHandling.Ignore;
                                                                            //    options.SerializerSettings.Converters.
                                                                            //});
                                                                            //services.AddSingleton<IJobFactory, IOCJobFactory>();
            services.AddMvc().AddJsonOptions(options =>
            {
                options.JsonSerializerOptions.Encoder = JavaScriptEncoder.Create(UnicodeRanges.All);
                options.JsonSerializerOptions.PropertyNamingPolicy = null;
            });

            services.AddCors(options => options.AddPolicy("AllowCors", policy => policy.AllowAnyHeader().AllowAnyMethod().AllowCredentials().WithOrigins(new[]
            { "http://www.test.com:8080", "http://www.test.com:8081", "http://localhost:63342","http://localhost:59823","http://www.test.com:8082","http://activity.oytour.com","https://activity.oytour.com", "http://crmyx.oytour.com:8080","http://crmyx.oytour.com","http://fcrmyx.oytour.com", "http://yx.oytour.com","http://testerp.oytour.com:8080"})));
            //services.AddCors(options =>
            //{
            //    options.AddPolicy("AllowCors",
            //    builder =>
            //    {
            //        builder.WithOrigins("http://www.test.com:8080")
            //                            .SetIsOriginAllowedToAllowWildcardSubdomains()
            //                            .AllowAnyHeader()
            //                            .AllowAnyMethod()
            //                            .AllowCredentials(); 
            //    });
            //});
        }

        // This method gets called by the runtime. Use this method to configure the HTTP request pipeline.
        public void Configure(IApplicationBuilder app, IWebHostEnvironment env)
        {
            if (env.IsDevelopment())
            {
                app.UseDeveloperExceptionPage();
            }

            app.UseHttpsRedirection();

            app.UseRouting();
            // пcorsConfigureServicesõĿ
            app.UseCors("AllowCors");

            app.UseAuthorization();

            app.UseEndpoints(endpoints =>
            {
                endpoints.MapControllers();
            });

            System.WebHttpContext.HttpContext.Configure(app.ApplicationServices.GetRequiredService<Microsoft.AspNetCore.Http.IHttpContextAccessor>());
            //Ϣ
            Task.Run(() => MessageCore.Init());

            //ȡǰעQuartz
            //var quartz = app.ApplicationServices.GetRequiredService<QuartzHelper>();
            //appLifetime.ApplicationStarted.Register(() =>
            //{
            //    quartz.Start().Wait(); //վִ
            //});

            //appLifetime.ApplicationStopped.Register(() =>
            //{
            //    quartz.Stop();  //վִֹͣ

            //});
            //app.UseStaticFiles(new StaticFileOptions
            //{
            //    FileProvider = new Microsoft.Extensions.FileProviders.PhysicalFileProvider(
            //    Path.Combine(Directory.GetCurrentDirectory(), "ExportFile")),
            //    RequestPath = "/ExportFile"
            //});
        }
    }
}
