﻿using VT.FW.DB;
using Mall.Common.Enum.User;
using System;
using System.Collections.Generic;
using System.Text;

namespace Mall.Model.Entity.Product
{
    /// <summary>
    /// 商品关联规格值表实体
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_Goods_SpecificationValue
    {

        /// <summary>
        /// Id
        /// </summary>        
        public int Id
        {
            get;
            set;
        }
        /// <summary>
        /// GoodsId
        /// </summary>        
        public int? GoodsId
        {
            get;
            set;
        }
        /// <summary>
        /// 规格id
        /// </summary>        
        public int? SpecificationId
        {
            get;
            set;
        }
        /// <summary>
        /// 规格值名称
        /// </summary>        
        public string Name
        {
            get;
            set;
        }
        /// <summary>
        /// 规格图片
        /// </summary>        
        public string Image
        {
            get;
            set;
        }
        /// <summary>
        /// 排序  不能重复  用于价格绑定Key
        /// </summary>        
        public int? Sort
        {
            get;
            set;
        }
        /// <summary>
        /// Status
        /// </summary>        
        public int? Status
        {
            get;
            set;
        }
        /// <summary>
        /// 商户号
        /// </summary>        
        public int TenantId
        {
            get;
            set;
        }
        /// <summary>
        /// 小程序id
        /// </summary>        
        public int MallBaseId
        {
            get;
            set;
        }
        /// <summary>
        /// CreateDate
        /// </summary>        
        public DateTime? CreateDate
        {
            get;
            set;
        }

        /// <summary>
        /// 班级id
        /// </summary>
        public int ClassId { get; set; }
    }
}
