﻿using Mall.Common.Enum;
using Mall.Model.Entity.TradePavilion;
using Mall.Model.Extend.TradePavilion;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using VT.FW.DB.Dapper;

namespace Mall.Repository.TradePavilion
{
    /// <summary>
    /// 商会活动报名仓储层
    /// </summary>
    public class RB_Commerce_ConsultRepository : BaseRepository<RB_Commerce_Consult>
    {
        /// <summary>
        /// 获取商会活动报名统计分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="rowsCount"></param>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Commerce_Consult_Extend> GetCommerceConsultStatisticsPageRepository(int pageIndex, int pageSize, out long rowsCount, RB_Commerce_Consult_Extend query)
        {
            rowsCount = 0;
            DynamicParameters parameters = new DynamicParameters();
            StringBuilder builder = new StringBuilder();
            builder.AppendFormat(@"
SELECT ActivityId,UserId,Count(1) AS UserCount 
FROM RB_Commerce_Consult
WHERE 1=1

");
            if (query == null)
            {
                return new List<RB_Commerce_Consult_Extend>();
            }
            else
            {
                if (query.EnrollState > 0)
                {
                    if (query.EnrollState == 1)
                    {
                        builder.AppendFormat(" AND {0}={1} ", nameof(RB_Commerce_Consult_Extend.Status), (int)DateStateEnum.Normal);
                    }
                    else if (query.EnrollState == 2)
                    {
                        builder.AppendFormat(" AND {0}={1} ", nameof(RB_Commerce_Consult_Extend.Status), (int)DateStateEnum.Delete);
                    }
                }
                else
                {
                    builder.AppendFormat(" AND {0}={1} ", nameof(RB_Commerce_Consult_Extend.Status), (int)DateStateEnum.Normal);
                }
                if (query.TenantId > 0)
                {
                    builder.AppendFormat(" AND {0}={1} ", nameof(RB_Commerce_Consult_Extend.TenantId), query.TenantId);
                }
                if (query.MallBaseId > 0)
                {
                    builder.AppendFormat(" AND {0}={1} ", nameof(RB_Commerce_Consult_Extend.MallBaseId), query.MallBaseId);
                }
                if (!string.IsNullOrEmpty(query.LinkMan))
                {
                    builder.AppendFormat(" AND {0} LIKE @Name ", nameof(RB_Commerce_Consult_Extend.LinkMan));
                    parameters.Add("Name", "%" + query.LinkMan.Trim() + "%");
                }
                if (query.ActivityId > 0)
                {
                    builder.AppendFormat(" AND {0}={1} ", nameof(RB_Commerce_Consult_Extend.ActivityId), query.ActivityId);
                }
                if (!string.IsNullOrEmpty(query.QActivityIds))
                {
                    builder.AppendFormat(" AND {0} IN({1}) ", nameof(RB_Commerce_Consult_Extend.ActivityId), query.QActivityIds);
                }
                if (!string.IsNullOrEmpty(query.QUserIds))
                {
                    builder.AppendFormat(" AND {0} IN({1}) ", nameof(RB_Commerce_Consult_Extend.UserId), query.QUserIds);
                }
                if (query.UserId > 0)
                {
                    builder.AppendFormat(" AND {0}={1} ", nameof(RB_Commerce_Consult_Extend.UserId), query.UserId);
                }
            }
            builder.Append(" GROUP  BY ActivityId,UserId ");
            return GetPage<RB_Commerce_Consult_Extend>(pageIndex, pageSize, out rowsCount, builder.ToString(), parameters).ToList();
        }


        /// <summary>
        /// 获取商会活动报名列表
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Commerce_Consult_Extend> GetCommerceConsultListRepository(RB_Commerce_Consult_Extend query)
        {
            DynamicParameters parameters = new DynamicParameters();
            StringBuilder builder = new StringBuilder();
            builder.AppendFormat(@"
SELECT * 
FROM RB_Commerce_Consult
WHERE 1=1
");
            if (query == null)
            {
                return new List<RB_Commerce_Consult_Extend>();
            }
            else
            {
                if (query.EnrollState > 0)
                {
                    if (query.EnrollState == 1)
                    {
                        builder.AppendFormat(" AND {0}={1} ", nameof(RB_Commerce_Consult_Extend.Status), (int)DateStateEnum.Normal);
                    }
                    else if (query.EnrollState == 2) {
                        builder.AppendFormat(" AND {0}={1} ", nameof(RB_Commerce_Consult_Extend.Status), (int)DateStateEnum.Delete);
                    }
                }
                else
                {
                    builder.AppendFormat(" AND {0}={1} ", nameof(RB_Commerce_Consult_Extend.Status), (int)DateStateEnum.Normal);
                }
                if (query.TenantId > 0)
                {
                    builder.AppendFormat(" AND {0}={1} ", nameof(RB_Commerce_Consult_Extend.TenantId), query.TenantId);
                }
                if (query.MallBaseId > 0)
                {
                    builder.AppendFormat(" AND {0}={1} ", nameof(RB_Commerce_Consult_Extend.MallBaseId), query.MallBaseId);
                }
                if (!string.IsNullOrEmpty(query.LinkMan))
                {
                    builder.AppendFormat(" AND {0} LIKE @Name ", nameof(RB_Commerce_Consult_Extend.LinkMan));
                    parameters.Add("Name", "%" + query.LinkMan.Trim() + "%");
                }
                if (query.ActivityId > 0)
                {
                    builder.AppendFormat(" AND {0}={1} ", nameof(RB_Commerce_Consult_Extend.ActivityId), query.ActivityId);
                }
                if (!string.IsNullOrEmpty(query.QActivityIds))
                {
                    builder.AppendFormat(" AND {0} IN({1}) ", nameof(RB_Commerce_Consult_Extend.ActivityId), query.QActivityIds);
                }
                if (!string.IsNullOrEmpty(query.QUserIds))
                {
                    builder.AppendFormat(" AND {0} IN({1}) ", nameof(RB_Commerce_Consult_Extend.UserId), query.QUserIds);
                }
                if (query.UserId > 0)
                {
                    builder.AppendFormat(" AND {0}={1} ", nameof(RB_Commerce_Consult_Extend.UserId), query.UserId);
                }
            }
            return Get<RB_Commerce_Consult_Extend>(builder.ToString(), parameters).ToList();
        }

        /// <summary>
        /// 获取用户的报名列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="rowsCount"></param>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Commerce_Consult_Extend> GetUserJoinActivityPageList(int pageIndex, int pageSize, out long rowsCount, RB_Commerce_Consult_Extend query)
        {
            DynamicParameters parameters = new DynamicParameters();
            StringBuilder builder = new StringBuilder();
            builder.AppendFormat(@"
SELECT c.*,a.ActivityName,a.CoverImg,a.StartTime,a.EndTime,t.TypeName
FROM RB_Commerce_Consult c
left join rb_commerce_activity a on c.ActivityId = a.Id
left join rb_commerce_activitytype t on t.Id = a.ActivityType
WHERE 1=1
");
            if (query == null)
            {
                rowsCount = 0;
                return new List<RB_Commerce_Consult_Extend>();
            }
            else
            {
                if (query.EnrollState > 0)
                {
                    if (query.EnrollState == 1)
                    {
                        builder.AppendFormat(" AND c.{0}={1} ", nameof(RB_Commerce_Consult_Extend.Status), (int)DateStateEnum.Normal);
                    }
                    else if (query.EnrollState == 2)
                    {
                        builder.AppendFormat(" AND c.{0}={1} ", nameof(RB_Commerce_Consult_Extend.Status), (int)DateStateEnum.Delete);
                    }
                }
                else
                {
                    builder.AppendFormat(" AND c.{0}={1} ", nameof(RB_Commerce_Consult_Extend.Status), (int)DateStateEnum.Normal);
                }
                if (query.TenantId > 0)
                {
                    builder.AppendFormat(" AND c.{0}={1} ", nameof(RB_Commerce_Consult_Extend.TenantId), query.TenantId);
                }
                if (query.MallBaseId > 0)
                {
                    builder.AppendFormat(" AND c.{0}={1} ", nameof(RB_Commerce_Consult_Extend.MallBaseId), query.MallBaseId);
                }
                if (!string.IsNullOrEmpty(query.LinkMan))
                {
                    builder.AppendFormat(" AND c.{0} LIKE @Name ", nameof(RB_Commerce_Consult_Extend.LinkMan));
                    parameters.Add("Name", "%" + query.LinkMan.Trim() + "%");
                }
                if (query.ActivityId > 0)
                {
                    builder.AppendFormat(" AND c.{0}={1} ", nameof(RB_Commerce_Consult_Extend.ActivityId), query.ActivityId);
                }
                if (!string.IsNullOrEmpty(query.QActivityIds))
                {
                    builder.AppendFormat(" AND c.{0} IN({1}) ", nameof(RB_Commerce_Consult_Extend.ActivityId), query.QActivityIds);
                }
                if (!string.IsNullOrEmpty(query.QUserIds))
                {
                    builder.AppendFormat(" AND c.{0} IN({1}) ", nameof(RB_Commerce_Consult_Extend.UserId), query.QUserIds);
                }
                if (query.UserId > 0)
                {
                    builder.AppendFormat(" AND c.{0}={1} ", nameof(RB_Commerce_Consult_Extend.UserId), query.UserId);
                }
            }
            builder.AppendFormat(" order by c.Id desc");
            return GetPage<RB_Commerce_Consult_Extend>(pageIndex, pageSize, out rowsCount, builder.ToString(), parameters).ToList();
        }
    }
}
