﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Mall.CacheManager.User;
using Mall.Common;
using Mall.Common.API;
using Mall.Common.Enum.Goods;
using Mall.Common.Enum.User;
using Mall.Common.Plugin;
using Mall.Model.Extend.TradePavilion;
using Mall.Module.TradePavilion;
using Mall.WebApi.Filter;
using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Cors;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Newtonsoft.Json;
using Newtonsoft.Json.Linq;

namespace Mall.WebApi.Controllers.TradePavilion
{
    [Route("api/[controller]/[action]")]
    [ApiExceptionFilter]
    [ApiController]
    [EnableCors("AllowCors")]
    public class AppletCustomFormController : BaseController
    {
        /// <summary>
        /// 自定义表单处理类对象
        /// </summary>
        private readonly CustomFormModule customFormModule = new CustomFormModule();

        /// <summary>
        /// 根据类型编号获取自定义榜单表单
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetCustomForm()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var query = new RB_Custom_Form_Extend();
            int formType = parms.GetInt("FormType");
            if (formType <= 0)
            {
                return ApiResult.ParamIsNull(message: "请传递表单类型!");
            }
            else
            {
                query.FormType = (Common.Enum.TradePavilion.CustomFormTypeEnum)formType;
            }
            var userInfo = AppletUserInfo;
            query.MallBaseId = userInfo.MallBaseId;
            query.TenantId = userInfo.TenantId;
            var model = customFormModule.AppGetCustomFormModule(query);
            return ApiResult.Success(data: model);
        }

        /// <summary>
        /// 根据表单编号获取表单详情
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetCustomFormInfo()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var Id = parms.GetInt("Id");
            var model = customFormModule.GetCustomFormModule(Id);
            return ApiResult.Success(data: model);
        }
    }
}

