﻿using Mall.Common.AOP;
using Mall.Common.Enum.MarketingCenter;
using System;
using System.Collections.Generic;
using System.Text;

namespace Mall.Model.Entity.User
{
    /// <summary>
    /// 会员优惠券实体
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_Member_DiscountCoupon

    {
        /// <summary>
        /// Id
        /// </summary>        
        public int Id
        {
            get;
            set;
        }
        /// <summary>
        /// 用户id
        /// </summary>
        public int? UserId { get; set; }


        /// <summary>
        /// 描述
        /// </summary>        
        public string Description
        {
            get;
            set;
        }
        /// <summary>
        /// 领取时间
        /// </summary>        
        public DateTime? CreateDate
        {
            get;
            set;
        }
        /// <summary>
        /// 商户号id
        /// </summary>        
        public int TenantId
        {
            get;
            set;
        }
        /// <summary>
        /// 小程序id
        /// </summary>        
        public int MallBaseId
        {
            get;
            set;
        }

        /// <summary>
        /// 备注
        /// </summary>
        public string Remarks { get; set; }




        /// <summary>
        /// 使用状态 0-未使用，1:已使用，2:已作废
        /// </summary>
        public int UseState { get; set; }




        /// <summary>
        /// 优惠券id
        /// </summary>
        public int CouponId { get; set; }

        /// <summary>
        /// 使用时间
        /// </summary>
        public DateTime? UseDate { get; set; }

        /// <summary>
        /// 订单号
        /// </summary>
        public int OrderId { get; set; }

        /// <summary>
        /// 开始时间
        /// </summary>
        public DateTime? StartDate { get; set; }



        public DateTime? EndDate { get; set; }


        /// <summary>
        /// 领取方式0-自行领取（领劵中心领取），1-分享，2-购买并付款，3-新人领取
        /// </summary>
        public new int GetType { get; set; }


        /// <summary>
        /// 1-满减券，2-打折券
        /// </summary>
        public CouponTypeEnum CouponType { get; set; }


        /// <summary>
        /// 1-指定商品类型，2-指定商品，3-全场通用，4-当面付
        /// </summary>
        public UseTypeEnum UseType { get; set; }


        /// <summary>
        /// 删除
        /// </summary>
        public int Status { get; set; }
        /// <summary>
        /// 最低消费金额（元）
        /// </summary>
        public decimal MinConsumePrice { get; set; }


        /// <summary>
        /// 优惠金额/折扣
        /// </summary>
        public decimal DiscountsPrice { get; set; }


        /// <summary>
        ///最多优惠（元）
        /// </summary>
        public decimal MaxDiscountsPrice { get; set; }

        /// <summary>
        /// 优惠券名称
        /// </summary>
        public string Name { get; set; }


    }
}
