﻿using Mall.Common.AOP;
using System;
using System.Collections.Generic;
using System.Text;
using Mall.Model.Entity.Product;

namespace Mall.Model.Extend.Product
{
    /// <summary>
    /// 商品分类表扩展实体
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_Product_Category_Extend : RB_Product_Category
    {
        /// <summary>
        /// 分类ids
        /// </summary>
        public string CategoryIds { get; set; }
        /// <summary>
        /// 分类图标
        /// </summary>        
        public string IconPath
        {
            get;
            set;
        }
        /// <summary>
        /// 分类大图
        /// </summary>        
        public string BigIconPath
        {
            get;
            set;
        }
        /// <summary>
        /// 分类广告图
        /// </summary>        
        public string AdvertisingImagePath
        {
            get;
            set;
        }
        /// <summary>
        /// 上1级名称
        /// </summary>
        public string Parent1Name { get; set; }
        /// <summary>
        /// 上2级名称
        /// </summary>
        public string Parent2Name { get; set; }
    }

    /// <summary>
    /// 树形结构
    /// </summary>
    public class RB_Product_CategoryTree { 
        /// <summary>
        /// id
        /// </summary>
        public int Id { get; set; }
        /// <summary>
        /// 分类名称
        /// </summary>
        public string Name { get; set; }
        /// <summary>
        /// 分类图标
        /// </summary>
        public int Icon { get; set; }
        /// <summary>
        /// 地址
        /// </summary>
        public string IconPath { get; set; }
        /// <summary>
        /// 子集列表
        /// </summary>
        public List<RB_Product_CategoryTree> ChildList { get; set; }
    }
    /// <summary>
    /// 分类排序
    /// </summary>
    public class RB_Product_CategorySort { 
        /// <summary>
        /// id
        /// </summary>
        public int Id { get; set; }
        /// <summary>
        /// 排序
        /// </summary>
        public int Sort { get; set; }
    }
}
