﻿using System;
using System.Collections.Generic;
using System.Text;
using Mall.Model.Entity.User;
using Mall.Model.Extend.User;
using System.Linq;

namespace Mall.Repository.User
{
    /// <summary>
    /// vip购买返佣仓储层
    /// </summary>
    public class RB_VipBuy_CommissionRepository : RepositoryBase<RB_VipBuy_Commission>
    {
        /// <summary>
        /// 分页列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="dmodel">查询条件</param>
        /// <returns></returns>
        public List<RB_VipBuy_Commission_Extend> GetPageList(int pageIndex, int pageSize, out long rowCount, RB_VipBuy_Commission_Extend dmodel)
        {
            string where = " 1=1";
            if (dmodel.TenantId > 0)
            {
                where += $@" and v.{nameof(RB_VipBuy_Commission.TenantId)}={dmodel.TenantId}";
            }
            if (dmodel.MallBaseId > 0)
            {
                where += $@" and v.{nameof(RB_VipBuy_Commission.MallBaseId)}={dmodel.MallBaseId}";
            }
            if (dmodel.Id > 0)
            {
                where += $@" and v.{nameof(RB_VipBuy_Commission.Id)}={dmodel.Id}";
            }
            if (dmodel.UserId > 0)
            {
                where += $@" and v.{nameof(RB_VipBuy_Commission.UserId)}={dmodel.UserId}";
            }
            if (dmodel.Type > 0) 
            {
                where += $@" and v.{nameof(RB_VipBuy_Commission.Type)}={dmodel.Type}";
            }
            if (!string.IsNullOrEmpty(dmodel.UserName))
            {
                where += $@" and u.{nameof(RB_Member_User.Name)} like '%{dmodel.UserName}%'";
            }

            string sql = $@"select v.*,vb.OrderNo,vb.GradeName,u.Name as UserName,u.Photo from RB_VipBuy_Commission v
inner join rb_vip_buy vb on v.OrderId = vb.Id
inner join rb_member_user u on vb.UserId= u.Id
where {where} order by v.Id desc";
            return GetPage<RB_VipBuy_Commission_Extend>(pageIndex, pageSize, out rowCount, sql).ToList();
        }

        /// <summary>
        /// 获取列表
        /// </summary>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public List<RB_VipBuy_Commission_Extend> GetList(RB_VipBuy_Commission_Extend dmodel) {
            string where = " 1=1 and b.Status =0";
            if (dmodel.TenantId > 0)
            {
                where += $@" and b.{nameof(RB_VipBuy_Commission.TenantId)}={dmodel.TenantId}";
            }
            if (dmodel.MallBaseId > 0)
            {
                where += $@" and b.{nameof(RB_VipBuy_Commission.MallBaseId)}={dmodel.MallBaseId}";
            }
            if (dmodel.Id > 0)
            {
                where += $@" and b.{nameof(RB_VipBuy_Commission.Id)}={dmodel.Id}";
            }
            if (dmodel.OrderId > 0)
            {
                where += $@" and b.{nameof(RB_VipBuy_Commission.OrderId)}={dmodel.OrderId}";
            }

            string sql = $@"select v.* from RB_VipBuy_Commission v where {where} order by v.Id desc";
            return Get<RB_VipBuy_Commission_Extend>(sql).ToList();
        }
    }
}
