﻿using Mall.Model.Entity.MarketingCenter;
using Mall.Model.Extend.MarketingCenter;
using Mall.Repository;
using Mall.Repository.MarketingCenter;
using System;
using System.Collections.Generic;
using System.Text;

namespace Mall.Module.MarketingCenter
{
    /// <summary>
    /// 模板市场处理类
    /// </summary>
    public class TemplateMarketModule
    {
        /// <summary>
        /// 模板市场仓储层对象
        /// </summary>
        private readonly RB_Template_MarketRepository template_MarketRepository = new RB_Template_MarketRepository();

        /// <summary>
        /// 小程序模板
        /// </summary>
        private readonly RB_Miniprogram_TemplateRepository miniprogram_TemplateRepository = new RB_Miniprogram_TemplateRepository();

        /// <summary>
        /// 模板市场分页列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Template_Market_Extend> GetTemplateMarketPageListModule(int pageIndex, int pageSize, out long rowCount, RB_Template_Market_Extend query)
        {
            return template_MarketRepository.GetTemplateMarketPageListRepository(pageIndex, pageSize, out rowCount, query);
        }


        /// <summary>
        /// 模板市场列表
        /// </summary>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Template_Market_Extend> GetTemplateMarketListModule(RB_Template_Market_Extend query)
        {
            return template_MarketRepository.GetTemplateMarketListRepository(query);
        }

        /// <summary>
        /// 添加修改模板市场
        /// </summary>
        /// <param name="extModel"></param>
        /// <returns></returns>
        public bool SetTemplateMarketModule(RB_Template_Market_Extend extModel)
        {
            bool flag = false;
            if (extModel.Id > 0)
            {
                Dictionary<string, object> fileds = new Dictionary<string, object>()
                {
                    {nameof(RB_Template_Market_Extend.Name),extModel.Name.Trim() },
                    {nameof(RB_Template_Market_Extend.Pics),extModel.Pics },
                    {nameof(RB_Template_Market_Extend.Price),extModel.Price },
                    {nameof(RB_Template_Market_Extend.IsUse),extModel.IsUse },
                    {nameof(RB_Template_Market_Extend.IsShow),extModel.IsShow },
                    {nameof(RB_Template_Market_Extend.TemplateData),extModel.TemplateData },
                    {nameof(RB_Template_Market_Extend.SortNum),extModel.SortNum },
                };
                flag = template_MarketRepository.Update(fileds, new WhereHelper(nameof(RB_Template_Market_Extend.Id), extModel.Id));
            }
            else
            {
                var newId = template_MarketRepository.Insert(extModel);
                extModel.Id = newId;
                flag = newId > 0;
            }
            return flag;
        }

        /// <summary>
        /// 根据编号获取模板市场实体
        /// </summary>
        /// <param name="Id"></param>
        /// <returns></returns>
        public RB_Template_Market_Extend GetTemplateMarketModule(object Id)
        {
            return template_MarketRepository.GetEntity<RB_Template_Market_Extend>(Id);
        }

        /// <summary>
        /// 删除模板市场
        /// </summary>
        /// <param name="Id"></param>
        /// <returns></returns>
        public bool RemoveTemplateMarketModule(object Id)
        {
            bool flag = false;
            Dictionary<string, object> fileds = new Dictionary<string, object>()
            {
                {nameof(RB_Template_Market_Extend.Status),1 },
            };
            flag = template_MarketRepository.Update(fileds, new WhereHelper(nameof(RB_Template_Market_Extend.Id), Id));
            return flag;
        }

        /// <summary>
        /// 更新模板市场是否显示
        /// </summary>
        /// <param name="Id">编号</param>
        /// <param name="IsShow">是否显示(0-不显示,1-显示)</param>
        /// <returns></returns>
        public bool UpdateTemplateMarketIsShowModule(object Id,int IsShow)
        {
            bool flag = false;
            Dictionary<string, object> fileds = new Dictionary<string, object>()
            {
                {nameof(RB_Template_Market_Extend.IsShow),IsShow },
            };
            flag = template_MarketRepository.Update(fileds, new WhereHelper(nameof(RB_Template_Market_Extend.Id), Id));
            return flag;
        }

        /// <summary>
        /// 更新模板市场是否使用
        /// </summary>
        /// <param name="Id">编号</param>
        /// <param name="IsUse">是否使用(0-禁用,1-使用)</param>
        /// <returns></returns>
        public bool UpdateTemplateMarketIsUseModule(object Id, int IsUse)
        {
            bool flag = false;
            Dictionary<string, object> fileds = new Dictionary<string, object>()
            {
                {nameof(RB_Template_Market_Extend.IsUse),IsUse },
            };
            flag = template_MarketRepository.Update(fileds, new WhereHelper(nameof(RB_Template_Market_Extend.Id), Id));
            return flag;
        }

        /// <summary>
        /// 加载模板
        /// </summary>
        /// <param name="Id">模板市场编号</param>
        /// <param name="extModel">返回的模板实体</param>
        /// <returns></returns>
        public bool LoadTemplateMarketIsUseModule(object Id, RB_Miniprogram_Template_Extend extModel)
        {
            var marketModel = GetTemplateMarketModule(Id);
            if (marketModel != null && marketModel.Id > 0)
            {
                extModel.TemplateName = marketModel.Name;
                List<ComponentItem> items = new List<ComponentItem>();
                if (marketModel.TemplateData != null && !string.IsNullOrWhiteSpace(marketModel.TemplateData))
                {
                    items= Common.Plugin.JsonHelper.DeserializeObject<List<ComponentItem>>(marketModel.TemplateData.Replace("\r\n","").Trim());
                }
                extModel.TemplateData = Common.Plugin.JsonHelper.Serialize(items);
            }
            var newId = miniprogram_TemplateRepository.Insert(extModel);
            extModel.Id = newId;
            return newId > 0;
        }
    }
}
