﻿using Mall.Common.AOP;
using Mall.Common.Enum.User;
using System;
using System.Collections.Generic;
using System.Text;

namespace Mall.Model.Entity.User
{
    /// <summary>
    /// 和平分销返佣表实体
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_Distributor_HPCommission
    {

        /// <summary>
        /// Id
        /// </summary>        
        public int Id
        {
            get;
            set;
        }        
        /// <summary>
        /// 分销返佣名称
        /// </summary>        
        public string Name
        {
            get;
            set;
        }
        /// <summary>
        /// 小数类型   1取整  2保留两位小数 （向上进一）
        /// </summary>        
        public int? DecimalType
        {
            get;
            set;
        }
        /// <summary>
        /// 是否启用  1是  2否
        /// </summary>        
        public int? Enabled
        {
            get;
            set;
        }
        /// <summary>
        /// 是否通用返佣  1是  2否
        /// </summary>
        public int? IsCommon { get; set; }
        /// <summary>
        /// 删除状态
        /// </summary>
        public int? Status { get; set; }
        /// <summary>
        /// 商户号
        /// </summary>        
        public int TenantId
        {
            get;
            set;
        }
        /// <summary>
        /// 小程序id
        /// </summary>        
        public int MallBaseId
        {
            get;
            set;
        }
        /// <summary>
        /// CreateDate
        /// </summary>        
        public DateTime? CreateDate
        {
            get;
            set;
        }
        /// <summary>
        /// UpdateDate
        /// </summary>        
        public DateTime? UpdateDate
        {
            get;
            set;
        }
    }
}
