﻿using System;
using System.Collections.Generic;
using System.Text;
using Mall.Model.Entity.Product;
using Mall.Model.Extend.Product;
using System.Linq;
using Mall.Model.Entity.User;

namespace Mall.Repository.Product
{
    /// <summary>
    /// 商品代理仓储层
    /// </summary>
    public class RB_Goods_ProxyRepository : RepositoryBase<RB_Goods_Proxy>
    {

        /// <summary>
        /// 获取列表
        /// </summary>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public List<RB_Goods_Proxy_Extend> GetList(RB_Goods_Proxy_Extend dmodel)
        {
            string where = $" 1=1 and Status =0";
            if (dmodel.TenantId > 0)
            {
                where += $@" and {nameof(RB_Goods_Proxy.TenantId)}={dmodel.TenantId}";
            }
            if (dmodel.MallBaseId > 0)
            {
                where += $@" and {nameof(RB_Goods_Proxy.MallBaseId)}={dmodel.MallBaseId}";
            }
            if (dmodel.ProxyTenantId > 0)
            {
                where += $@" and {nameof(RB_Goods_Proxy.ProxyTenantId)}={dmodel.ProxyTenantId}";
            }
            if (dmodel.ProxyMallBaseId > 0)
            {
                where += $@" and {nameof(RB_Goods_Proxy.ProxyMallBaseId)}={dmodel.ProxyMallBaseId}";
            }
            if (dmodel.GoodsId > 0)
            {
                where += $@" and {nameof(RB_Goods_Proxy.GoodsId)}={dmodel.GoodsId}";
            }
            if (!string.IsNullOrEmpty(dmodel.GoodsIds)) 
            {
                where += $@" and {nameof(RB_Goods_Proxy.GoodsId)} in({dmodel.GoodsIds})";
            }
            if (dmodel.ProxyGoodsId > 0)
            {
                where += $@" and {nameof(RB_Goods_Proxy.ProxyGoodsId)}={dmodel.ProxyGoodsId}";
            }            

            string sql = $@"SELECT * FROM RB_Goods_Proxy where {where} order by Id asc";
            return Get<RB_Goods_Proxy_Extend>(sql).ToList();
        }
    }
}
