﻿using Mall.CacheManager.Base;
using Mall.CacheManager.DataStatistic;
using System;
using System.Collections.Generic;
using System.Text;

namespace Mall.CacheManager.AppletWeChat
{
    public class OrderPayReidsCache
    {
        static RedisHelper redis = new RedisHelper(DataStatistic.DataConstant.REDIS_DB2, DataStatistic.DataConstant.DATA_OrderPayId);
        /// <summary>
        /// 设置缓存
        /// </summary>
        /// <param name="value"></param>
        public static void Set(string cacheKey, string value, TimeSpan ts)
        {
            try
            {
               // TimeSpan ts = DateTime.Now.AddMinutes(10) - DateTime.Now;
                redis.StringSet(cacheKey, value, ts);
            }
            catch (Exception ex)
            {
                Common.Plugin.LogHelper.Write(ex, "DATA_OrderPayId");
            }
        }

        /// <summary>
        /// 获取缓存
        /// </summary>
        /// <returns></returns>
        public static string Get(string Key)
        {
            string cacheKey = DataConstant.DATA_OrderPayId + Key;
            try
            {
                Object obj = redis.Get(cacheKey);
                if (obj != null)
                {
                    return obj.ToString();
                }
            }
            catch (Exception ex)
            {
                //再获取一次缓存
                try
                {
                    System.Threading.Thread.Sleep(500);
                    Object obj = redis.Get(cacheKey);
                    if (obj != null)
                    {
                        return obj.ToString();
                    }

                }
                catch (Exception ex2)
                {
                    Common.Plugin.LogHelper.Write(ex2, "DATA_OrderPayId2");
                }
                Common.Plugin.LogHelper.Write(ex, "DATA_OrderPayId");
            }
            return "";
        }
    }
}
