﻿using Mall.Model.Extend.User;
using Mall.Repository.User;
using System;
using System.Collections.Generic;
using System.Text;
using VT.FW.DB;

namespace Mall.Module.User
{
    /// <summary>
    /// 拼团配置处理类
    /// </summary>
    public class GroupBuyConfigModule
    {
        /// <summary>
        /// 拼团配置仓储层对象
        /// </summary>
        private readonly RB_GroupBuyConfigRepository groupBuyConfigRepository = new RB_GroupBuyConfigRepository();

        /// <summary>
        /// 添加修改拼团配置
        /// </summary>
        /// <param name="extModel"></param>
        /// <returns></returns>
        public bool SetGroupBuyConfigModule(RB_GroupBuyConfig_Extend extModel)
        {
            bool flag = false;
            var oldEntity = GetGroupBuyConfigModule(extModel);
            extModel.GroupByConfigId = oldEntity?.GroupByConfigId ?? 0;
            if (extModel.GroupByConfigId > 0)
            {
                Dictionary<string, object> fileds = new Dictionary<string, object>()
                {
                    {nameof(RB_GroupBuyConfig_Extend.Is_Share),extModel.Is_Share },
                    {nameof(RB_GroupBuyConfig_Extend.Is_Territorial_Limitation),extModel.Is_Territorial_Limitation },
                    {nameof(RB_GroupBuyConfig_Extend.Payment_Type),extModel.Payment_Type },
                    {nameof(RB_GroupBuyConfig_Extend.Send_Type),extModel.Send_Type },
                    {nameof(RB_GroupBuyConfig_Extend.Is_Coupon),extModel.Is_Coupon },
                    {nameof(RB_GroupBuyConfig_Extend.SVIP_Status),extModel.SVIP_Status },
                    {nameof(RB_GroupBuyConfig_Extend.Is_Member_Price),extModel.Is_Member_Price },
                    {nameof(RB_GroupBuyConfig_Extend.Is_Integral),extModel.Is_Integral },
                    {nameof(RB_GroupBuyConfig_Extend.RuleText),extModel.RuleText },
                    //{nameof(RB_GroupBuyConfig_Extend.Goods_Poster),extModel.Goods_Poster },
                    //{nameof(RB_GroupBuyConfig_Extend.Advertisement),extModel.Advertisement },
                    {nameof(RB_GroupBuyConfig_Extend.Is_Advertisement),extModel.Is_Advertisement },
                };
                flag = groupBuyConfigRepository.Update(fileds, new WhereHelper(nameof(RB_GroupBuyConfig_Extend.GroupByConfigId), extModel.GroupByConfigId));
            }
            else
            {
                var newId = groupBuyConfigRepository.Insert(extModel);
                extModel.GroupByConfigId = newId;
                flag = newId > 0;
            }
            return flag;
        }

        /// <summary>
        /// 新增修改消息模板
        /// </summary>
        /// <param name="extModel"></param>
        /// <returns></returns>
        public bool SetGroupBuyConfigMessageModule(RB_GroupBuyConfig_Extend extModel)
        {
            bool flag = false;
            var oldEntity = GetGroupBuyConfigModule(extModel);
            extModel.GroupByConfigId = oldEntity?.GroupByConfigId ?? 0;
            if (extModel.GroupByConfigId > 0)
            {
                Dictionary<string, object> fileds = new Dictionary<string, object>()
                {
                    {nameof(RB_GroupBuyConfig_Extend.WeChat_pintuan_success_notice),extModel.WeChat_pintuan_success_notice },
                    {nameof(RB_GroupBuyConfig_Extend.WeChat_pintuan_fail_notice),extModel.WeChat_pintuan_fail_notice },
                };
                flag = groupBuyConfigRepository.Update(fileds, new WhereHelper(nameof(RB_GroupBuyConfig_Extend.GroupByConfigId), extModel.GroupByConfigId));
            }
            else
            {
                var newId = groupBuyConfigRepository.Insert(extModel);
                extModel.GroupByConfigId = newId;
                flag = newId > 0;
            }
            return flag;
        }

        /// <summary>
        /// 获取拼团配置实体
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public RB_GroupBuyConfig_Extend GetGroupBuyConfigModule(RB_GroupBuyConfig_Extend query)
        {
            var extModel= groupBuyConfigRepository.GetGroupBuyConfigRepository(query);

            return extModel;
        }
    }
}
