﻿using System;
using System.Collections.Generic;
using System.Text;
using Mall.Model.Entity.Product;
using Mall.Model.Extend.Product;
using System.Linq;
using Mall.Model.Entity.User;

namespace Mall.Repository.Product
{
    /// <summary>
    /// 商品评论仓储层
    /// </summary>
    public class RB_Goods_CommentRepository : BaseRepository<RB_Goods_Comment>
    {

        /// <summary>
        /// 获取分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="count"></param>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public List<RB_Goods_Comment_Extend> GetPageList(int pageIndex, int pageSize, out long count, RB_Goods_Comment_Extend dmodel)
        {
            string where = $" 1=1 and c.{nameof(RB_Goods_Comment.Status)}=0 ";
            if (dmodel.TenantId > 0)
            {
                where += $@" and c.{nameof(RB_Goods_Comment.TenantId)}={dmodel.TenantId}";
            }
            if (dmodel.MallBaseId > 0)
            {
                where += $@" and c.{nameof(RB_Goods_Comment.MallBaseId)}={dmodel.MallBaseId}";
            }
            if (dmodel.Id > 0)
            {
                where += $@" and c.{nameof(RB_Goods_Comment.Id)}={dmodel.Id}";
            }
            if (dmodel.CommentGrade > 0)
            {
                where += $@" and c.{nameof(RB_Goods_Comment.CommentGrade)}={(int)dmodel.CommentGrade}";
            }
            if (dmodel.PlatformSource > 0)
            {
                where += $@" and c.{nameof(RB_Goods_Comment.PlatformSource)}={(int)dmodel.PlatformSource}";
            }
            if (!string.IsNullOrEmpty(dmodel.UserName))
            {
                where += $@" and c.{nameof(RB_Goods_Comment.UserName)} like '%{dmodel.UserName}%'";
            }
            if (!string.IsNullOrEmpty(dmodel.GoodsName))
            {
                where += $@" and g.{nameof(RB_Goods.Name)} like '%{dmodel.GoodsName}%'";
            }
            if (!string.IsNullOrEmpty(dmodel.Content))
            {
                where += $@" and c.{nameof(RB_Goods_Comment.Content)} like '%{dmodel.Content}%'";
            }

            string sql = $@"SELECT c.*,g.Name as GoodsName,g.CarouselImage FROM RB_Goods_Comment c
left join rb_goods g on c.GoodsId = g.Id
where {where} order by c.Id desc";
            return GetPage<RB_Goods_Comment_Extend>(pageIndex, pageSize, out count, sql).ToList();
        }

        /// <summary>
        /// 获取分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="count"></param>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public List<RB_Goods_Comment_Extend> GetAppletPageList(int pageIndex, int pageSize, out long count, RB_Goods_Comment_Extend dmodel)
        {
            string where = $" 1=1 and c.{nameof(RB_Goods_Comment.Status)}=0 ";
            if (dmodel.TenantId > 0)
            {
                where += $@" and c.{nameof(RB_Goods_Comment.TenantId)}={dmodel.TenantId}";
            }
            if (dmodel.MallBaseId > 0)
            {
                where += $@" and c.{nameof(RB_Goods_Comment.MallBaseId)}={dmodel.MallBaseId}";
            }
            if (dmodel.Id > 0)
            {
                where += $@" and c.{nameof(RB_Goods_Comment.Id)}={dmodel.Id}";
            }
            if (dmodel.CommentGrade > 0)
            {
                where += $@" and c.{nameof(RB_Goods_Comment.CommentGrade)}={(int)dmodel.CommentGrade}";
            }
            if (dmodel.GoodsId > 0) 
            {
                where += $@" and c.{nameof(RB_Goods_Comment.GoodsId)}={dmodel.GoodsId}";
            }
            if (dmodel.UserId > 0) 
            {
                where += $@" and c.{nameof(RB_Goods_Comment.UserId)}={dmodel.UserId}";
            }
            if (dmodel.PlatformSource > 0)
            {
                where += $@" and c.{nameof(RB_Goods_Comment.PlatformSource)}={(int)dmodel.PlatformSource}";
            }
            if (dmodel.Is_Show > 0) {
                where += $@" and c.{nameof(RB_Goods_Comment.Is_Show)}={dmodel.Is_Show}";
            }
            if (!string.IsNullOrEmpty(dmodel.UserName))
            {
                where += $@" and c.{nameof(RB_Goods_Comment.UserName)} like '%{dmodel.UserName}%'";
            }
            if (!string.IsNullOrEmpty(dmodel.Content))
            {
                where += $@" and c.{nameof(RB_Goods_Comment.Content)} like '%{dmodel.Content}%'";
            }

            string sql = $@"SELECT c.* FROM RB_Goods_Comment c where {where} order by c.Is_Top asc,c.Id desc";
            return GetPage<RB_Goods_Comment_Extend>(pageIndex, pageSize, out count, sql).ToList();
        }

        /// <summary>
        /// 获取评论数量统计
        /// </summary>
        /// <param name="goodsId"></param>
        /// <param name="tenantId"></param>
        /// <param name="mallBaseId"></param>
        /// <returns></returns>
        public List<RB_Goods_Comment_Extend> GetAppletGoodsCommentStatistics(int goodsId, int tenantId, int mallBaseId)
        {
            string where = $" 1=1 and c.{nameof(RB_Goods_Comment.Status)}=0 and c.{nameof(RB_Goods_Comment.Is_Show)}=1";
            if (tenantId > 0)
            {
                where += $@" and c.{nameof(RB_Goods_Comment.TenantId)}={tenantId}";
            }
            if (mallBaseId > 0)
            {
                where += $@" and c.{nameof(RB_Goods_Comment.MallBaseId)}={mallBaseId}";
            }
            if (goodsId > 0)
            {
                where += $@" and c.{nameof(RB_Goods_Comment.GoodsId)}={goodsId}";
            }

            string sql = $@"SELECT c.CommentGrade,COUNT(0) as CommentNum FROM RB_Goods_Comment c where {where} GROUP BY c.CommentGrade";
            return Get<RB_Goods_Comment_Extend>(sql).ToList();
        }
    }
}
