﻿using System;
using System.Collections.Generic;
using System.Text;
using Mall.Model.Entity.User;
using Mall.Model.Extend.User;
using System.Linq;

namespace Mall.Repository.User
{
    /// <summary>
    /// 分销商等级仓储层
    /// </summary>
    public class RB_Distributor_InfoRepository : BaseRepository<RB_Distributor_Info>
    {

        /// <summary>
        /// 分页列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="dmodel">查询条件</param>
        /// <returns></returns>
        public List<RB_Distributor_Info_Extend> GetPageList(int pageIndex, int pageSize, out long rowCount, RB_Distributor_Info_Extend dmodel)
        {
            string where = $@" 1=1 and di.{nameof(RB_Distributor_Info.Status)}=0";
            if (dmodel.TenantId > 0)
            {
                where += $@" and di.{nameof(RB_Distributor_Info.TenantId)}={dmodel.TenantId}";
            }
            if (dmodel.MallBaseId > 0)
            {
                where += $@" and di.{nameof(RB_Distributor_Info.MallBaseId)}={dmodel.MallBaseId}";
            }
            if (dmodel.UserId > 0)
            {
                where += $@" and di.{nameof(RB_Distributor_Info.UserId)}={dmodel.UserId}";
            }
            if (dmodel.AuditStatus > 0)
            {
                where += $@" and di.{nameof(RB_Distributor_Info.AuditStatus)}={(int)dmodel.AuditStatus}";
            }
            if (dmodel.GradeId >= 0)
            {
                where += $@" and di.{nameof(RB_Distributor_Info.GradeId)}={dmodel.GradeId}";
            }
            if (!string.IsNullOrEmpty(dmodel.Name))
            {
                where += $@" and di.{nameof(RB_Distributor_Info.Name)} like '%{dmodel.Name}%'";
            }
            if (dmodel.Source > 0)
            {
                where += $@" and u.{nameof(RB_Member_User.Source)}={(int)dmodel.Source}";
            }
            if (!string.IsNullOrEmpty(dmodel.NickName))
            {
                where += $@" and u.{nameof(RB_Member_User.Name)} like '%{dmodel.NickName}%'";
            }
            if (!string.IsNullOrEmpty(dmodel.Mobile))
            {
                where += $@" and di.{nameof(RB_Distributor_Info.Mobile)} like '%{dmodel.Mobile}%'";
            }
            if (dmodel.SuperiorId > 0)
            {
                where += $@" and u.{nameof(RB_Member_User.SuperiorId)}={dmodel.SuperiorId}";
            }

            string sql = $@"select di.*,u.Name as NickName,u.SuperiorId,u.Photo,u.Source from RB_Distributor_Info di
inner join rb_member_user u on di.UserId=u.Id
where {where} order by di.CreateDate desc";
            return GetPage<RB_Distributor_Info_Extend>(pageIndex, pageSize, out rowCount, sql).ToList();
        }

        /// <summary>
        /// 获取列表
        /// </summary>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public List<RB_Distributor_Info_Extend> GetList(RB_Distributor_Info_Extend dmodel)
        {
            string where = $@" 1=1 and di.{nameof(RB_Distributor_Info.Status)}=0";
            if (dmodel.TenantId > 0)
            {
                where += $@" and di.{nameof(RB_Distributor_Info.TenantId)}={dmodel.TenantId}";
            }
            if (dmodel.MallBaseId > 0)
            {
                where += $@" and di.{nameof(RB_Distributor_Info.MallBaseId)}={dmodel.MallBaseId}";
            }
            if (dmodel.UserId > 0)
            {
                where += $@" and di.{nameof(RB_Distributor_Info.UserId)}={dmodel.UserId}";
            }
            if (dmodel.AuditStatus > 0)
            {
                where += $@" and di.{nameof(RB_Distributor_Info.AuditStatus)}={(int)dmodel.AuditStatus}";
            }
            if (!string.IsNullOrEmpty(dmodel.UserIds))
            {
                where += $@" and di.{nameof(RB_Distributor_Info.UserId)} in({dmodel.UserIds})";
            }
            if (dmodel.GradeId >= 0)
            {
                where += $@" and di.{nameof(RB_Distributor_Info.GradeId)}={dmodel.GradeId}";
            }
            if (!string.IsNullOrEmpty(dmodel.Name))
            {
                where += $@" and di.{nameof(RB_Distributor_Info.Name)} like '%{dmodel.Name}%'";
            }

            string sql = $@"select di.*,mu.OpenId,mu.Name as MemberUserName from RB_Distributor_Info di LEFT JOIN rb_member_user as mu on di.UserId=mu.Id where {where} order by di.CreateDate desc";
            return Get<RB_Distributor_Info_Extend>(sql).ToList();
        }

        /// <summary>
        /// 获取列表
        /// </summary>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public List<RB_Distributor_Info_Extend> GetListForSingle(RB_Distributor_Info_Extend dmodel)
        {
            string where = $@" 1=1 and di.{nameof(RB_Distributor_Info.Status)}=0";
            if (dmodel.TenantId > 0)
            {
                where += $@" and di.{nameof(RB_Distributor_Info.TenantId)}={dmodel.TenantId}";
            }
            if (dmodel.MallBaseId > 0)
            {
                where += $@" and di.{nameof(RB_Distributor_Info.MallBaseId)}={dmodel.MallBaseId}";
            }
            if (dmodel.UserId > 0)
            {
                where += $@" and di.{nameof(RB_Distributor_Info.UserId)}={dmodel.UserId}";
            }
            if (dmodel.AuditStatus > 0)
            {
                where += $@" and di.{nameof(RB_Distributor_Info.AuditStatus)}={(int)dmodel.AuditStatus}";
            }
            if (!string.IsNullOrEmpty(dmodel.UserIds))
            {
                where += $@" and di.{nameof(RB_Distributor_Info.UserId)} in({dmodel.UserIds})";
            }
            if (dmodel.GradeId >= 0)
            {
                where += $@" and di.{nameof(RB_Distributor_Info.GradeId)}={dmodel.GradeId}";
            }
            if (!string.IsNullOrEmpty(dmodel.Name))
            {
                where += $@" and di.{nameof(RB_Distributor_Info.Name)} like '%{dmodel.Name}%'";
            }

            string sql = $@"select di.* from RB_Distributor_Info di where {where} order by di.CreateDate desc";
            return Get<RB_Distributor_Info_Extend>(sql).ToList();
        }

        /// <summary>
        /// 获取列表
        /// </summary>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public List<RB_Distributor_Info_Extend> GetFXGreadeListForMyTeam(RB_Distributor_Info_Extend dmodel)
        {
            string where = $@" 1=1 and di.{nameof(RB_Distributor_Info.Status)}=0";
            if (dmodel.TenantId > 0)
            {
                where += $@" and di.{nameof(RB_Distributor_Info.TenantId)}={dmodel.TenantId}";
            }
            if (dmodel.MallBaseId > 0)
            {
                where += $@" and di.{nameof(RB_Distributor_Info.MallBaseId)}={dmodel.MallBaseId}";
            }
            if (dmodel.UserId > 0)
            {
                where += $@" and di.{nameof(RB_Distributor_Info.UserId)}={dmodel.UserId}";
            }
            if (dmodel.AuditStatus > 0)
            {
                where += $@" and di.{nameof(RB_Distributor_Info.AuditStatus)}={(int)dmodel.AuditStatus}";
            }
            if (!string.IsNullOrEmpty(dmodel.UserIds))
            {
                where += $@" and di.{nameof(RB_Distributor_Info.UserId)} in({dmodel.UserIds})";
            }
            if (dmodel.GradeId >= 0)
            {
                where += $@" and di.{nameof(RB_Distributor_Info.GradeId)}={dmodel.GradeId}";
            }
            if (!string.IsNullOrEmpty(dmodel.Name))
            {
                where += $@" and di.{nameof(RB_Distributor_Info.Name)} like '%{dmodel.Name}%'";
            }

            string sql = $@"select di.FXGradeId from RB_Distributor_Info di where {where} group by di.FXGradeId";
            return Get<RB_Distributor_Info_Extend>(sql).ToList();
        }

        /// <summary>
        /// 获取下载列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="dmodel">查询条件</param>
        /// <returns></returns>
        public List<RB_Distributor_Info_Extend> GetToExcelList(RB_Distributor_Info_Extend dmodel)
        {
            string where = $@" 1=1 and di.{nameof(RB_Distributor_Info.Status)}=0";
            if (dmodel.TenantId > 0)
            {
                where += $@" and di.{nameof(RB_Distributor_Info.TenantId)}={dmodel.TenantId}";
            }
            if (dmodel.MallBaseId > 0)
            {
                where += $@" and di.{nameof(RB_Distributor_Info.MallBaseId)}={dmodel.MallBaseId}";
            }
            if (dmodel.UserId > 0)
            {
                where += $@" and di.{nameof(RB_Distributor_Info.UserId)}={dmodel.UserId}";
            }
            if (dmodel.AuditStatus > 0)
            {
                where += $@" and di.{nameof(RB_Distributor_Info.AuditStatus)}={(int)dmodel.AuditStatus}";
            }
            if (dmodel.GradeId >= 0)
            {
                where += $@" and di.{nameof(RB_Distributor_Info.GradeId)}={dmodel.GradeId}";
            }
            if (!string.IsNullOrEmpty(dmodel.Name))
            {
                where += $@" and di.{nameof(RB_Distributor_Info.Name)} like '%{dmodel.Name}%'";
            }
            if (dmodel.Source > 0)
            {
                where += $@" and u.{nameof(RB_Member_User.Source)}={dmodel.Source}";
            }
            if (!string.IsNullOrEmpty(dmodel.NickName))
            {
                where += $@" and u.{nameof(RB_Member_User.Name)} like '%{dmodel.NickName}%'";
            }
            if (!string.IsNullOrEmpty(dmodel.Mobile))
            {
                where += $@" and di.{nameof(RB_Distributor_Info.Mobile)} like '%{dmodel.Mobile}%'";
            }

            string sql = $@"select di.*,u.Name as NickName,u.Photo,u.Source,u.Moblie as Mobile,u.OrderNum from RB_Distributor_Info di
inner join rb_member_user u on di.UserId=u.Id
where {where} order by di.CreateDate desc";
            return Get<RB_Distributor_Info_Extend>(sql).ToList();
        }




        /// <summary>
        /// 获取过期的vip列表
        /// </summary>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public List<RB_Distributor_Info_Extend> GetOverTimeVipList(RB_Distributor_Info_Extend dmodel)
        {
            string where = $@" 1=1 and di.{nameof(RB_Distributor_Info.Status)}=0";
            if (dmodel.TenantId > 0)
            {
                where += $@" and di.{nameof(RB_Distributor_Info.TenantId)}={dmodel.TenantId}";
            }
            if (dmodel.MallBaseId > 0)
            {
                where += $@" and di.{nameof(RB_Distributor_Info.MallBaseId)}={dmodel.MallBaseId}";
            }
            if (dmodel.UserId > 0)
            {
                where += $@" and di.{nameof(RB_Distributor_Info.UserId)}={dmodel.UserId}";
            }
            if (dmodel.AuditStatus > 0)
            {
                where += $@" and di.{nameof(RB_Distributor_Info.AuditStatus)}={(int)dmodel.AuditStatus}";
            }
            if (!string.IsNullOrEmpty(dmodel.UserIds))
            {
                where += $@" and di.{nameof(RB_Distributor_Info.UserId)} in({dmodel.UserIds})";
            }
            if (dmodel.FXGradeId >= 0)
            {
                where += $@" and di.{nameof(RB_Distributor_Info.FXGradeId)}={dmodel.FXGradeId}";
            }
            if (!string.IsNullOrEmpty(dmodel.Name))
            {
                where += $@" and di.{nameof(RB_Distributor_Info.Name)} like '%{dmodel.Name}%'";
            }
            if (dmodel.IsSelectOverTime > 0)
            {
                where += $@" and DATE_FORMAT( di.{nameof(RB_Distributor_Info.VipExpiryDate)},'%y-%m-%d')<=DATE_FORMAT( '{DateTime.Now.AddDays(-1)}','%y-%m-%d')";
            }
            string sql = $@"select di.* from RB_Distributor_Info di  where {where} order by di.CreateDate desc";
            return Get<RB_Distributor_Info_Extend>(sql).ToList();
        }
    }
}
