﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Mall.Common.API;
using Mall.Model.Extend.User;
using Mall.Module.User;
using Mall.WebApi.Filter;
using Microsoft.AspNetCore.Cors;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;

namespace Mall.WebApi.Controllers.Product
{
    [Route("api/[controller]/[action]")]
    [ApiExceptionFilter]
    [ApiController]
    [EnableCors("AllowCors")]
    public class GroupBuyController : BaseController
    {
        /// <summary>
        /// 拼团配置处理类对象
        /// </summary>
        private readonly GroupBuyConfigModule groupBuyConfigModule = new GroupBuyConfigModule();

        /// <summary>
        /// 添加修改拼团配置
        /// </summary>
        /// <returns></returns>
        public ApiResult SetGroupBuyConfig()
        {
            var extModel = Common.Plugin.JsonHelper.DeserializeObject<RB_GroupBuyConfig_Extend>(RequestParm.msg.ToString());
            extModel.MallBaseId = RequestParm.MallBaseId;
            extModel.TenantId = RequestParm.TenantId;
            if (extModel.Payment_TypeList != null && extModel.Payment_TypeList.Count > 0)
            {
                extModel.Payment_Type = Common.Plugin.JsonHelper.Serialize(extModel.Payment_TypeList);
            }
            if (extModel.Send_TypeList != null && extModel.Send_TypeList.Count > 0)
            {
                extModel.Send_Type = Common.Plugin.JsonHelper.Serialize(extModel.Send_TypeList);
            }
            var flag = groupBuyConfigModule.SetGroupBuyConfigModule(extModel);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }

        /// <summary>
        /// 添加修改拼团消息配置
        /// </summary>
        /// <returns></returns>
        public ApiResult SetGroupBuyConfigMessage()
        {
            var extModel = Common.Plugin.JsonHelper.DeserializeObject<RB_GroupBuyConfig_Extend>(RequestParm.msg.ToString());
            extModel.MallBaseId = RequestParm.MallBaseId;
            extModel.TenantId = RequestParm.TenantId;
            var flag = groupBuyConfigModule.SetGroupBuyConfigMessageModule(extModel);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }

        /// <summary>
        /// 获取拼团配置实体
        /// </summary>
        /// <returns></returns>
        public ApiResult GetGroupBuyConfigModule()
        {
            var query = Common.Plugin.JsonHelper.DeserializeObject<RB_GroupBuyConfig_Extend>(RequestParm.msg.ToString());
            query.MallBaseId = RequestParm.MallBaseId;
            query.TenantId = RequestParm.TenantId;
            var extModel = groupBuyConfigModule.GetGroupBuyConfigModule(query);
            return ApiResult.Success(data: extModel);
        }
    }
}