﻿using System;
using System.Collections.Generic;
using System.Text;
using Mall.Model.Entity.User;
using Mall.Model.Extend.User;
using System.Linq;

namespace Mall.Repository.User
{
    /// <summary>
    /// 用户收货地址仓储层
    /// </summary>
    public class RB_Member_ShippingAddressRepository : BaseRepository<RB_Member_ShippingAddress>
    {

        /// <summary>
        /// 分页列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="dmodel">查询条件</param>
        /// <returns></returns>
        public List<RB_Member_ShippingAddress_Extend> GetPageList(int pageIndex, int pageSize, out long rowCount, RB_Member_ShippingAddress_Extend dmodel)
        {
            string where = $" 1=1 and {nameof(RB_Member_ShippingAddress.Status)}=0 ";
            if (dmodel.TenantId > 0) {
                where += $@" and {nameof(RB_Member_ShippingAddress.TenantId)}={dmodel.TenantId}";
            }
            if (dmodel.MallBaseId > 0)
            {
                where += $@" and {nameof(RB_Member_ShippingAddress.MallBaseId)}={dmodel.MallBaseId}";
            }
            if (dmodel.IsDefault > 0) {
                where += $@" and {nameof(RB_Member_ShippingAddress.IsDefault)} ={(int)dmodel.IsDefault}";
            }
            if (!string.IsNullOrEmpty(dmodel.Name)) {
                where += $@" and {nameof(RB_Member_ShippingAddress.Name)} like '%{dmodel.Name}%'";
            }
            if (!string.IsNullOrEmpty(dmodel.Mobile)) {
                where += $@" and {nameof(RB_Member_ShippingAddress.Mobile)} like '%{dmodel.Mobile}%'";
            }
            if (dmodel.UserId > 0) {
                where += $@" and {nameof(RB_Member_ShippingAddress.UserId)} ={(int)dmodel.UserId}";
            }
            string sql = $@"select * from RB_Member_ShippingAddress where {where} order by IsDefault asc,UpdateDate desc";
            return GetPage<RB_Member_ShippingAddress_Extend>(pageIndex, pageSize, out rowCount, sql).ToList();
        }

        /// <summary>
        /// 获取列表
        /// </summary>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public List<RB_Member_ShippingAddress_Extend> GetList(RB_Member_ShippingAddress_Extend dmodel)
        {
            string where = $" 1=1 and {nameof(RB_Member_ShippingAddress.Status)}=0 ";
            if (dmodel.TenantId > 0)
            {
                where += $@" and {nameof(RB_Member_ShippingAddress.TenantId)}={dmodel.TenantId}";
            }
            if (dmodel.MallBaseId > 0)
            {
                where += $@" and {nameof(RB_Member_ShippingAddress.MallBaseId)}={dmodel.MallBaseId}";
            }
            if (dmodel.IsDefault > 0)
            {
                where += $@" and {nameof(RB_Member_ShippingAddress.IsDefault)} ={(int)dmodel.IsDefault}";
            }
            if (!string.IsNullOrEmpty(dmodel.Name))
            {
                where += $@" and {nameof(RB_Member_ShippingAddress.Name)} like '%{dmodel.Name}%'";
            }
            if (!string.IsNullOrEmpty(dmodel.Mobile))
            {
                where += $@" and {nameof(RB_Member_ShippingAddress.Mobile)} like '%{dmodel.Mobile}%'";
            }
            if (dmodel.UserId > 0)
            {
                where += $@" and {nameof(RB_Member_ShippingAddress.UserId)} ={(int)dmodel.UserId}";
            }
            string sql = $@"select * from RB_Member_ShippingAddress where {where} order by IsDefault asc,UpdateDate desc";
            return Get<RB_Member_ShippingAddress_Extend>(sql).ToList();
        }
    }
}
