﻿using System;
using System.Collections.Generic;
using System.Text;
using Mall.Model.Entity.Product;
using Mall.Model.Extend.Product;
using System.Linq;

namespace Mall.Repository.Product
{
    /// <summary>
    /// 素材管理仓储层
    /// </summary>
    public class RB_Material_InfoRepository : RepositoryBase<RB_Material_Info>
    {

        /// <summary>
        /// 分页列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="dmodel">查询条件</param>
        /// <returns></returns>
        public List<RB_Material_Info_Extend> GetPageList(int pageIndex, int pageSize, out long rowCount, RB_Material_Info_Extend dmodel)
        {
            string where = $" 1=1 and Id>100 and {nameof(RB_Material_Info.Status)}=0";
            if (dmodel.Id >= 100)
            {
                if (dmodel.TenantId > 0)
                {
                    where += $@" and {nameof(RB_Material_Info.TenantId)}={dmodel.TenantId}";
                }
                if (dmodel.MallBaseId > 0)
                {
                    where += $@" and {nameof(RB_Material_Info.MallBaseId)}={dmodel.MallBaseId}";
                }
            }
            if (dmodel.Id > 0) {
                where += $@" and {nameof(RB_Material_Info.Id)}={dmodel.Id}";
            }
            if (!string.IsNullOrEmpty(dmodel.Name)) {
                where += $@" and {nameof(RB_Material_Info.Name)} like '%{dmodel.Name}%'";
            }
            if (dmodel.Type > 0) {
                where += $@" and {nameof(RB_Material_Info.Type)}={dmodel.Type}";
            }
            if (dmodel.GroupId > 0) {
                where += $@" and {nameof(RB_Material_Info.GroupId)}={dmodel.GroupId}";
            }
            if (dmodel.Recycled > 0)
            {
                where += $@" and {nameof(RB_Material_Info.Recycled)}={dmodel.Recycled}";
            }

            string sql = $@"select * from RB_Material_Info where {where} order by Id desc";
            return GetPage<RB_Material_Info_Extend>(pageIndex, pageSize, out rowCount, sql).ToList();
        }

        /// <summary>
        /// 获取列表
        /// </summary>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public List<RB_Material_Info_Extend> GetList(RB_Material_Info_Extend dmodel)
        {
            string where = $" 1=1 and {nameof(RB_Material_Info.Status)}=0";
            if (dmodel.TenantId > 0)
            {
                where += $@" and {nameof(RB_Material_Info.TenantId)}={dmodel.TenantId}";
            }
            if (dmodel.MallBaseId > 0)
            {
                where += $@" and {nameof(RB_Material_Info.MallBaseId)}={dmodel.MallBaseId}";
            }
            if (dmodel.Id > 0)
            {
                where += $@" and {nameof(RB_Material_Info.Id)}={dmodel.Id}";
            }
            if (!string.IsNullOrEmpty(dmodel.MaterialIds)) 
            {
                where += $@" and {nameof(RB_Material_Info.Id)} in({dmodel.MaterialIds})";
            }
            if (!string.IsNullOrEmpty(dmodel.Name))
            {
                where += $@" and {nameof(RB_Material_Info.Name)} like '%{dmodel.Name}%'";
            }
            if (dmodel.Type > 0)
            {
                where += $@" and {nameof(RB_Material_Info.Type)}={dmodel.Type}";
            }
            if (dmodel.GroupId > 0)
            {
                where += $@" and {nameof(RB_Material_Info.GroupId)}={dmodel.GroupId}";
            }
            if (dmodel.Recycled > 0)
            {
                where += $@" and {nameof(RB_Material_Info.Recycled)}={dmodel.Recycled}";
            }

            string sql = $@"select * from RB_Material_Info where {where} order by Id desc";
            return Get<RB_Material_Info_Extend>(sql).ToList();
        }

        /// <summary>
        /// 分组下所有素材全回收
        /// </summary>
        /// <param name="groupId"></param>
        /// <param name="tenantId"></param>
        /// <param name="mallBaseId"></param>
        public bool SetMaterialInfoRecycled(int groupId, int tenantId, int mallBaseId)
        {
            string sql = $@" Update RB_Material_Info Set Recycled=2 where GroupId={groupId} and TenantId={tenantId} and MallBaseId={mallBaseId}";
            return Execute(sql) > 0;
        }

        /// <summary>
        /// 设置批量素材回收
        /// </summary>
        /// <param name="materialIds"></param>
        /// <param name="uid"></param>
        /// <param name="mallBaseId"></param>
        /// <returns></returns>
        public bool SetMaterialListRecycled(string materialIds, string uid, int mallBaseId)
        {
            string sql = $@" Update RB_Material_Info Set Recycled=2 where Id in({materialIds}) and TenantId={uid} and MallBaseId={mallBaseId} and Status=0";
            return Execute(sql) > 0;
        }

        /// <summary>
        /// 删除素材
        /// </summary>
        /// <param name="materialIds"></param>
        /// <param name="uid"></param>
        /// <param name="mallBaseId"></param>
        /// <param name="groupId"></param>
        /// <returns></returns>
        public bool DelMaterialInfo(string materialIds, string uid, int mallBaseId, int groupId = 0)
        {
            if (groupId > 0) {
                string sql1 = $@" Update RB_Material_Info Set Status=1 where GroupId ={groupId} and TenantId={uid} and MallBaseId={mallBaseId} and Status=0 and Recycled=2";
                return Execute(sql1) > 0;
            }
            string sql = $@" Update RB_Material_Info Set Status=1 where Id in({materialIds}) and TenantId={uid} and MallBaseId={mallBaseId} and Status=0 and Recycled=2";
            return Execute(sql) > 0;
        }

        /// <summary>
        /// 素材转移
        /// </summary>
        /// <param name="materialIds"></param>
        /// <param name="groupId"></param>
        /// <param name="uid"></param>
        /// <param name="mallBaseId"></param>
        /// <returns></returns>
        public bool SetMaterialInfoTransfer(string materialIds, int groupId, string uid, int mallBaseId)
        {
            string sql = $@" Update RB_Material_Info Set GroupId={groupId} where Id in({materialIds}) and TenantId={uid} and MallBaseId={mallBaseId} and Status=0 and Recycled=1";
            return Execute(sql) > 0;
        }
    }
}
